/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.actions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.core.util.DecompilerHelper;
import com.pnfsoftware.jeb.rcpclient.GlobalPosition;
import com.pnfsoftware.jeb.rcpclient.JebAddress;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.dialogs.DecompPropertiesDialog;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.handlers.HandlerUtil;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.parts.PartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.List;
import org.eclipse.swt.widgets.Shell;

public class ActionDecompileHandler
extends JebBaseHandler {
    private static final ILogger logger = GlobalLog.getLogger(ActionDecompileHandler.class);

    public ActionDecompileHandler() {
        super("decompile", S.s(475), null, "eclipse/debugt_obj.png");
        this.setAccelerator(9);
    }

    @Override
    public boolean canExecute() {
        if (this.part == null) {
            return false;
        }
        if (this.isDisableHandlers(this.part)) {
            return false;
        }
        IUnit unit = this.getActiveUnit();
        if (!(unit instanceof ICodeUnit) && !(unit instanceof ISourceUnit)) {
            return false;
        }
        JebAddress address = ActionDecompileHandler.getActiveAddress(this.part, AddressConversionPrecision.COARSE);
        return address != null && address.getAddress() != null;
    }

    @Override
    public void execute() {
        ActionDecompileHandler.execute(this.context, this.getShell(), this.part, null, false, true);
    }

    public static boolean execute(RcpClientContext context, Shell shell, IMPart part, String address, boolean withOptions, boolean focus) {
        UnitPartManager p;
        IMPart targetPart;
        IDecompilerUnit decompiler;
        if (part == null) {
            return false;
        }
        IUnit unit = ActionDecompileHandler.getActiveUnit(part);
        if (unit == null) {
            return false;
        }
        if (!HandlerUtil.isFullyProcessed(unit)) {
            logger.warn("The unit is not fully processed", new Object[0]);
            return false;
        }
        AbstractUnitFragment<?> activeFragment = ActionDecompileHandler.getActiveFragment(part);
        if (activeFragment == null) {
            Object[] cfr_ignored_0 = new Object[0];
            return false;
        }
        if (address == null && (address = activeFragment.getActiveAddress()) == null) {
            logger.info("Cannot determine where to decompile", new Object[0]);
            return false;
        }
        if (unit instanceof ISourceUnit) {
            decompiler = null;
        } else {
            decompiler = DecompilerHelper.getDecompiler(unit);
            if (decompiler == null) {
                if (!(unit.getParent() instanceof IUnit) || !((IUnit)unit.getParent()).getName().equals("decompiler")) {
                    List<String> availlist;
                    String codetype = unit.getFormatType();
                    StringBuilder msg = new StringBuilder();
                    Strings.ff(msg, "Your build does not provide decompilation support for this type of code (%s).", codetype);
                    if (context.getEnginesContext() != null) {
                        String avails = Strings.join(", ", DecompilerHelper.getAvailableDecompilerNames(context.getEnginesContext()));
                        Strings.ff(msg, "\n\nThe decompilers available with your license type are:\n%s", avails);
                    }
                    if (!Strings.isBlank(codetype) && !(availlist = DecompilerHelper.getBuildTypesWithDecompilationSupport(codetype)).isEmpty()) {
                        Strings.ff(msg, "\n\nDecompilation for %s is available in %s", codetype, Strings.join(", ", availlist));
                    }
                    if (!UI.popupOptional(shell, 0, "Decompiler not available", msg.toString(), "dlgDecompilerNotAvailable")) {
                        logger.warn("No decompiler available", new Object[0]);
                    }
                }
                return false;
            }
            if (!decompiler.isProcessed() && !decompiler.process()) {
                logger.warn("The decompiler is not ready!", new Object[0]);
                return false;
            }
            (new Object[1])[0] = decompiler;
        }
        PartManager pman = context.getPartManager();
        GlobalPosition pos0 = context.getViewManager().getCurrentGlobalPosition();
        if (decompiler != null) {
            List<UnitPartManager> targetParts;
            IUnit c;
            try {
                c = decompiler.getDecompiledUnit(address);
            }
            catch (Exception e) {
                context.getErrorHandler().processThrowableSilent(new RuntimeException("getDecompiledUnit() failed for: " + address, e));
                logger.error("An unexpected error occurred when attempting to retrieve the decompiled code for: %s", address);
                logger.error("Forcing a new decompilation...", new Object[0]);
                c = null;
            }
            Boolean forceTryInPlace = null;
            if (c == null || withOptions) {
                List<ISourceUnit> sources;
                if (withOptions) {
                    Object caption = "Decompilation options";
                    if (c != null) {
                        caption = "Re-decompilation Options";
                    }
                    DecompPropertiesDialog dlg = new DecompPropertiesDialog(shell, (String)caption, decompiler);
                    dlg.setDoNotReplaceViews(context.getUiProperties().getDoNotReplaceViews());
                    if (!dlg.open().booleanValue()) {
                        return false;
                    }
                    Boolean dnrViews = dlg.getDoNotReplaceViews();
                    Boolean bl = dnrViews == null ? null : (forceTryInPlace = Boolean.valueOf(dnrViews == false));
                }
                if (c != null) {
                    decompiler.removeChild(c);
                }
                if ((sources = HandlerUtil.decompileAsync(shell, context, decompiler, address)) == null || sources.isEmpty()) {
                    return false;
                }
                c = sources.get(0);
                if (sources.size() > 1) {
                    for (ISourceUnit source : sources) {
                        List<UnitPartManager> targetParts2 = pman.getPartManagersForUnit(source);
                        if (!targetParts2.isEmpty()) continue;
                        targetPart = pman.create(source, true).get(0);
                        pman.setOriginator(targetPart, part);
                    }
                }
            }
            if ((targetParts = pman.getPartManagersForUnit(c)).isEmpty()) {
                targetPart = pman.create(c, true, focus, forceTryInPlace).get(0);
                pman.setOriginator(targetPart, part);
            } else {
                targetPart = pman.getFirstPartForUnit(c);
                pman.setOriginator(targetPart, part);
                pman.activatePart(targetPart, focus);
            }
        } else {
            IUnitCreator parent = unit.getParent();
            if (!(parent instanceof IUnit)) {
                return false;
            }
            if (!((parent = ((IUnit)parent).getParent()) instanceof IUnit)) {
                return false;
            }
            IUnit disassembler = (IUnit)parent;
            List<IMPart> potentialOriginParts = pman.getPartsForUnit(disassembler);
            if (potentialOriginParts.isEmpty()) {
                targetPart = pman.create(disassembler, true, focus, null).get(0);
            } else {
                targetPart = ActionDecompileHandler.findFirstPartWithTextFragment(pman, potentialOriginParts);
                if (targetPart != null) {
                    pman.setOriginator(targetPart, part);
                    if (focus) {
                        pman.focus(targetPart);
                    }
                } else {
                    targetPart = pman.create(disassembler, false, focus, null).get(0);
                }
            }
        }
        if (targetPart != null && (p = pman.getUnitPartManager(targetPart)) != null) {
            p.setActiveAddress(address, null, false, false);
        }
        if (pos0 != null) {
            context.getViewManager().recordGlobalPosition(pos0);
        }
        return true;
    }

    static IMPart findFirstPartWithTextFragment(PartManager pman, List<IMPart> parts) {
        for (IMPart part : parts) {
            UnitPartManager p = pman.getUnitPartManager(part);
            if (Lists.newArrayList(Iterables.filter(p.getFragments(), TextFragment.class)).isEmpty()) continue;
            return part;
        }
        return null;
    }
}

