/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers.actions;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.impl.AbstractCommentManager;
import com.pnfsoftware.jeb.core.units.impl.Comment;
import com.pnfsoftware.jeb.rcpclient.actions.ActionUIContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.dialogs.CommentExDialog;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.rcpclient.handlers.actions.ActionGenericHandler;

public class ActionCommentHandler
extends JebBaseHandler {
    public static final String iconPath = "eclipse/comment_edit.png";

    public ActionCommentHandler() {
        super("comment", S.s(468), 0, "", iconPath, 47);
    }

    @Override
    public boolean canExecute() {
        if (this.isDisableHandlers(this.part)) {
            return false;
        }
        return this.getActiveUnit() instanceof IInteractiveUnit && this.getActiveAddress() != null;
    }

    @Override
    public void execute() {
        IInteractiveUnit unit = (IInteractiveUnit)this.getActiveUnit();
        AbstractCommentManager<?, ?> cm = unit.getCommentManager();
        if (cm == null) {
            ActionUIContext uictx = ActionGenericHandler.prepare(this.part, 3);
            if (uictx != null) {
                GraphicalActionExecutor executor = new GraphicalActionExecutor(this.getShell(), this.context);
                executor.execute(uictx);
            }
        } else {
            String addr = this.getActiveAddress();
            Comment comment = cm.getComment(addr);
            CommentExDialog dlg = new CommentExDialog(this.getShell(), this.getActiveAddress());
            dlg.setComment(comment);
            if (dlg.open() != null) {
                if (dlg.hasInlineCommentChanged()) {
                    cm.setPrimary(addr, dlg.getInline(), 0, true);
                }
                if (dlg.hasPreCommentChanged()) {
                    cm.setPrimary(addr, dlg.getPre(), -1, true);
                }
            }
        }
    }
}

