/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers;

import com.pnfsoftware.jeb.core.output.AddressConversionPrecision;
import com.pnfsoftware.jeb.core.output.IActionableItem;
import com.pnfsoftware.jeb.core.output.IItem;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.JebAddress;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPartManager;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilterText;
import com.pnfsoftware.jeb.rcpclient.operations.JebAction;
import com.pnfsoftware.jeb.rcpclient.parts.ProjectExplorerPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.SwitchableBinaryDataFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.TableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.TreeFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.CodeHierarchyFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.graphs.AbstractLocalGraphFragment;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class JebBaseHandler
extends JebAction {
    private static final ILogger logger = GlobalLog.getLogger(JebBaseHandler.class);
    protected RcpClientContext context;
    protected IMPart part;
    private boolean executing;

    public JebBaseHandler(String id, String name, String tooltip, String icon) {
        this(id, name, 0, tooltip, icon, 0);
    }

    public JebBaseHandler(String id, String name, int style, String tooltip, String icon, int accelerator) {
        super(id, name, style, tooltip, icon, accelerator);
        this.initialize();
    }

    protected void initialize() {
        if (this.executing) {
            return;
        }
        this.context = RcpClientContext.getInstance();
        if (this.context != null) {
            this.part = this.context.getPartManager().getActivePart();
        }
    }

    public IUnit getCurrentUnit() {
        return this.getCurrentUnit(this.part);
    }

    public IUnit getCurrentUnit(IMPart part) {
        ProjectExplorerPartManager tree;
        if (part == null) {
            return null;
        }
        IUnit unit = this.context.getPartManager().getUnitForPart(part);
        if (unit == null && part.getManager() instanceof ProjectExplorerPartManager && (tree = (ProjectExplorerPartManager)part.getManager()).getSelectedNode() instanceof IUnit) {
            unit = (IUnit)tree.getSelectedNode();
        }
        if (unit != null && unit.isDisposed()) {
            return null;
        }
        return unit;
    }

    public Shell getShell() {
        return UI.getShellTracker().get();
    }

    public boolean hasValidShell() {
        return this.getShell() != null;
    }

    @Override
    public boolean isEnabled() {
        if (this.executing) {
            return true;
        }
        this.initialize();
        return this.canExecute();
    }

    @Override
    public void run() {
        if (this.executing) {
            return;
        }
        this.executing = true;
        try {
            this.initialize();
            this.execute();
        }
        finally {
            this.executing = false;
        }
    }

    @Override
    public abstract boolean canExecute();

    @Override
    public abstract void execute();

    public boolean isDisableHandlers(IMPart part) {
        Control ctl = this.context.getDisplay().getFocusControl();
        if (ctl instanceof Text && ((Text)ctl).getEditable() || ctl instanceof StyledText && ((StyledText)ctl).getEditable()) {
            return true;
        }
        if (FilterText.isSelected()) {
            return true;
        }
        AbstractUnitFragment<?> fragment = JebBaseHandler.getActiveFragment(part);
        return !(fragment instanceof TextFragment) && !(fragment instanceof TableFragment) && !(fragment instanceof TreeFragment) && !(fragment instanceof CodeHierarchyFragment) && !(fragment instanceof AbstractLocalGraphFragment) && !(fragment instanceof SwitchableBinaryDataFragment);
    }

    public AbstractUnitFragment<?> getActiveFragment() {
        return JebBaseHandler.getActiveFragment(this.part);
    }

    public static AbstractUnitFragment<?> getActiveFragment(IMPart part) {
        IMPartManager object = part == null ? null : part.getManager();
        return !(object instanceof UnitPartManager) ? null : ((UnitPartManager)object).getActiveFragment();
    }

    public IUnit getActiveUnit() {
        return JebBaseHandler.getActiveUnit(this.part);
    }

    public static IUnit getActiveUnit(IMPart part) {
        IMPartManager object = part == null ? null : part.getManager();
        return !(object instanceof UnitPartManager) ? null : ((UnitPartManager)object).getUnit();
    }

    public String getActiveAddress() {
        IMPartManager object = this.part == null ? null : this.part.getManager();
        return !(object instanceof UnitPartManager) ? null : ((UnitPartManager)object).getActiveAddress();
    }

    public static JebAddress getActiveAddress(IMPart part, AddressConversionPrecision precision) {
        IMPartManager object = part == null ? null : part.getManager();
        return !(object instanceof UnitPartManager) ? null : ((UnitPartManager)object).getActiveAddress(precision);
    }

    public static String getActiveAddress(IMPart part) {
        IMPartManager object = part == null ? null : part.getManager();
        return !(object instanceof UnitPartManager) ? null : ((UnitPartManager)object).getActiveAddress();
    }

    public static IItem getActiveItem(IMPart part) {
        IMPartManager object = part == null ? null : part.getManager();
        return !(object instanceof UnitPartManager) ? null : ((UnitPartManager)object).getActiveItem();
    }

    public IItem getActiveItem() {
        IMPartManager object = this.part == null ? null : this.part.getManager();
        return !(object instanceof UnitPartManager) ? null : ((UnitPartManager)object).getActiveItem();
    }

    public static long getActiveItemId(IMPart part) {
        IItem item = JebBaseHandler.getActiveItem(part);
        if (item == null) {
            return 0L;
        }
        long itemId = item instanceof IActionableItem ? ((IActionableItem)((Object)item)).getItemId() : 0L;
        return itemId;
    }
}

