/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.handlers;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.IUnitCreator;
import com.pnfsoftware.jeb.core.units.INativeCodeUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.code.DecompilationContext;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodePackage;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.core.units.code.debug.IDebuggerUnit;
import com.pnfsoftware.jeb.core.util.DebuggerHelper;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.util.base.CallableWithProgressCallback;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class HandlerUtil {
    private static final ILogger logger = GlobalLog.getLogger(HandlerUtil.class);

    public static IDebuggerUnit getCurrentDebugger(IRcpClientContext context, IUnit unit) {
        if (unit instanceof IDebuggerUnit) {
            return (IDebuggerUnit)unit;
        }
        if (unit instanceof ICodeUnit) {
            return DebuggerHelper.getDebugger(unit, false);
        }
        return HandlerUtil.getCurrentDebuggerOld(context, unit);
    }

    @Deprecated
    public static IDebuggerUnit getCurrentDebuggerOld(IRcpClientContext context, IUnit baseUnit) {
        if (baseUnit != null) {
            if (baseUnit instanceof IDebuggerUnit) {
                return (IDebuggerUnit)baseUnit;
            }
            IUnit unit = baseUnit;
            while (true) {
                for (IUnit iUnit : unit.getChildren()) {
                    if (!(iUnit instanceof IDebuggerUnit)) continue;
                    return (IDebuggerUnit)iUnit;
                }
                IUnitCreator parent = unit.getParent();
                if (!(parent instanceof IUnit)) break;
                unit = (IUnit)parent;
            }
        }
        return null;
    }

    public static boolean isFullyProcessed(IUnit unit) {
        if (!unit.isProcessed()) {
            return false;
        }
        if (unit instanceof INativeCodeUnit) {
            return ((INativeCodeUnit)unit).isInitialAnalysisDone();
        }
        return true;
    }

    public static boolean isPendingAnalysis(IUnit unit) {
        if (!unit.isProcessed()) {
            return false;
        }
        if (unit instanceof INativeCodeUnit) {
            return !((INativeCodeUnit)unit).isAnalysisCompleted();
        }
        return false;
    }

    public static boolean processUnit(Shell shell, IRcpClientContext context, IUnit unit, boolean async) {
        boolean r = HandlerUtil.processUnitInternal(shell, context, unit, async);
        if (r && unit instanceof INativeCodeUnit && !((INativeCodeUnit)unit).isInitialAnalysisDone()) {
            ((INativeCodeUnit)unit).performInitialAnalysis();
        }
        return r;
    }

    private static boolean processUnitInternal(Shell shell, IRcpClientContext context, final IUnit unit, boolean async) {
        Boolean success;
        if (unit.isProcessed()) {
            return true;
        }
        if (unit.getStatus() != null) {
            String msg = Strings.ff("Processing of unit \"%s\" (%s) was attempted and failed.\n\nWould you like to try again?", unit.getName(), unit.getFormatType());
            MessageBox mb = new MessageBox(shell, 200);
            mb.setText(S.s(304));
            mb.setMessage(msg);
            int r = mb.open();
            if (r != 64) {
                return false;
            }
        }
        if (!async) {
            success = unit.process();
        } else {
            String taskName = Strings.ff("Processing: %s...", unit.getName());
            success = context.executeTask(taskName, new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return unit.process();
                }
            });
        }
        if (success == null || !success.booleanValue()) {
            Object msg = Strings.ff("%s. %s:\n\"%s\"\n\n", S.s(789), S.s(748), unit.getStatus());
            msg = (String)msg + Strings.ff("%s (%s)", S.s(662), S.s(603));
            MessageBox mb = new MessageBox(shell, 200);
            mb.setText(S.s(304));
            mb.setMessage((String)msg);
            int r = mb.open();
            if (r != 64) {
                return false;
            }
        }
        return true;
    }

    private static void getDecompilableAddresses(IDecompilerUnit decompiler, ICodeItem root, List<String> addresses) {
        if (root instanceof ICodePackage) {
            List<? extends ICodeItem> children = ((ICodePackage)root).getChildren();
            for (ICodeItem iCodeItem : children) {
                HandlerUtil.getDecompilableAddresses(decompiler, iCodeItem, addresses);
            }
            return;
        }
        String address = root.getAddress();
        if (decompiler.canDecompile(address)) {
            addresses.add(address);
        }
    }

    public static List<ISourceUnit> decompileAsync(Shell shell, IRcpClientContext context, final IDecompilerUnit decompiler, String address) {
        logger.trace("UI: request to decompile at address %s using %s", address, decompiler);
        final ArrayList<String> addresses = new ArrayList<String>();
        if (decompiler.canDecompile(address)) {
            addresses.add(address);
        } else {
            long itemId = decompiler.getCodeUnit().getItemAtAddress(address);
            Object item = decompiler.getCodeUnit().getItemObject(itemId);
            if (item instanceof ICodePackage) {
                HandlerUtil.getDecompilableAddresses(decompiler, (ICodePackage)item, addresses);
            }
            if (addresses.isEmpty()) {
                return null;
            }
        }
        context.getTelemetry().record("handlerDecompile", "decompilerUnitType", decompiler.getFormatType());
        String taskName = Strings.ff("%s: %s...", S.s(246), address);
        CallableWithProgressCallback<List<ISourceUnit>> callable = new CallableWithProgressCallback<List<ISourceUnit>>(){

            @Override
            public List<ISourceUnit> call() {
                ArrayList<ISourceUnit> sources = new ArrayList<ISourceUnit>();
                for (String address : addresses) {
                    this.callback.setCurrent(0L);
                    this.callback.setTotal(0L);
                    DecompilationContext ctx = new DecompilationContext();
                    ctx.setCallback(this.callback);
                    ISourceUnit decomp = decompiler.decompileToUnit(address, ctx);
                    if (decomp == null) continue;
                    sources.add(decomp);
                }
                return sources;
            }
        };
        List<ISourceUnit> r = context.executeTaskWithPopupDelay(1000, taskName, false, callable);
        return r;
    }
}

