/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.webbrowser;

import com.pnfsoftware.jeb.rcpclient.extensions.ViewerRefresher;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.WebBrowserView;
import com.pnfsoftware.jeb.rcpclient.extensions.webbrowser.IWebBrowserSource;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class WebBrowserViewer
extends Viewer {
    private static final ILogger logger = GlobalLog.getLogger(WebBrowserViewer.class);
    private IWebBrowserSource input;
    private IEventListener inputListener;
    private Composite container;
    private WebBrowserView widget;
    private ViewerRefresher refresher = null;

    public WebBrowserViewer(Composite parent) {
        this.container = parent;
    }

    public WebBrowserView getControl() {
        return this.widget;
    }

    @Override
    public IWebBrowserSource getInput() {
        return this.input;
    }

    @Override
    public void refresh() {
        if (this.widget != null) {
            this.widget.dispose();
            this.widget = null;
        }
        if (this.input != null) {
            this.widget = new WebBrowserView(this.container, this.input);
            this.container.layout();
        }
    }

    @Override
    public void setInput(Object input) {
        if (this.inputListener != null) {
            this.input.removeListener(this.inputListener);
            this.inputListener = null;
        }
        if (this.refresher == null) {
            this.refresher = new ViewerRefresher(this.container.getDisplay(), this);
        }
        this.input = (IWebBrowserSource)input;
        this.inputListener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                (new Object[1])[0] = e;
                WebBrowserViewer.this.refresher.request();
            }
        };
        this.input.addListener(this.inputListener);
        this.refresh();
    }

    @Override
    public void setSelection(ISelection selection, boolean reveal) {
    }

    @Override
    public ISelection getSelection() {
        return null;
    }
}

