/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.webbrowser;

import com.pnfsoftware.jeb.rcpclient.extensions.webbrowser.IWebBrowserSource;
import com.pnfsoftware.jeb.util.encoding.MimeType;
import com.pnfsoftware.jeb.util.events.EventSource;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.io.IO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Base64;

public class WebBrowserSource
extends EventSource
implements IWebBrowserSource {
    private boolean url = false;
    private boolean svgImage = false;
    private final String name;
    private final String text;
    private String background;
    private int width = -1;
    private int height = -1;

    public WebBrowserSource(String name, byte[] data) throws IOException {
        this(name, data, "#FFFFFF");
    }

    public WebBrowserSource(String name, byte[] data, String bgColor) throws IOException {
        this.name = name;
        boolean binary = true;
        this.background = bgColor;
        int wspcnt = Strings.getInitialBlankSize(new ByteArrayInputStream(data), true, '\f');
        if (wspcnt < data.length && data[wspcnt] == 60) {
            binary = false;
        }
        if (MimeType.determineFromContent(data).equals("image/webp")) {
            this.text = "<html><body style='margin: 0px;padding: 0px;'><img style='background-color:" + bgColor + ";' src='data:image/webp;base64," + Base64.getEncoder().encodeToString(data) + "'/></body></html>";
        } else if (binary || (long)data.length > 10000000L) {
            this.url = true;
            File tmp = IO.createTempFile();
            tmp.deleteOnExit();
            IO.writeFile(tmp, data);
            this.text = "file://" + tmp.getAbsolutePath();
        } else {
            this.text = new String(data, "UTF-8");
        }
        if (!binary) {
            for (int i = 0; i < 10000 && i < data.length; ++i) {
                if (data[i] != 60 || i + 3 >= data.length) continue;
                if (data[i + 1] == 115 && data[i + 2] == 118 && data[i + 3] == 103 && (data[i + 4] == 62 || data[i + 4] == 32)) {
                    this.svgImage = true;
                } else if (data[i + 1] == 63 || data[i + 1] == 33) {
                    continue;
                }
                break;
            }
        } else if (MimeType.determineFromContent(data).equals("image/webp")) {
            String type = new String(data, 12, 4, Charset.defaultCharset());
            int headerSize = 12;
            switch (type) {
                case "VP8L": {
                    int raw = data[21] & 0xFF | (data[22] & 0xFF) << 8 | (data[23] & 0xFF) << 16 | (data[22] & 0xFF) << 24;
                    this.width = this.BITS_GET(raw, 0, 14) + 1;
                    this.height = this.BITS_GET(raw, 14, 14) + 1;
                    break;
                }
                case "VP8 ": {
                    this.width = this.getLE14(data, headerSize + 6);
                    this.height = this.getLE14(data, headerSize + 8);
                    break;
                }
                case "VP8X": {
                    this.width = 1 + this.getLE24(data, headerSize + 12);
                    this.height = 1 + this.getLE24(data, headerSize + 15);
                }
            }
        }
    }

    private int BITS_GET(int raw, int offset, int length) {
        int value = raw >>> offset;
        int mask = (1 << length) - 1;
        return value & mask;
    }

    private int getLE14(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0x3F) << 8;
    }

    private int getLE24(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16;
    }

    @Override
    public boolean isUrl() {
        return this.url;
    }

    @Override
    public boolean isImage() {
        return this.svgImage;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUrl() {
        return this.url ? this.text : null;
    }

    @Override
    public String getText() {
        return this.url ? null : this.text;
    }

    @Override
    public int getWidthHint() {
        return this.width;
    }

    @Override
    public int getHeightHint() {
        return this.height;
    }

    @Override
    public String getBackground() {
        return this.background;
    }

    @Override
    public void dispose() {
    }
}

