/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup;

public class SeparatorRule {
    private String separator;
    private String suffix;
    private boolean packageSeparator = false;
    private char[] blacklistChars = null;
    private char[] closables = null;

    public SeparatorRule(String separator, String suffix, boolean packageSeparator) {
        this(separator, suffix, packageSeparator, new char[0], new char[0]);
    }

    public SeparatorRule(String separator, String suffix, boolean packageSeparator, char[] blacklistChars, char[] endChars) {
        this.separator = separator;
        this.suffix = suffix;
        this.packageSeparator = packageSeparator;
        this.blacklistChars = blacklistChars;
        this.closables = endChars;
    }

    public String format(String startExpression) {
        String str = startExpression;
        if (startExpression.endsWith(this.separator)) {
            str = startExpression.substring(0, startExpression.length() - this.separator.length());
        }
        return str + this.suffix;
    }

    public String getStartExpression(String label, int from) {
        if (label == null) {
            return null;
        }
        int closers = 0;
        for (int idx = from; idx < label.length(); ++idx) {
            for (char c : this.blacklistChars) {
                if (label.charAt(idx) != c) continue;
                return null;
            }
            for (int j = 0; j < this.closables.length; j += 2) {
                if (label.charAt(idx) == this.closables[j]) {
                    ++closers;
                    continue;
                }
                if (label.charAt(idx) != this.closables[j + 1]) continue;
                --closers;
            }
            if (closers != 0 || !label.startsWith(this.separator, idx)) continue;
            boolean alphanum = false;
            for (int i = from; i < idx + this.separator.length(); ++i) {
                if (!Character.isLetterOrDigit(label.charAt(i))) continue;
                alphanum = true;
                break;
            }
            if (!alphanum) continue;
            return label.substring(0, idx + this.separator.length());
        }
        return null;
    }

    public String getStartExpression(String label, String fromStartExpression) {
        return this.getStartExpression(label, fromStartExpression.length());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.packageSeparator ? 1231 : 1237);
        result = 31 * result + (this.separator == null ? 0 : this.separator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SeparatorRule other = (SeparatorRule)obj;
        if (this.packageSeparator != other.packageSeparator) {
            return false;
        }
        return !(this.separator == null ? other.separator != null : !this.separator.equals(other.separator));
    }

    public boolean isPackage() {
        return this.packageSeparator;
    }
}

