/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup;

import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.IArrayGroup;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ArrayGroup
implements IArrayGroup {
    TreeMap<Integer, Object> children = new TreeMap();
    Object parent = null;

    public ArrayGroup(Object parent) {
        this.parent = parent;
    }

    public void put(int index, Object child) {
        this.children.put(index, child);
    }

    @Override
    public int getReferenceIndex() {
        if (this.children.isEmpty()) {
            return -1;
        }
        return this.children.firstKey();
    }

    @Override
    public int getEndIndex() {
        if (this.children.isEmpty()) {
            return -1;
        }
        return this.children.lastKey();
    }

    @Override
    public boolean containsIndex(int index) {
        if (this.children.isEmpty()) {
            return false;
        }
        if (this.children.containsKey(index)) {
            return true;
        }
        for (Map.Entry<Integer, Object> e : this.children.entrySet()) {
            if (!(e.getValue() instanceof IArrayGroup) || !((IArrayGroup)e.getValue()).containsIndex(index)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getFirstElement() {
        if (this.children.isEmpty()) {
            return null;
        }
        Object first = this.children.get(this.children.firstKey());
        if (first instanceof IArrayGroup) {
            return ((IArrayGroup)first).getFirstElement();
        }
        return first;
    }

    @Override
    public Object getLastElement() {
        if (this.children.isEmpty()) {
            return null;
        }
        Object last = this.children.get(this.children.lastKey());
        if (last instanceof IArrayGroup) {
            return ((IArrayGroup)last).getLastElement();
        }
        return last;
    }

    @Override
    public boolean isSingle() {
        return this.children.size() == 1;
    }

    @Override
    public int count() {
        return this.children.size();
    }

    @Override
    public String getGroupName() {
        return null;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getReferenceIndex();
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArrayGroup)) {
            return false;
        }
        ArrayGroup other = (ArrayGroup)obj;
        if (this.children.size() != other.children.size()) {
            return false;
        }
        if (!this.children.isEmpty() && this.children.firstKey().intValue() != other.children.firstKey().intValue()) {
            return false;
        }
        if (this.parent == null || other.parent == null) {
            return false;
        }
        return this.parent.equals(other.getParent());
    }

    @Override
    public Iterator<Object> iterator() {
        return this.children.values().iterator();
    }

    public void clear() {
        this.children.clear();
    }

    public Object[] toArray() {
        return this.children.values().toArray();
    }
}

