/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.ViewerRefresher;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.WindowExplorerView;
import com.pnfsoftware.jeb.util.events.IEvent;
import com.pnfsoftware.jeb.util.events.IEventListener;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class WindowExplorerViewer
extends Viewer {
    private static final ILogger logger = GlobalLog.getLogger(WindowExplorerViewer.class);
    private IUnit input;
    private IEventListener inputListener;
    private Composite container;
    private IRcpClientContext context;
    private WindowExplorerView widget;
    private ViewerRefresher refresher = null;

    public WindowExplorerViewer(Composite parent, IRcpClientContext context) {
        this.container = parent;
        this.context = context;
    }

    public WindowExplorerView getControl() {
        return this.widget;
    }

    @Override
    public IUnit getInput() {
        return this.input;
    }

    @Override
    public void refresh() {
        if (this.widget == null) {
            this.widget = new WindowExplorerView(this.container, this.input, this.context);
            this.widget.setLayoutData(UIUtil.createGridDataFill(true, true));
            this.widget.addUnitModifiedListener(e -> this.setInput(e.data, false, false));
            this.container.layout();
        } else {
            this.widget.updateContent();
            this.widget.layout(true, true);
        }
    }

    @Override
    public void setInput(Object input) {
        this.setInput(input, true, true);
    }

    public void setInput(Object input, boolean updateWidget, boolean notify) {
        if (this.input == input) {
            return;
        }
        if (this.inputListener != null) {
            this.input.removeListener(this.inputListener);
            this.inputListener = null;
        }
        if (this.refresher == null) {
            this.refresher = new ViewerRefresher(this.container.getDisplay(), this);
        }
        this.input = (IUnit)input;
        if (this.widget != null && updateWidget) {
            this.widget.setUnit(this.input, notify);
        }
        this.inputListener = new IEventListener(){

            @Override
            public void onEvent(IEvent e) {
                (new Object[1])[0] = e;
                WindowExplorerViewer.this.refresher.request();
            }
        };
        this.input.addListener(this.inputListener);
        this.refresh();
    }

    @Override
    public void setSelection(ISelection selection, boolean reveal) {
    }

    @Override
    public ISelection getSelection() {
        return null;
    }
}

