/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import com.pnfsoftware.jeb.rcpclient.extensions.viewers.TreeViewerExpandedState;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.IArrayGroup;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class TreeStateMaintainer<T> {
    private TreeViewer viewer;

    public TreeStateMaintainer() {
    }

    public TreeStateMaintainer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public State<T> saveState() {
        Tree tree = this.viewer.getTree();
        State state = new State();
        for (TreeItem topItem = tree.getTopItem(); topItem != null; topItem = topItem.getParentItem()) {
            Object object = topItem.getData();
            state.pathForTop.add(0, object);
        }
        state.expandedTree = new Node<Object>(null);
        this.saveExpansionState(tree, state.expandedTree);
        return state;
    }

    public void appendTreePath(Object state, TreePath tp) {
        State _state = (State)state;
        this.saveTreePathState(tp, _state.expandedTree, 0);
    }

    private void saveTreePathState(TreePath tp, Node<T> node, int index) {
        if (index >= tp.getSegmentCount()) {
            return;
        }
        Object segment = tp.getSegment(index);
        Node<Object> matchingChild = null;
        for (Node child : node.children) {
            if (!this.equals(segment, child.object)) continue;
            matchingChild = child;
            break;
        }
        if (matchingChild == null) {
            matchingChild = node.addChild(segment);
        }
        this.saveTreePathState(tp, matchingChild, index + 1);
    }

    private void saveExpansionState(Object item, Node<T> node) {
        TreeItem[] childrenItems;
        for (TreeItem childItem : childrenItems = TreeStateMaintainer.getChildrenItems(item)) {
            if (!childItem.getExpanded()) continue;
            Node<Object> c = node.addChild(childItem.getData());
            this.saveExpansionState(childItem, c);
        }
    }

    public void restoreState(Object state) {
        State _state = (State)state;
        Tree tree = this.viewer.getTree();
        TreeViewerExpandedState expandedState = new TreeViewerExpandedState();
        this.restoreExpansionState(tree, _state.expandedTree, expandedState.createRootPath());
        Tree base = tree;
        TreeItem matchedItem = null;
        for (Object previousObject : _state.pathForTop) {
            matchedItem = null;
            for (TreeItem item : TreeStateMaintainer.getChildrenItems(base)) {
                if (!this.equals(item.getData(), previousObject)) continue;
                matchedItem = item;
                break;
            }
            if (matchedItem == null) break;
            base = matchedItem;
        }
        if (matchedItem != null) {
            tree.setTopItem(matchedItem);
        }
    }

    private void restoreExpansionState(Object base, Node<T> node, TreeViewerExpandedState.TreeViewerPath expandedPath) {
        for (Node c : node.children) {
            TreeItem item = this.findMatchingItem(base, c.object);
            if (item == null) break;
            expandedPath.addTreePath(item.getData());
            if (!item.getExpanded()) {
                expandedPath.expand(this.viewer);
            }
            this.restoreExpansionState(item, c, expandedPath.createChildPath(item.getData()));
        }
    }

    public static final TreeItem[] getChildrenItems(Object base) {
        if (base instanceof Tree) {
            return ((Tree)base).getItems();
        }
        if (base instanceof TreeItem) {
            return ((TreeItem)base).getItems();
        }
        return null;
    }

    TreeItem findMatchingItem(Object base, T previousObject) {
        TreeItem[] items;
        for (TreeItem item : items = TreeStateMaintainer.getChildrenItems(base)) {
            Object currentObject = item.getData();
            if (!this.equals(currentObject, previousObject)) continue;
            return item;
        }
        return null;
    }

    private boolean equals(T currentObject, T previousObject) {
        if (currentObject == previousObject) {
            return true;
        }
        if (currentObject == null || previousObject == null) {
            return false;
        }
        if (currentObject instanceof IArrayGroup && previousObject instanceof IArrayGroup) {
            if (((IArrayGroup)currentObject).getGroupName() != null) {
                return Strings.equals(((IArrayGroup)currentObject).getGroupName(), ((IArrayGroup)previousObject).getGroupName());
            }
            return ((IArrayGroup)currentObject).getReferenceIndex() == ((IArrayGroup)previousObject).getReferenceIndex();
        }
        if (currentObject.getClass() != previousObject.getClass()) {
            return false;
        }
        return this.likeEquals(currentObject, previousObject);
    }

    public abstract boolean likeEquals(T var1, T var2);

    public static class State<T> {
        List<T> pathForTop = new ArrayList<T>();
        Node<T> expandedTree;
    }

    private static class Node<T> {
        T object;
        List<Node<T>> children = new ArrayList<Node<T>>();

        Node(T o) {
            this.object = o;
        }

        Node<T> addChild(T o) {
            Node<T> c = new Node<T>(o);
            this.children.add(c);
            return c;
        }

        public String toString() {
            return this.object == null ? "null" : this.object.toString();
        }
    }
}

