/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.extensions.filter.AbstractFilteredFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeContentProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeViewerExtension;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.TreeStateMaintainer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.ArrayGroup;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.IArrayGroup;
import com.pnfsoftware.jeb.util.collect.IdentityHashSet;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class RegexTreeViewerFilter
extends AbstractFilteredFilter {
    private static final int FILTER_TIME_LIMIT_PER_ROOT_NODE = 1000;
    private static final int TP_LIMIT = 200;
    private static final ILogger logger = GlobalLog.getLogger(RegexTreeViewerFilter.class);
    private FilteredTreeViewer treeViewer;
    private IFilteredTreeViewerExtension extension;
    private Set<Object> parentMatches = new HashSet<Object>();
    private Set<Object> matches = new HashSet<Object>();
    private Set<Object> childrenMatches = new HashSet<Object>();
    private Set<Object> unmatches = new HashSet<Object>();
    private Set<Object> circular = new IdentityHashSet<Object>();
    private List<Object> pending = new ArrayList<Object>();
    private Map<ArrayGroup, Map<Object, FilteredArrayGroup>> filteredArrayGroup = new WeakHashMap<ArrayGroup, Map<Object, FilteredArrayGroup>>();
    private Object root = null;
    private DisposeListener disposeListener = null;
    private List<FilteredGroup> maxDepths = new ArrayList<FilteredGroup>();
    private List<FilteredGroup> maxDepthsPlusOne = new ArrayList<FilteredGroup>();
    private FilteredGroup currentGroup = null;
    private Thread maxDepthSearch;
    private boolean maxDepthSearchKill = false;
    private int expanded = 0;

    static TreePath convertFromFiltered(TreePath tp) {
        int i;
        ArrayList<Object> tpAsList = new ArrayList<Object>();
        ArrayList<Object> resAsList = new ArrayList<Object>();
        for (i = 0; i < tp.getSegmentCount(); ++i) {
            tpAsList.add(tp.getSegment(i));
        }
        for (i = 0; i < tpAsList.size(); ++i) {
            if (tpAsList.get(i) instanceof FilteredArrayGroup) {
                FilteredArrayGroup src = (FilteredArrayGroup)tpAsList.get(i);
                resAsList.add(src.getSource());
                resAsList.add(src.getFirstElement());
                continue;
            }
            resAsList.add(tpAsList.get(i));
        }
        return new TreePath(resAsList.toArray());
    }

    TreePath convertToFiltered(TreePath tp) {
        int i;
        ArrayList<Object> tpAsList = new ArrayList<Object>();
        ArrayList<FilteredArrayGroup> resAsList = new ArrayList<FilteredArrayGroup>();
        for (i = 0; i < tp.getSegmentCount(); ++i) {
            tpAsList.add(tp.getSegment(i));
        }
        for (i = 0; i < tpAsList.size(); ++i) {
            FilteredArrayGroup fag;
            Map<Object, FilteredArrayGroup> fagMap = this.filteredArrayGroup.get(tpAsList.get(i));
            if (fagMap != null && i + 1 < tpAsList.size() && (fag = fagMap.get(tpAsList.get(i + 1))) != null) {
                resAsList.add(fag);
                if (!fag.isSingle()) continue;
                ++i;
                continue;
            }
            resAsList.add((FilteredArrayGroup)tpAsList.get(i));
        }
        return new TreePath(resAsList.toArray());
    }

    public RegexTreeViewerFilter(TreeViewer viewer, FilteredTreeViewer treeViewer) {
        super(viewer);
        this.treeViewer = treeViewer;
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RegexTreeViewerFilter.this.resetCache();
                RegexTreeViewerFilter.this.getViewer().getControl().removeDisposeListener(RegexTreeViewerFilter.this.disposeListener);
                RegexTreeViewerFilter.this.root = null;
            }
        };
        this.getViewer().getControl().addDisposeListener(this.disposeListener);
    }

    @Override
    public TreeViewer getViewer() {
        return (TreeViewer)super.getViewer();
    }

    private Map<Object, FilteredArrayGroup> getFilteredArrayGroup(ArrayGroup ag) {
        Map<Object, FilteredArrayGroup> filtered = this.filteredArrayGroup.get(ag);
        if (filtered == null) {
            filtered = new WeakHashMap<Object, FilteredArrayGroup>();
            this.filteredArrayGroup.put(ag, filtered);
        }
        return filtered;
    }

    @Override
    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        int i;
        RegexTreeViewerFilter regexTreeViewerFilter = this;
        synchronized (regexTreeViewerFilter) {
            if (this.patternChanged || !this.isFiltered() || this.isFiltered() && this.root == null || this.isFiltered() && this.root != null && this.root == parent && (elements == null || elements.length == 0)) {
                this.resetCache();
                this.patternChanged = false;
                this.root = parent;
                if (this.extension != null) {
                }
            }
        }
        Object[] res = super.filter(viewer, parent, elements);
        if (this.isFiltered() && res.length == 1 && res[i = 0] instanceof ArrayGroup) {
            Object[] children = this.filter(viewer, res[i], this.getChildren(res[i]));
            if (children.length == 1) {
                FilteredArrayGroup virtualAG = new FilteredArrayGroup((ArrayGroup)res[i], parent);
                virtualAG.put(0, children[0]);
                this.getFilteredArrayGroup((ArrayGroup)res[i]).put(children[0], virtualAG);
                return new Object[]{virtualAG};
            }
            ArrayList<FilteredArrayGroup> virtualAGs = new ArrayList<FilteredArrayGroup>();
            int firstIndex = 0;
            for (Object child : children) {
                FilteredArrayGroup virtualAG = new FilteredArrayGroup((ArrayGroup)res[i], parent);
                virtualAG.put(firstIndex, child);
                ++firstIndex;
                this.getFilteredArrayGroup((ArrayGroup)res[i]).put(child, virtualAG);
                virtualAGs.add(virtualAG);
            }
            return virtualAGs.toArray();
        }
        return res;
    }

    private void interruptMaxDepthSearch() {
        Thread t;
        List<Object> list = this.pending;
        synchronized (list) {
            t = this.maxDepthSearch;
        }
        if (t != null && t.isAlive()) {
            t.interrupt();
        }
    }

    private Thread getMaxDepthSearch() {
        List<Object> list = this.pending;
        synchronized (list) {
            if (this.maxDepthSearch == null || !this.maxDepthSearch.isAlive()) {
                return null;
            }
            return this.maxDepthSearch;
        }
    }

    synchronized void resetCache() {
        if (this.maxDepthSearch != null) {
            this.maxDepthSearchKill = true;
            this.interruptMaxDepthSearch();
            try {
                Thread t;
                int i = 0;
                while ((t = this.getMaxDepthSearch()) != null) {
                    t.join(1000L);
                    if (++i <= 10) continue;
                    return;
                }
                this.maxDepthSearchKill = false;
            }
            catch (InterruptedException interruptedException) {}
            this.maxDepthSearch = null;
        }
        this.root = null;
        this.matches.clear();
        this.parentMatches.clear();
        this.childrenMatches.clear();
        this.unmatches.clear();
        this.circular.clear();
        this.pending.clear();
        this.filteredArrayGroup.clear();
        List<FilteredGroup> list = this.maxDepths;
        synchronized (list) {
            this.maxDepths.clear();
            this.maxDepthsPlusOne.clear();
        }
        this.currentGroup = null;
    }

    @Override
    public void inputChanged() {
        super.inputChanged();
        this.resetCache();
    }

    @Override
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        List<Object> list;
        if (!this.isFiltered()) {
            return true;
        }
        ArrayList<Object> parents = new ArrayList<Object>();
        parents.add(parentElement);
        FilteredElement f = new FilteredElement(element, parents, 0);
        ArrayList<FilteredGroup> unanalyzedGroups = new ArrayList<FilteredGroup>();
        ArrayList<FilteredGroup> unanalyzedDepthGroups = new ArrayList<FilteredGroup>();
        Boolean res = null;
        if (!this.isPending(element)) {
            res = this.selectAll(f, unanalyzedGroups, unanalyzedDepthGroups);
        }
        if (!unanalyzedGroups.isEmpty() && parentElement == this.root) {
            list = this.maxDepths;
            synchronized (list) {
                this.maxDepths.addAll(unanalyzedGroups);
                this.maxDepthsPlusOne.addAll(unanalyzedDepthGroups);
                this.addPending(element);
            }
        }
        list = this.pending;
        synchronized (list) {
            if (this.maxDepthSearch == null && !unanalyzedGroups.isEmpty()) {
                this.maxDepthSearch = ThreadUtil.create(() -> this.resolveMaxDepth());
                this.maxDepthSearch.setName("Regex Filter");
                this.maxDepthSearch.start();
            }
        }
        if (res != null) {
            return res;
        }
        return this.select(f, 0, new ArrayList<FilteredElement>(), null) != SearchResult.NO_MATCH;
    }

    private Boolean selectAll(FilteredElement f, List<FilteredGroup> unanalyzedGroups, List<FilteredGroup> unanalyzedDepthGroups) {
        long time0 = System.currentTimeMillis();
        ArrayList<FilteredElement> unanalyzed = new ArrayList<FilteredElement>();
        SearchResult res0 = this.select(f, f.depth + 1, unanalyzed, null);
        if (res0 == SearchResult.NO_MATCH || res0 == SearchResult.CIRCULAR) {
            return false;
        }
        if (res0.isMatch()) {
            return true;
        }
        if (!unanalyzed.isEmpty()) {
            unanalyzedGroups.add(new FilteredGroup(f, unanalyzed));
        }
        while (!unanalyzedGroups.isEmpty() && System.currentTimeMillis() - time0 <= 1000L) {
            FilteredGroup g = unanalyzedGroups.remove(0);
            this.selectFilteredGroup(g, unanalyzedDepthGroups);
            if (!unanalyzedGroups.isEmpty()) continue;
            unanalyzedGroups.addAll(unanalyzedDepthGroups);
            unanalyzedDepthGroups.clear();
        }
        return null;
    }

    private Map<FilteredElement, SearchResult> selectFilteredGroup(FilteredGroup g, List<FilteredGroup> unanalyzedDepthGroups) {
        boolean refreshParents = true;
        boolean match = false;
        HashMap<FilteredElement, SearchResult> result = new HashMap<FilteredElement, SearchResult>();
        for (FilteredElement f : g.filteredElements) {
            if (this.maxDepthSearchKill) {
                return result;
            }
            ArrayList<FilteredElement> unanalyzedDepth = new ArrayList<FilteredElement>();
            SearchResult res = this.select(f, f.depth + 1, unanalyzedDepth, result);
            result.put(f, res);
            if (res == SearchResult.MAX_DEPTH_REACHED) {
                refreshParents = false;
            }
            if (res == SearchResult.ELEMENT_MATCH || res == SearchResult.CHILDREN_MATCH) {
                match = true;
            }
            if (unanalyzedDepth.isEmpty()) continue;
            FilteredGroup fg = new FilteredGroup(f, unanalyzedDepth);
            unanalyzedDepthGroups.add(fg);
        }
        if (refreshParents || match) {
            this.propagateResultToParents(match, new ArrayList<Object>(g.filteredElements.get((int)0).parents));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public SearchResult select(FilteredElement f, int maxDepth, List<FilteredElement> unanalyzed, Map<FilteredElement, SearchResult> childrenResults) {
        boolean elementMatch;
        if (this.extension != null && this.extension.shouldIgnore(f.parents, f.element)) {
            return SearchResult.NO_MATCH;
        }
        if (this.isMatch(f.element)) {
            return SearchResult.ELEMENT_MATCH;
        }
        if (this.isChildrenMatch(f.element)) {
            if (childrenResults != null && !this.treeViewer.getMaxDepth().isMaxDepthReached(f.depth, maxDepth) && !childrenResults.containsKey(f)) {
                childrenResults.put(f, SearchResult.CHILDREN_MATCH);
                this.selectChildren(f, maxDepth, new ArrayList<FilteredElement>(), childrenResults);
            }
            return SearchResult.CHILDREN_MATCH;
        }
        if (this.isParentMatches(f.element)) {
            return SearchResult.PARENT_MATCH;
        }
        if (this.isMatchOrParentMatch(f.parents.get(f.parents.size() - 1))) {
            if (!(f.element instanceof String)) {
                this.parentMatches.add(f.element);
            }
            return SearchResult.PARENT_MATCH;
        }
        if (this.isUnmatch(f.element)) {
            return SearchResult.NO_MATCH;
        }
        if (this.extension != null) {
            Boolean extensionMatch = this.extension.isElementMatch(f.parents, f.element, this);
            if (extensionMatch != null) {
                if (!extensionMatch.booleanValue()) {
                    this.addUnmatch(f.element);
                    return SearchResult.NO_MATCH;
                }
                elementMatch = true;
            } else {
                elementMatch = this.isElementMatch(f.element);
            }
        } else {
            elementMatch = this.isElementMatch(f.element);
        }
        if (elementMatch) {
            this.addMatch(f.element);
            return SearchResult.ELEMENT_MATCH;
        }
        if (this.circular.contains(f.element)) {
            return SearchResult.CIRCULAR;
        }
        if (this.root == f.parents.get(0) && this.selfReferenceExists(f.parents, f.element, f.parents.size() - 1)) {
            this.circular.add(f.element);
            return SearchResult.CIRCULAR;
        }
        if (this.root != f.parents.get(0)) {
            if (!this.hasChildren(f.element)) {
                return SearchResult.NO_MATCH;
            }
            return SearchResult.MAX_DEPTH_REACHED;
        }
        if (this.treeViewer.getMaxDepth().isMaxDepthReached(f.depth, maxDepth) && this.hasChildren(f.element) && !(f.element instanceof IArrayGroup)) {
            this.saveMaxDepth(f, unanalyzed);
            return SearchResult.MAX_DEPTH_REACHED;
        }
        return this.selectChildren(f, maxDepth, unanalyzed, childrenResults);
    }

    private SearchResult selectChildren(FilteredElement f, int maxDepth, List<FilteredElement> unanalyzed, Map<FilteredElement, SearchResult> childrenResults) {
        if (this.hasChildren(f.element)) {
            Object[] children = this.getChildren(f.element);
            if (children == null) {
                return SearchResult.NO_MATCH;
            }
            SearchResult childrenMatch = SearchResult.NO_MATCH;
            ArrayList<Object> newParents = new ArrayList<Object>(f.parents);
            newParents.add(f.element);
            block25: for (Object child : children) {
                if (this.maxDepthSearchKill) {
                    return SearchResult.MAX_DEPTH_REACHED;
                }
                FilteredElement fChild = new FilteredElement(child, newParents, FilteredTreeViewer.MaxDepth.incrementDepth(f.depth, f.element));
                SearchResult childMatch = this.select(fChild, maxDepth, unanalyzed, childrenResults);
                switch (childMatch) {
                    case ELEMENT_MATCH: {
                        childrenMatch = SearchResult.CHILDREN_MATCH;
                        if (childrenResults == null) continue block25;
                        childrenResults.put(fChild, childMatch);
                        continue block25;
                    }
                    case CHILDREN_MATCH: {
                        childrenMatch = SearchResult.CHILDREN_MATCH;
                        if (childrenResults == null || this.treeViewer.getMaxDepth().isMaxDepthReached(f.depth, maxDepth) || childrenResults.containsKey(fChild)) continue block25;
                        childrenResults.put(fChild, childMatch);
                        this.selectChildren(fChild, maxDepth, new ArrayList<FilteredElement>(), childrenResults);
                        continue block25;
                    }
                    case NO_MATCH: {
                        if (childrenResults == null || childrenResults.containsValue((Object)SearchResult.NO_MATCH)) continue block25;
                        childrenResults.put(fChild, childMatch);
                        continue block25;
                    }
                    case CIRCULAR: {
                        switch (childrenMatch) {
                            case NO_MATCH: 
                            case CIRCULAR: {
                                childrenMatch = childMatch;
                                continue block25;
                            }
                            case MAX_DEPTH_REACHED: {
                                continue block25;
                            }
                            case CHILDREN_MATCH: 
                            case ELEMENT_MATCH: 
                            case PARENT_MATCH: {
                                continue block25;
                            }
                        }
                        continue block25;
                    }
                    case MAX_DEPTH_REACHED: {
                        switch (childrenMatch) {
                            case NO_MATCH: 
                            case CIRCULAR: 
                            case MAX_DEPTH_REACHED: {
                                childrenMatch = childMatch;
                                continue block25;
                            }
                            case CHILDREN_MATCH: {
                                continue block25;
                            }
                            case ELEMENT_MATCH: {
                                logger.catchingSilent(new RuntimeException("Found element match with children match"));
                                continue block25;
                            }
                            case PARENT_MATCH: {
                                logger.catchingSilent(new RuntimeException("Inner problem with filter"));
                                continue block25;
                            }
                        }
                        continue block25;
                    }
                    case PARENT_MATCH: {
                        logger.catchingSilent(new RuntimeException("Inner problem with filter"));
                    }
                }
            }
            switch (childrenMatch) {
                case ELEMENT_MATCH: {
                    logger.catchingSilent(new RuntimeException("Found element match with children match"));
                    return childrenMatch;
                }
                case CHILDREN_MATCH: {
                    this.addChildrenMatch(f.element);
                    return childrenMatch;
                }
                case NO_MATCH: {
                    this.addUnmatch(f.element);
                    return childrenMatch;
                }
                case CIRCULAR: {
                    this.circular.add(f.element);
                    return childrenMatch;
                }
            }
            return childrenMatch;
        }
        return SearchResult.NO_MATCH;
    }

    boolean selfReferenceExists(List<Object> parents, Object element, int index) {
        if (index < 0 || parents == null || parents.isEmpty()) {
            return false;
        }
        for (int i = index; i >= 0; --i) {
            Object current = parents.get(i);
            if (this.extension != null && this.extension.equals(current, element)) {
                return true;
            }
            if (!current.equals(element)) continue;
            return true;
        }
        return false;
    }

    public boolean isUnmatch(Object element) {
        Object key = null;
        if (this.extension != null) {
            key = this.extension.getKey(element);
        }
        return this.unmatches.contains(key != null ? key : element);
    }

    public void addUnmatch(Object element) {
        Object key = null;
        if (this.extension != null) {
            key = this.extension.getKey(element);
        }
        Object object = key = key == null ? element : key;
        if (this.matches.contains(key) || this.childrenMatches.contains(key)) {
            (new Object[1])[0] = element;
        }
        this.unmatches.add(key);
    }

    public boolean isMatchOrParentMatch(Object element) {
        return this.isMatch(element) || this.parentMatches.contains(element);
    }

    public boolean isMatch(Object element) {
        Object key = null;
        if (this.extension != null) {
            key = this.extension.getKey(element);
        }
        return this.matches.contains(key != null ? key : element);
    }

    public void addMatch(Object element) {
        Object key = null;
        if (this.extension != null) {
            key = this.extension.getKey(element);
        }
        Object object = key = key == null ? element : key;
        if (this.unmatches.contains(key) || this.childrenMatches.contains(key)) {
            (new Object[1])[0] = element;
        }
        this.matches.add(key);
    }

    public boolean isChildrenMatch(Object element) {
        Object key = null;
        if (this.extension != null) {
            key = this.extension.getKey(element);
        }
        return this.childrenMatches.contains(key != null ? key : element);
    }

    public void addChildrenMatch(Object element) {
        Object key = null;
        if (this.extension != null) {
            key = this.extension.getKey(element);
        }
        Object object = key = key == null ? element : key;
        if (this.unmatches.contains(key) || this.matches.contains(key)) {
            (new Object[1])[0] = element;
        }
        this.childrenMatches.add(key);
    }

    boolean isParentMatches(Object parentElement) {
        return !this.parentMatches.isEmpty() && this.parentMatches.contains(parentElement);
    }

    public boolean isPending(Object element) {
        Object key = null;
        if (this.extension != null) {
            key = this.extension.getKey(element);
        }
        return this.pending.contains(key != null ? key : element);
    }

    public void addPending(Object element) {
        Object key = null;
        if (this.extension != null) {
            key = this.extension.getKey(element);
        }
        key = key == null ? element : key;
        this.pending.add(key);
    }

    private void saveMaxDepth(FilteredElement f, List<FilteredElement> unanalyzed) {
        unanalyzed.add(f);
    }

    private void propagateResultToParents(boolean match, List<Object> parents) {
        int depth = 0;
        Object el = null;
        if (match) {
            while (parents.size() >= 2 && !this.maxDepthSearchKill) {
                el = parents.remove(parents.size() - 1);
                FilteredElement f = new FilteredElement(el, parents, depth);
                this.select(f, depth + 1, new ArrayList<FilteredElement>(), null);
            }
        } else {
            SearchResult s = SearchResult.NO_MATCH;
            while (parents.size() >= 2 && s != SearchResult.MAX_DEPTH_REACHED && !this.maxDepthSearchKill) {
                el = parents.remove(parents.size() - 1);
                FilteredElement f = new FilteredElement(el, parents, depth);
                s = this.select(f, depth + 1, new ArrayList<FilteredElement>(), null);
            }
            if (s == SearchResult.CIRCULAR) {
                this.addUnmatch(el);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resolveMaxDepth() {
        this.treeViewer.getWidget().getFilterText().setPending(true);
        boolean needRefresh = false;
        ArrayList<TreePath> newtps = new ArrayList<TreePath>();
        ArrayList newGroups = new ArrayList();
        this.expanded = 0;
        try {
            while (!this.getViewer().getControl().isDisposed()) {
                if (this.maxDepthSearchKill) {
                    return;
                }
                List<FilteredGroup> list = this.maxDepths;
                synchronized (list) {
                    if (this.maxDepths.isEmpty()) {
                        this.currentGroup = null;
                        return;
                    }
                    this.currentGroup = this.maxDepths.remove(0);
                }
                Map<FilteredElement, SearchResult> result = this.selectFilteredGroup(this.currentGroup, this.treeViewer.getMaxDepth().isMaxDepthReached(this.currentGroup.element.depth) ? new ArrayList() : newGroups);
                ArrayList<TreePath> foundtps = new ArrayList<TreePath>();
                for (Map.Entry entry : result.entrySet()) {
                    if (this.maxDepthSearchKill) break;
                    if (entry.getValue() == SearchResult.ELEMENT_MATCH || entry.getValue() == SearchResult.CHILDREN_MATCH) {
                        ArrayList<Object> segments = new ArrayList<Object>(((FilteredElement)entry.getKey()).exportParents());
                        segments.add(((FilteredElement)entry.getKey()).element);
                        foundtps.add(new TreePath(segments.toArray()));
                        continue;
                    }
                    if (entry.getValue() != SearchResult.NO_MATCH) continue;
                    needRefresh = true;
                }
                if (this.maxDepthSearchKill) {
                    return;
                }
                this.minimizeTreePathList(foundtps);
                this.expanded += foundtps.size();
                newtps.addAll(foundtps);
                if (!this.maxDepths.isEmpty()) continue;
                if (needRefresh) {
                    UIExecutor.async((Widget)this.getViewer().getControl(), new UIRunnable(){

                        @Override
                        public void runi() {
                            FilteredTreeViewer filteredTreeViewer = RegexTreeViewerFilter.this.treeViewer;
                            synchronized (filteredTreeViewer) {
                                if (!RegexTreeViewerFilter.this.getViewer().getControl().isDisposed() && this.isNodeToRemove(RegexTreeViewerFilter.this.getViewer().getTree().getItems())) {
                                    RegexTreeViewerFilter.this.treeViewer.refresh();
                                }
                            }
                        }

                        private boolean isNodeToRemove(TreeItem[] items) {
                            if (items == null) {
                                return false;
                            }
                            boolean nodeToRemove = false;
                            for (TreeItem it : items) {
                                if (it == null || it.getData() == null) continue;
                                if (RegexTreeViewerFilter.this.isUnmatch(it.getData())) {
                                    return true;
                                }
                                if (!(nodeToRemove |= this.isNodeToRemove(it.getItems()))) continue;
                                return true;
                            }
                            return false;
                        }
                    });
                }
                if (!newtps.isEmpty() && this.expanded < 200) {
                    this.minimizeTreePathList(newtps);
                    final ArrayList<TreePath> newTpToExpand = new ArrayList<TreePath>(newtps);
                    newtps.clear();
                    UIExecutor.async((Widget)this.getViewer().getControl(), new UIRunnable(){

                        @Override
                        public void runi() {
                            FilteredTreeViewer filteredTreeViewer = RegexTreeViewerFilter.this.treeViewer;
                            synchronized (filteredTreeViewer) {
                                if (!RegexTreeViewerFilter.this.getViewer().getControl().isDisposed()) {
                                    if (RegexTreeViewerFilter.this.treeViewer.getTreeStateMaintainer() == null) {
                                        ArrayList<TreePath> tps = new ArrayList<TreePath>(Arrays.asList(RegexTreeViewerFilter.this.getViewer().getExpandedTreePaths()));
                                        tps.addAll(RegexTreeViewerFilter.this.expandPaths(newTpToExpand));
                                        RegexTreeViewerFilter.this.getViewer().setExpandedTreePaths(tps.toArray(new TreePath[tps.size()]));
                                    } else {
                                        TreeStateMaintainer<?> treeStateMaintainer = RegexTreeViewerFilter.this.treeViewer.getTreeStateMaintainer();
                                        TreeStateMaintainer.State<?> state = null;
                                        if (treeStateMaintainer != null) {
                                            try {
                                                state = treeStateMaintainer.saveState();
                                            }
                                            catch (Exception e) {
                                                logger.catchingSilent(e);
                                            }
                                        }
                                        for (TreePath tp : newTpToExpand) {
                                            treeStateMaintainer.appendTreePath(state, tp);
                                        }
                                        if (treeStateMaintainer != null && state != null) {
                                            try {
                                                treeStateMaintainer.restoreState(state);
                                            }
                                            catch (Exception e) {
                                                logger.catchingSilent(e);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    });
                }
                List<FilteredGroup> list2 = this.maxDepths;
                synchronized (list2) {
                    this.maxDepths.addAll(this.maxDepthsPlusOne);
                    this.maxDepthsPlusOne.clear();
                    this.maxDepths.addAll(newGroups);
                    newGroups.clear();
                }
            }
            return;
        }
        catch (Exception e) {
            logger.catchingSilent(e);
            return;
        }
        finally {
            List<Object> list = this.pending;
            synchronized (list) {
                this.maxDepthSearch = null;
                this.treeViewer.getWidget().getFilterText().setPending(false);
            }
            list = this.maxDepths;
            synchronized (list) {
                this.pending.clear();
            }
        }
    }

    private List<TreePath> expandPaths(List<TreePath> newTpToExpand) {
        ArrayList<TreePath> tps = new ArrayList<TreePath>();
        for (TreePath tp : newTpToExpand) {
            for (int i = 0; i < tp.getSegmentCount() - 1; ++i) {
                Object[] path = new Object[i + 1];
                for (int j = 0; j < i + 1; ++j) {
                    path[j] = tp.getSegment(j);
                }
                tps.add(new TreePath(path));
            }
            tps.add(tp);
        }
        return tps;
    }

    private void minimizeTreePathList(List<TreePath> newtps) {
        if (newtps.isEmpty()) {
            return;
        }
        Collections.sort(newtps, new Comparator<TreePath>(){

            @Override
            public int compare(TreePath o1, TreePath o2) {
                return Integer.compare(o2.getSegmentCount(), o1.getSegmentCount());
            }
        });
        for (int i = 0; i < newtps.size() - 1; ++i) {
            for (int j = i + 1; j < newtps.size(); ++j) {
                TreePath tpi = newtps.get(i);
                TreePath tpj = newtps.get(j);
                if (tpi.getSegmentCount() == tpj.getSegmentCount()) {
                    if (!tpi.equals(tpj)) continue;
                    newtps.remove(j);
                    --j;
                    continue;
                }
                if (tpi.getSegmentCount() <= tpj.getSegmentCount()) continue;
                boolean subpath = true;
                for (int k = 0; k < tpj.getSegmentCount(); ++k) {
                    if (tpi.getSegment(k).equals(tpj.getSegment(k))) continue;
                    subpath = false;
                    break;
                }
                if (!subpath) continue;
                newtps.remove(j);
                --j;
            }
        }
        Collections.reverse(newtps);
    }

    public IFilteredTreeContentProvider getContentProvider() {
        return this.treeViewer.getContentProvider();
    }

    @Override
    public IFilteredLabelProvider getProvider() {
        return this.treeViewer.getLabelProvider();
    }

    private boolean hasChildren(Object element) {
        return this.getContentProvider().hasChildren(element);
    }

    private Object[] getChildren(Object element) {
        return this.getContentProvider().getChildren(element);
    }

    public void setExtension(IFilteredTreeViewerExtension extension) {
        this.extension = extension;
    }

    public IFilteredTreeViewerExtension getExtension() {
        return this.extension;
    }

    static class FilteredArrayGroup
    extends ArrayGroup {
        private IArrayGroup source;

        public FilteredArrayGroup(IArrayGroup res, Object parent) {
            super(parent);
            this.source = res;
        }

        public IArrayGroup getSource() {
            return this.source;
        }
    }

    private static class FilteredGroup {
        private FilteredElement element;
        private List<FilteredElement> filteredElements;

        public FilteredGroup(FilteredElement element, List<FilteredElement> filteredElements) {
            this.element = element;
            this.filteredElements = filteredElements;
        }

        public String toString() {
            return "FilteredGroup [FGElement=" + this.element + ", filteredElements=\n" + Strings.join("\n", this.filteredElements) + "]";
        }
    }

    private static class FilteredElement {
        private Object element;
        private List<Object> parents;
        private int depth;

        public FilteredElement(Object element, List<Object> parents, int depth) {
            this.element = element;
            this.parents = new ArrayList<Object>(parents);
            this.depth = depth;
        }

        public List<Object> exportParents() {
            ArrayList<Object> newparents = new ArrayList<Object>(this.parents);
            newparents.remove(0);
            return newparents;
        }

        public String toString() {
            return "FilteredElement [element=" + this.element + ", parents=" + Strings.joinList(this.parents) + ", depth=" + this.depth + "]";
        }
    }

    private static enum SearchResult {
        CHILDREN_MATCH,
        ELEMENT_MATCH,
        PARENT_MATCH,
        NO_MATCH,
        MAX_DEPTH_REACHED,
        CIRCULAR;


        private boolean isMatch() {
            return this == CHILDREN_MATCH || this == ELEMENT_MATCH || this == PARENT_MATCH;
        }
    }
}

