/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import com.pnfsoftware.jeb.rcpclient.extensions.viewers.AbstractFilteredViewer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class FilteredViewerComparator
extends ViewerComparator {
    AbstractFilteredViewer<?, ?, ?, ?> v;
    private int propertyIndex = -1;
    private int direction = 0;
    private Map<Integer, Comparator<? super String>> alternativeComparators = new HashMap<Integer, Comparator<? super String>>();
    private Comparator<? super String> currentComparator = null;

    public FilteredViewerComparator(Comparator<? super String> comp, AbstractFilteredViewer<?, ?, ?, ?> v) {
        super(comp);
        this.v = v;
    }

    public FilteredViewerComparator(AbstractFilteredViewer<?, ?, ?, ?> v) {
        this(null, v);
    }

    public void resetComparator() {
        this.propertyIndex = this.v.getControl().getSortIndex();
        this.direction = this.v.getControl().getSortDirection();
        this.currentComparator = null;
        if (this.alternativeComparators.containsKey(this.propertyIndex)) {
            this.currentComparator = this.alternativeComparators.get(this.propertyIndex);
        }
    }

    private Comparator<? super String> getCurrentComparator() {
        return this.currentComparator == null ? this.getComparator() : this.currentComparator;
    }

    public void setAlternativeComparator(int index, Comparator<? super String> comp) {
        this.alternativeComparators.put(index, comp);
    }

    @Override
    public int compare(Viewer viewer, Object e1, Object e2) {
        int rc;
        if (this.propertyIndex < 0) {
            return 0;
        }
        if (this.direction == 0) {
            return 0;
        }
        Object[] l1 = this.v.getLabelProvider().getRowElements(e1);
        Object[] l2 = this.v.getLabelProvider().getRowElements(e2);
        Object o1 = this.propertyIndex < l1.length ? l1[this.propertyIndex] : null;
        Object o2 = this.propertyIndex < l2.length ? l2[this.propertyIndex] : null;
        for (int i = 0; i < 5 && o1 instanceof Object[] && o2 instanceof Object[]; ++i) {
            if (((Object[])o1).length <= 0 || ((Object[])o2).length <= 0) continue;
            o1 = ((Object[])o1)[0];
            o2 = ((Object[])o2)[0];
        }
        if (o1 instanceof String && o2 instanceof String) {
            rc = this.getCurrentComparator().compare((String)o1, (String)o2);
        } else if (o1 instanceof Comparable && o2 instanceof Comparable && o1.getClass() == o2.getClass()) {
            rc = ((Comparable)o1).compareTo(o2);
        } else {
            if (o1 == null) {
                o1 = "";
            }
            if (o2 == null) {
                o2 = "";
            }
            rc = this.getCurrentComparator().compare(o1.toString(), o2.toString());
        }
        return this.direction == 128 ? rc : -rc;
    }
}

