/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.AbstractFilteredView;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTreeView;
import com.pnfsoftware.jeb.rcpclient.extensions.filter.AbstractFilteredFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.AbstractFilteredViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DndDragSource;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DndDropTarget;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewerComparator;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IDndProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeContentProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeViewerExtension;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.RegexTreeViewerFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.TreeStateMaintainer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.TreeViewerExpandedState;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.IArrayGroup;
import com.pnfsoftware.jeb.rcpclient.iviewers.tree.TreeUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class FilteredTreeViewer
extends AbstractFilteredViewer<Tree, TreeColumn, TreeItem, TreeViewer> {
    private static final ILogger logger = GlobalLog.getLogger(FilteredTreeViewer.class);
    private static final int EXPAND_LIMIT = 2000;
    private static final int EXPAND_TIME_LIMIT = 2000;
    public static final int EXPAND_ERROR = -1;
    static final int DEFAULT_EXPAND_MAX_DEPTH = 20;
    Object[] expandedElements;
    private boolean expandAfterFilter;
    private MaxDepth maxDepth = new MaxDepth();
    private boolean circularProtection = false;
    private TreeStateMaintainer<?> treeStateMaintainer;

    public FilteredTreeViewer(FilteredTreeView widget, boolean expandAfterFilter) {
        super(widget, Strings.getComparator());
        this.expandAfterFilter = expandAfterFilter;
    }

    public FilteredTreeViewer(Composite parent, int style, String[] columnNames, int[] columnWidths, boolean expandAfterFilter) {
        this(new FilteredTreeView(parent, style, columnNames, columnWidths), expandAfterFilter);
    }

    @Override
    protected TreeViewer buildViewer(AbstractFilteredView<Tree, TreeColumn, TreeItem> widget, boolean shadow) {
        return new TreeViewer(shadow ? widget.getShadowElement() : widget.getMainElement());
    }

    @Override
    protected FilteredTreeViewerComparator buildComparator(Comparator<? super String> comp) {
        return new FilteredTreeViewerComparator(comp, this);
    }

    @Override
    public FilteredTreeViewerComparator getComparator() {
        return (FilteredTreeViewerComparator)super.getComparator();
    }

    @Override
    protected AbstractFilteredFilter buildFilter(TreeViewer viewer) {
        return new RegexTreeViewerFilter(viewer, this);
    }

    public TreeViewer getViewer() {
        return (TreeViewer)this.getMainViewer();
    }

    @Override
    protected Object applyFilterNull() {
        ISelection sel = this.getSelection();
        super.applyFilterNull();
        if (this.expandedElements != null) {
            ((TreeViewer)this.getCurrentViewer()).collapseAll();
            ((TreeViewer)this.getCurrentViewer()).setExpandedElements(this.expandedElements);
            if (!sel.isEmpty() && sel instanceof ITreeSelection) {
                TreePath[] tps = ((ITreeSelection)sel).getPaths();
                sel = new TreeSelection(this.convertFromFiltered(tps));
            }
            this.setSelection(sel);
            this.expandedElements = null;
        }
        return null;
    }

    private TreePath[] convertFromFiltered(TreePath[] tps) {
        TreePath[] res = new TreePath[tps.length];
        for (int i = 0; i < tps.length; ++i) {
            res[i] = RegexTreeViewerFilter.convertFromFiltered(tps[i]);
        }
        return res;
    }

    private TreePath[] convertToFiltered(TreePath[] tps) {
        TreePath[] res = new TreePath[tps.length];
        for (int i = 0; i < tps.length; ++i) {
            res[i] = this.getRegexViewerFilter().convertToFiltered(tps[i]);
        }
        return res;
    }

    @Override
    protected Object applyFilter(String filterString, boolean refresh) {
        ISelection sel = this.getSelection();
        if (this.expandedElements == null) {
            this.expandedElements = ((TreeViewer)this.getCurrentViewer()).getExpandedElements();
        }
        super.applyFilter(filterString, refresh);
        if (this.expandAfterFilter) {
            FilteredTreeViewer filteredTreeViewer = this;
            synchronized (filteredTreeViewer) {
                Integer n;
                Tree t = ((TreeViewer)this.getCurrentViewer()).getTree();
                try {
                    t.setRedraw(false);
                    TreeItem[] items = t.getItems();
                    n = this.expandFiltered(items, items.length);
                }
                catch (Throwable throwable) {
                    t.setRedraw(true);
                    if (!sel.isEmpty() && sel instanceof ITreeSelection) {
                        TreePath[] tps = ((ITreeSelection)sel).getPaths();
                        sel = new TreeSelection(this.convertToFiltered(tps));
                    }
                    this.setSelection(sel);
                    throw throwable;
                }
                t.setRedraw(true);
                if (!sel.isEmpty() && sel instanceof ITreeSelection) {
                    TreePath[] tps = ((ITreeSelection)sel).getPaths();
                    sel = new TreeSelection(this.convertToFiltered(tps));
                }
                this.setSelection(sel);
                return n;
            }
        }
        return null;
    }

    private int expandFiltered(TreeItem[] items, int opened) {
        TreeViewerExpandedState expandedState = new TreeViewerExpandedState();
        int expandedNodes = this.expandFiltered(items, opened, 0, expandedState.createRootPath(), System.currentTimeMillis());
        expandedState.expand((TreeViewer)this.getCurrentViewer());
        return expandedNodes;
    }

    public FilteredTreeView getFilteredTreeWidget() {
        return (FilteredTreeView)this.getWidget();
    }

    private RegexTreeViewerFilter getRegexViewerFilter() {
        return (RegexTreeViewerFilter)this.filter;
    }

    private List<TreeItem> filterItems(TreeItem[] items, TreeViewerExpandedState.TreeViewerPath expandedPath) {
        ArrayList<TreeItem> toExpand = new ArrayList<TreeItem>();
        if (items == null || items.length == 0) {
            return toExpand;
        }
        for (TreeItem item : items) {
            Boolean expand;
            Object data = item.getData();
            if (data == null || this.getRegexViewerFilter().selfReferenceExists(expandedPath.path, data, expandedPath.path.size() - 1) || item.getData() instanceof IUnit && !((IUnit)item.getData()).isProcessed()) continue;
            if (this.getRegexViewerFilter().getExtension() != null && (expand = this.getRegexViewerFilter().getExtension().shouldExpand(data)) != null && expand.booleanValue()) {
                toExpand.add(item);
                continue;
            }
            if (!this.getContentProvider().hasChildren(data)) continue;
            if (this.getRegexViewerFilter().isMatch(data) || this.getRegexViewerFilter().isChildrenMatch(data)) {
                toExpand.add(item);
                continue;
            }
            this.getRegexViewerFilter().isParentMatches(data);
        }
        return toExpand;
    }

    private int expandFiltered(TreeItem[] items, int opened, int depth, TreeViewerExpandedState.TreeViewerPath expandedPath, long time0) {
        if (this.maxDepth.isMaxDepthReached(depth)) {
            return opened;
        }
        List<TreeItem> toExpand = this.filterItems(items, expandedPath);
        for (TreeItem item : toExpand) {
            expandedPath.addTreePath(item.getData());
            expandedPath.expand((TreeViewer)this.getCurrentViewer());
            if ((opened += item.getItems().length) <= 2000) continue;
            break;
        }
        if (opened > 2000 || System.currentTimeMillis() - time0 > 2000L) {
            return -1;
        }
        for (TreeItem item : toExpand) {
            TreeViewerExpandedState.TreeViewerPath childPath = expandedPath.createChildPath(item.getData());
            int newDepth = MaxDepth.incrementDepth(depth, item.getData());
            opened = this.expandFiltered(item.getItems(), opened, newDepth, childPath, time0);
            if (opened > 2000) {
                return -1;
            }
            if (opened != -1) continue;
            return -1;
        }
        return opened;
    }

    public MaxDepth getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth.maxDepth = maxDepth;
    }

    public void setExtension(IFilteredTreeViewerExtension extension) {
        this.getRegexViewerFilter().setExtension(extension);
    }

    public boolean isCircularProtection() {
        return this.circularProtection;
    }

    public void setCircularProtection(boolean circularProtection) {
        this.circularProtection = circularProtection;
    }

    public void addDragnDropSupport(IDndProvider dndProvider) {
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 10;
        DndDragSource dragSource = new DndDragSource(dndProvider);
        ((TreeViewer)this.getCurrentViewer()).addDragSupport(operations, types, dragSource);
        ((TreeViewer)this.getCurrentViewer()).addDropSupport(operations, types, (DropTargetListener)new DndDropTarget((Viewer)this.getCurrentViewer(), dndProvider, dragSource));
    }

    @Override
    public IFilteredTreeContentProvider getContentProvider() {
        return (IFilteredTreeContentProvider)super.getContentProvider();
    }

    public void expandAll() {
        ((TreeViewer)this.getCurrentViewer()).expandAll();
    }

    public void expandToLevel(int level) {
        ((TreeViewer)this.getCurrentViewer()).expandToLevel(level);
    }

    public void expandToLevel(Object elementOrTreePath, int level) {
        ((TreeViewer)this.getCurrentViewer()).expandToLevel(elementOrTreePath, level);
    }

    public String exportToString() {
        return TreeUtil.buildXml(((TreeViewer)this.getCurrentViewer()).getTree(), 2);
    }

    public void refresh(boolean dataUpdated) {
        TreeStateMaintainer.State<?> state = null;
        if (this.treeStateMaintainer != null) {
            try {
                state = this.treeStateMaintainer.saveState();
            }
            catch (Exception e) {
                logger.catchingSilent(e);
            }
        }
        if (dataUpdated) {
            this.getRegexViewerFilter().resetCache();
        }
        super.refresh();
        if (this.treeStateMaintainer != null && state != null) {
            try {
                this.treeStateMaintainer.restoreState(state);
            }
            catch (Exception e) {
                logger.catchingSilent(e);
            }
        }
    }

    @Override
    public void refresh() {
        this.refresh(false);
    }

    public void setTreeStateMaintainer(TreeStateMaintainer<?> treeStateMaintainer) {
        treeStateMaintainer.setViewer(this.getViewer());
        this.treeStateMaintainer = treeStateMaintainer;
    }

    public TreeStateMaintainer<?> getTreeStateMaintainer() {
        return this.treeStateMaintainer;
    }

    public void addTreeListener(ITreeViewerListener listener) {
        ((TreeViewer)this.getMainViewer()).addTreeListener(listener);
        if (this.getShadowViewer() != null) {
            ((TreeViewer)this.getShadowViewer()).addTreeListener(listener);
        }
    }

    public TreeItem[] getItems() {
        return ((TreeViewer)this.getCurrentViewer()).getTree().getItems();
    }

    public boolean getExpandedState(Object elementOrTreePath) {
        return ((TreeViewer)this.getCurrentViewer()).getExpandedState(elementOrTreePath);
    }

    public void setExpandedState(Object elementOrTreePath, boolean expanded) {
        ((TreeViewer)this.getCurrentViewer()).setExpandedState(elementOrTreePath, expanded);
    }

    public void displayTreeAsTable() {
        Tree tree = this.getFilteredTreeWidget().getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
    }

    static class MaxDepth {
        private int maxDepth = 20;

        MaxDepth() {
        }

        boolean isMaxDepthReached(int depth, int maxDepth) {
            if (maxDepth == -1 || this.maxDepth == -1) {
                return false;
            }
            return depth >= maxDepth || depth >= this.maxDepth;
        }

        boolean isMaxDepthReached(int depth) {
            if (this.maxDepth == -1) {
                return false;
            }
            return depth >= this.maxDepth;
        }

        static int incrementDepth(int depth, Object data) {
            return data instanceof IArrayGroup ? depth : depth + 1;
        }
    }
}

