/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import com.pnfsoftware.jeb.rcpclient.extensions.controls.AbstractFilteredView;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.filter.AbstractFilteredFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.AbstractFilteredViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredViewerComparator;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredLabelProvider;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.Comparator;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FilteredTableViewer
extends AbstractFilteredViewer<Table, TableColumn, TableItem, TableViewer> {
    public FilteredTableViewer(FilteredTableView widget) {
        super(widget, Strings.getComparator());
    }

    @Override
    protected TableViewer buildViewer(AbstractFilteredView<Table, TableColumn, TableItem> widget, boolean shadow) {
        if ((widget.getMainElement().getStyle() & 0x20) == 0) {
            return new TableViewer(shadow ? widget.getShadowElement() : widget.getMainElement());
        }
        return new CheckboxTableViewer(shadow ? widget.getShadowElement() : widget.getMainElement());
    }

    @Override
    protected FilteredViewerComparator buildComparator(Comparator<? super String> comp) {
        return new FilteredViewerComparator(comp, this);
    }

    @Override
    protected AbstractFilteredFilter buildFilter(TableViewer viewer) {
        return new Filter(viewer);
    }

    public void setInput(Object input, boolean pack) {
        super.setInput(input);
        if (pack) {
            this.getWidget().pack(false);
        }
    }

    public void setCheckStateProvider(ICheckStateProvider provider) {
        if (!(this.getCurrentViewer() instanceof CheckboxTableViewer)) {
            throw new RuntimeException();
        }
        ((CheckboxTableViewer)this.getCurrentViewer()).setCheckStateProvider(provider);
    }

    @Override
    protected Object applyFilterNull() {
        ISelection sel = null;
        if (this.getWidget().isShadowTableDisplayed()) {
            sel = ((TableViewer)this.getShadowViewer()).getSelection();
        }
        this.getWidget().displayMainElement();
        if (sel != null && !sel.isEmpty()) {
            this.setSelection(sel);
            int selIndex = ((Table)this.getWidget().getMainElement()).getSelectionIndex();
            if (selIndex >= 0) {
                ((Table)this.getWidget().getMainElement()).setTopIndex(selIndex);
            }
        }
        return super.applyFilterNull();
    }

    @Override
    protected Object applyFilter(String filterString, boolean refresh) {
        if (this.getWidget().hasShadowTable()) {
            ISelection sel = this.getSelection();
            Object res = super.applyFilter(filterString, false);
            this.getWidget().displayShadowElement(this.filter);
            ((TableViewer)this.getMainViewer()).removeFilter(this.filter);
            if (!sel.isEmpty()) {
                this.setSelection(sel);
            }
            return res;
        }
        boolean found = false;
        for (ViewerFilter f : ((TableViewer)this.getMainViewer()).getFilters()) {
            if (f != this.filter) continue;
            found = true;
            break;
        }
        if (!found) {
            ((TableViewer)this.getMainViewer()).addFilter(this.filter);
        }
        return super.applyFilter(filterString, refresh);
    }

    public int getSelectionIndex() {
        return ((TableViewer)this.getCurrentViewer()).getTable().getSelectionIndex();
    }

    class Filter
    extends AbstractFilteredFilter {
        public Filter(StructuredViewer viewer) {
            super(viewer);
        }

        @Override
        public boolean select(Viewer viewer, Object parent, Object element) {
            return this.isElementMatch(element);
        }

        @Override
        public IFilteredLabelProvider getProvider() {
            return FilteredTableViewer.this.getLabelProvider();
        }
    }
}

