/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DndDragSource;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IDndProvider;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;

public class DndDropTarget
extends ViewerDropAdapter {
    private static final ILogger logger = GlobalLog.getLogger(DndDropTarget.class);
    private IDndProvider dndProvider;
    private DndDragSource dragSource;
    boolean allowInsertBeforeOrAfter = false;

    public DndDropTarget(Viewer viewer, IDndProvider dndProvider, DndDragSource dragSource) {
        super(viewer);
        this.dndProvider = dndProvider;
        this.dragSource = dragSource;
        this.setFeedbackEnabled(false);
        this.setExpandEnabled(false);
    }

    @Override
    protected int determineLocation(DropTargetEvent event) {
        int location = super.determineLocation(event);
        if (!(this.allowInsertBeforeOrAfter || location != 1 && location != 2)) {
            return 3;
        }
        return location;
    }

    @Override
    public void drop(DropTargetEvent event) {
        int location = this.determineLocation(event);
        Object target = this.determineTarget(event);
        if (this.dndProvider.performDrop((String)event.data, target, location)) {
            Object[] objectArray = new Object[]{event.data, target, location};
            super.drop(event);
        } else {
            Object[] objectArray = new Object[]{event.data, target, location};
        }
    }

    @Override
    public boolean performDrop(Object data) {
        return true;
    }

    @Override
    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        boolean canDrop = false;
        if (this.dragSource.dragData != null && target != null) {
            canDrop = this.dndProvider.canDrop(this.dragSource.dragData, target, 3);
        }
        Object[] objectArray = new Object[]{target, operation, transferType, canDrop};
        return canDrop;
    }

    @Override
    public void dragOver(DropTargetEvent event) {
        event.feedback = 0;
        super.dragOver(event);
        Object target = this.getCurrentTarget();
        boolean canDrop = false;
        if (this.dragSource.dragData != null && target != null) {
            canDrop = this.dndProvider.canDrop(this.dragSource.dragData, target, 3);
        }
        this.setFeedbackSelect(event, canDrop ? 3 : 4);
    }

    private void setFeedbackSelect(DropTargetEvent event, int location) {
        switch (location) {
            case 1: {
                event.feedback |= 2;
                break;
            }
            case 2: {
                event.feedback |= 4;
                break;
            }
            case 3: {
                event.feedback |= 1;
                if (!this.dndProvider.shouldExpand(this.dragSource.dragData, this.getCurrentTarget())) break;
                event.feedback |= 0x10;
            }
        }
    }
}

