/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultStyledCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeContentProvider;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.List;

public abstract class DefaultStyledCellTreeLabelProvider
extends DefaultStyledCellLabelProvider {
    private IFilteredTreeContentProvider contentProvider;

    public DefaultStyledCellTreeLabelProvider(IFilteredTreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    @Override
    public Object[] getRowElements(Object row) {
        Object[] res = super.getRowElements(row);
        Object parent = this.contentProvider.getParent(row);
        if (parent != null) {
            List<Object> fullPath = this.buildParentPath(parent);
            if (fullPath.isEmpty()) {
                return res;
            }
            fullPath.add(this.getStringAt(row, 0));
            String column0 = Strings.join(".", fullPath);
            Object[] newRes = new Object[res.length + 1];
            newRes[res.length] = column0;
            System.arraycopy(res, 0, newRes, 0, res.length);
            return newRes;
        }
        return res;
    }

    protected List<Object> buildParentPath(Object parent) {
        String parentName;
        ArrayList<Object> fullPath = new ArrayList<Object>();
        while (parent != null && (parentName = this.getStringAt(parent, 0)) != null) {
            fullPath.add(0, parentName);
            parent = this.contentProvider.getParent(parent);
        }
        return fullPath;
    }
}

