/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import com.pnfsoftware.jeb.core.output.tree.ICodeNode;
import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodeField;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodeMethod;
import com.pnfsoftware.jeb.core.units.code.ICodePackage;
import com.pnfsoftware.jeb.core.units.code.ICodeType;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.CodeHierarchyCustomFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.IFilterText;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.RegexTreeViewerFilter;
import org.eclipse.jface.viewers.TreeViewer;

public class CodeUnitFilter
extends RegexTreeViewerFilter {
    private FilteredTreeViewer treeViewer;

    public CodeUnitFilter(TreeViewer viewer, FilteredTreeViewer treeViewer) {
        super(viewer, treeViewer);
        this.treeViewer = treeViewer;
    }

    @Override
    public boolean isElementMatch(Object element) {
        if (!this.isFiltered()) {
            return true;
        }
        IFilterText filter = this.treeViewer.getWidget().getFilterText();
        if (filter instanceof CodeHierarchyCustomFilter) {
            CodeHierarchyCustomFilter filterText = (CodeHierarchyCustomFilter)filter;
            if (filterText.isAllButtonSelected()) {
                return super.isElementMatch(element);
            }
            if (filterText.isNoButtonSelected()) {
                return false;
            }
            if (element instanceof ICodeNode) {
                ICodeNode elementNode = (ICodeNode)element;
                ICodeItem item = elementNode.getObject();
                if (item instanceof ICodePackage) {
                    if (filterText.isCheckPackage()) {
                        return super.isElementMatch(element);
                    }
                    return false;
                }
                if (item instanceof ICodeClass || item instanceof ICodeType) {
                    if (filterText.isCheckClass()) {
                        if (filterText.isCheckPackage()) {
                            return super.isElementMatch(element);
                        }
                        return this.isRowMatch(new Object[]{item.getName(true)});
                    }
                    return false;
                }
                if (item instanceof ICodeMethod) {
                    if (filterText.isCheckMethod()) {
                        return this.testMethodOrField(filterText, elementNode, item);
                    }
                    return false;
                }
                if (item instanceof ICodeField) {
                    if (filterText.isCheckField()) {
                        return this.testMethodOrField(filterText, elementNode, item);
                    }
                    return false;
                }
                return false;
            }
        }
        return super.isElementMatch(element);
    }

    private boolean testMethodOrField(CodeHierarchyCustomFilter filterText, ICodeNode elementNode, ICodeItem item) {
        String withParent = null;
        if (filterText.isCheckClass()) {
            if (filterText.isCheckPackage()) {
                return super.isElementMatch(elementNode);
            }
            ICodeNode parent = elementNode.getParent();
            if (parent != null) {
                withParent = parent.getLabel() + "." + elementNode.getLabel();
            }
        }
        if (withParent != null) {
            return this.isRowMatch(new Object[]{item.getName(true), elementNode.getLabel(), withParent});
        }
        return this.isRowMatch(new Object[]{item.getName(true), elementNode.getLabel()});
    }
}

