/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import com.pnfsoftware.jeb.rcpclient.extensions.ContextMenuFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.AbstractFilteredView;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.IFilterText;
import com.pnfsoftware.jeb.rcpclient.extensions.filter.AbstractFilteredFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredViewerComparator;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredStructuredViewer;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.operations.IContextMenu;
import com.pnfsoftware.jeb.rcpclient.util.regex.IPattern;
import com.pnfsoftware.jeb.rcpclient.util.regex.SimplePattern;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractFilteredViewer<T extends Composite, C extends Item, I extends Item, V extends ColumnViewer>
extends Viewer
implements IFilteredStructuredViewer {
    private AbstractFilteredView<T, C, I> widget;
    private V viewer;
    private V shadowViewer;
    AbstractFilteredFilter filter;
    private FilteredViewerComparator comparator;
    private boolean displayFilteredRowCount;
    private IPattern filterPattern = new SimplePattern("");
    private IFilterText filterText;
    private List<Listener> filterDoneListeners = new ArrayList<Listener>();
    private boolean sortEnabled = true;

    public AbstractFilteredViewer(AbstractFilteredView<T, C, I> widget, Comparator<? super String> comp) {
        this.widget = widget;
        this.viewer = this.buildViewer(widget, false);
        if (widget.getShadowElement() != null) {
            this.shadowViewer = this.buildViewer(widget, true);
        }
        this.filter = this.buildFilter(this.viewer);
        ((StructuredViewer)this.viewer).addFilter(this.filter);
        this.filterText = widget.getFilterText();
        this.filterText.addApplyFilterListener(e -> {
            Object result = this.applyFilterText((String)e.data);
            Event event = new Event();
            event.widget = this.widget;
            event.data = result;
            for (Listener l : this.filterDoneListeners) {
                l.handleEvent(event);
            }
        });
        this.setComparator(this.buildComparator(comp));
        for (int colIndex = 0; colIndex < widget.getColumnCount(); ++colIndex) {
            widget.addColumnSelectionListener(colIndex, (SelectionListener)new ColumnSelectionListener(colIndex));
        }
    }

    public Object applyFilterText(String filterString) {
        Object result = filterString == null || filterString.length() == 0 ? this.applyFilterNull() : this.applyFilter(filterString, true);
        return result;
    }

    protected Object applyFilterNull() {
        this.filter.setFilterText(null, true);
        return null;
    }

    protected Object applyFilter(String filterString, boolean refresh) {
        try {
            this.filterPattern.setPattern(filterString);
            this.filter.setFilterPattern(this.filterPattern, refresh);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            String text = filterString.toLowerCase();
            this.filter.setFilterText(text, refresh);
            this.filterText.setStatus(Boolean.FALSE);
        }
        return null;
    }

    public boolean isFiltered() {
        return this.filter.isFiltered();
    }

    protected abstract V buildViewer(AbstractFilteredView<T, C, I> var1, boolean var2);

    protected abstract FilteredViewerComparator buildComparator(Comparator<? super String> var1);

    protected abstract AbstractFilteredFilter buildFilter(V var1);

    public void enableSortColumn(boolean enabled) {
        this.sortEnabled = enabled;
    }

    public AbstractFilteredView<T, C, I> getControl() {
        return this.widget;
    }

    @Override
    public void setInput(Object input) {
        ((StructuredViewer)this.viewer).setInput(input);
        this.filter.inputChanged();
        this.filterText.submitText("");
    }

    @Override
    public Object getInput() {
        return ((ContentViewer)this.viewer).getInput();
    }

    @Override
    public void setSelection(ISelection selection, boolean reveal) {
        ((StructuredViewer)this.getCurrentViewer()).setSelection(selection, reveal);
    }

    @Override
    public ISelection getSelection() {
        return ((StructuredViewer)this.getCurrentViewer()).getSelection();
    }

    @Override
    public void refresh() {
        boolean refreshShadow = this.getWidget().isShadowTableDisplayed();
        UIUtil.safeRefreshViewer(this.viewer);
        if (this.widget.getShadowElement() != null) {
            if (refreshShadow) {
                this.getWidget().refreshShadowElement();
            } else {
                this.widget.getShadowElement().layout();
            }
        }
    }

    public void setLabelProvider(IFilteredLabelProvider labelProvider) {
        ((ColumnViewer)this.viewer).setLabelProvider(labelProvider);
    }

    public void setContentProvider(IStructuredContentProvider provider) {
        ((StructuredViewer)this.viewer).setContentProvider(provider);
    }

    public IStructuredContentProvider getContentProvider() {
        return (IStructuredContentProvider)((ContentViewer)this.viewer).getContentProvider();
    }

    public IFilteredLabelProvider getLabelProvider() {
        return (IFilteredLabelProvider)((ContentViewer)this.viewer).getLabelProvider();
    }

    public void setDisplayFilteredRowCount(boolean enabled) {
        if (this.displayFilteredRowCount != enabled) {
            this.displayFilteredRowCount = enabled;
        }
    }

    protected void refreshItemCountLabel() {
    }

    public void setFilterPatternFactory(IPattern pattern) {
        this.filterPattern = pattern;
    }

    protected AbstractFilteredView<T, C, I> getWidget() {
        return this.widget;
    }

    protected V getMainViewer() {
        return this.viewer;
    }

    protected V getCurrentViewer() {
        return this.shadowViewer != null && this.widget.isShadowTableDisplayed() ? this.shadowViewer : this.viewer;
    }

    protected V getShadowViewer() {
        return this.shadowViewer;
    }

    @Override
    public void addDoubleClickListener(IDoubleClickListener listener) {
        ((StructuredViewer)this.viewer).addDoubleClickListener(listener);
        if (this.shadowViewer != null) {
            ((StructuredViewer)this.shadowViewer).addDoubleClickListener(listener);
        }
    }

    @Override
    public void removeDoubleClickListener(IDoubleClickListener listener) {
        ((StructuredViewer)this.viewer).removeDoubleClickListener(listener);
        if (this.shadowViewer != null) {
            ((StructuredViewer)this.shadowViewer).removeDoubleClickListener(listener);
        }
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        ((Viewer)this.viewer).addSelectionChangedListener(listener);
        if (this.shadowViewer != null) {
            ((Viewer)this.shadowViewer).addSelectionChangedListener(listener);
        }
    }

    @Override
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        ((Viewer)this.viewer).removeSelectionChangedListener(listener);
        if (this.shadowViewer != null) {
            ((Viewer)this.shadowViewer).removeSelectionChangedListener(listener);
        }
    }

    public void addFilteredTextListener(Listener listener) {
        this.filterDoneListeners.add(listener);
    }

    public FilteredViewerComparator getComparator() {
        return this.comparator;
    }

    public void setComparator(FilteredViewerComparator comparator) {
        this.comparator = comparator;
        ((StructuredViewer)this.viewer).setComparator(comparator);
        if (this.shadowViewer != null) {
            ((StructuredViewer)this.shadowViewer).setComparator(comparator);
        }
    }

    public List<ContextMenu> addContextMenu(IFilteredLabelProvider valueProvider, String[] filterLabels, Boolean[] displayPrefix, IContextMenu contextMenu) {
        ArrayList<ContextMenu> list = new ArrayList<ContextMenu>();
        list.add(ContextMenuFilter.addContextMenu(this.viewer, this.filterText, valueProvider, filterLabels, displayPrefix, contextMenu));
        if (this.shadowViewer != null) {
            list.add(ContextMenuFilter.addContextMenu(this.shadowViewer, this.filterText, valueProvider, filterLabels, displayPrefix, contextMenu));
        }
        return list;
    }

    class ColumnSelectionListener
    extends SelectionAdapter {
        int columnIndex;

        public ColumnSelectionListener(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public void widgetSelected(SelectionEvent e) {
            if (AbstractFilteredViewer.this.comparator != null && AbstractFilteredViewer.this.sortEnabled) {
                int dir = this.getDirection(AbstractFilteredViewer.this.getWidget().getSortIndex(), this.columnIndex, AbstractFilteredViewer.this.getWidget().getSortDirection());
                boolean refreshShadow = AbstractFilteredViewer.this.getWidget().isShadowTableDisplayed();
                AbstractFilteredViewer.this.getWidget().setSortData(dir, dir == 0 ? -1 : this.columnIndex);
                AbstractFilteredViewer.this.comparator.resetComparator();
                AbstractFilteredViewer.this.refresh();
                if (refreshShadow) {
                    AbstractFilteredViewer.this.getWidget().refreshShadowElement();
                }
            }
        }

        public int getDirection(int column, int propertyIndex, int direction) {
            if (column == propertyIndex) {
                if (direction == 0) {
                    direction = 128;
                } else if (direction == 128) {
                    direction = 1024;
                } else if (direction == 1024) {
                    direction = 0;
                }
            } else {
                direction = 128;
            }
            return direction;
        }
    }
}

