/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.viewers;

import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeContentProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.ArrayGroup;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.ArrayGroupProperties;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.ArrayLogicalGroup;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.ArrayLogicalRoot;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.IArrayGroup;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.IArrayGroupProperties;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.SeparatorRule;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.arraygroup.VirtualArrayGroup;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.collect.Maps;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractArrayGroupFilteredTreeContentProvider
implements IFilteredTreeContentProvider {
    public static final int DEFAULT_LIMIT = 1000;
    public static final int DEFAULT_GROUP_LIMIT = 100;
    public static final int DEFAULT_PERFORMANCE_LIMIT = 20;
    private static final int MIN_GROUP_SIZE_ALLOWED = 10;
    public static final int DEFAULT_MIN_SMART_BUCKET_SIZE = 3;
    private IArrayGroupProperties properties;
    private int performanceLimit;
    private boolean performanceOptimizer = false;
    private Map<Integer, Map<Integer, Map<Object, ArrayGroup>>> arrayGroups = new HashMap<Integer, Map<Integer, Map<Object, ArrayGroup>>>();
    private Map<Integer, Map<Integer, Map<Object, ArrayLogicalGroup>>> arrayLogicalGroups = new HashMap<Integer, Map<Integer, Map<Object, ArrayLogicalGroup>>>();
    private Map<Integer, Map<Object, VirtualArrayGroup>> virtualElements = new HashMap<Integer, Map<Object, VirtualArrayGroup>>();

    public AbstractArrayGroupFilteredTreeContentProvider(IArrayGroupProperties properties, int performanceLimit) {
        this.properties = properties;
        this.performanceLimit = performanceLimit;
    }

    public AbstractArrayGroupFilteredTreeContentProvider() {
        this(new ArrayGroupProperties(1000, 100), 20);
    }

    protected ArrayGroup getArrayGroup(Object parentElement, int firstIndex, int toplevel) {
        ArrayGroup g;
        Map<Object, ArrayGroup> gr;
        Map<Integer, Map<Object, ArrayGroup>> lev = this.arrayGroups.get(toplevel);
        if (lev == null) {
            lev = new HashMap<Integer, Map<Object, ArrayGroup>>();
            this.arrayGroups.put(toplevel, lev);
        }
        if ((gr = lev.get(firstIndex)) == null) {
            gr = new HashMap<Object, ArrayGroup>();
            lev.put(firstIndex, gr);
        }
        if ((g = gr.get(parentElement)) == null) {
            g = new ArrayGroup(parentElement);
            gr.put(parentElement, g);
        }
        g.clear();
        return g;
    }

    private ArrayLogicalGroup getArrayLogicalGroup(Object parentElement, int firstIndex, String groupName, boolean packaged, int toplevel) {
        ArrayLogicalGroup g;
        Map<Object, ArrayLogicalGroup> gr;
        Map<Integer, Map<Object, ArrayLogicalGroup>> lev = this.arrayLogicalGroups.get(toplevel);
        if (lev == null) {
            lev = new HashMap<Integer, Map<Object, ArrayLogicalGroup>>();
            this.arrayLogicalGroups.put(toplevel, lev);
        }
        if ((gr = lev.get(firstIndex)) == null) {
            gr = new HashMap<Object, ArrayLogicalGroup>();
            lev.put(firstIndex, gr);
        }
        if ((g = gr.get(parentElement)) == null || !Strings.equals(g.getGroupName(), groupName) || g.isPackaged() != packaged) {
            g = new ArrayLogicalGroup(parentElement, groupName, packaged);
            gr.put(parentElement, g);
        }
        g.clear();
        return g;
    }

    protected VirtualArrayGroup getVirtualElement(Object elt, int firstIndex, String label) {
        VirtualArrayGroup g;
        Map<Object, VirtualArrayGroup> gr = this.virtualElements.get(firstIndex);
        if (gr == null) {
            gr = new HashMap<Object, VirtualArrayGroup>();
            this.virtualElements.put(firstIndex, gr);
        }
        if ((g = gr.get(elt)) == null || !Strings.equals(g.getGroupName(), label)) {
            g = new VirtualArrayGroup(firstIndex, elt, label);
            gr.put(elt, g);
        }
        return g;
    }

    @Override
    public final boolean hasChildren(Object element) {
        if (element instanceof IArrayGroup) {
            if (((IArrayGroup)element).isSingle()) {
                return this.hasChildren(((IArrayGroup)element).getFirstElement());
            }
            return true;
        }
        return this.hasChildren2(element);
    }

    public abstract boolean hasChildren2(Object var1);

    @Override
    public final Object[] getChildren(Object parentElement) {
        List<Object> children;
        if (parentElement instanceof IArrayGroup) {
            if (((IArrayGroup)parentElement).isSingle()) {
                parentElement = ((IArrayGroup)parentElement).getFirstElement();
            } else {
                return ((ArrayGroup)parentElement).toArray();
            }
        }
        if ((children = this.getChildren2(parentElement)) == null) {
            return ArrayUtil.NO_OBJECT;
        }
        Object[] elts = children.toArray();
        this.sort(elts);
        children = Arrays.asList(elts);
        return this.noMoreThanNChildren(children, parentElement);
    }

    private Object[] noMoreThanNChildren(List<?> r, Object parentElement) {
        boolean shouldCreateArrayGroups;
        boolean bl = shouldCreateArrayGroups = this.performanceOptimizer && r.size() >= this.performanceLimit || r.size() > this.getLimit();
        if (shouldCreateArrayGroups || this.properties.isForceLogicalGroups()) {
            if (shouldCreateArrayGroups && !this.performanceOptimizer) {
                this.performanceOptimizer = true;
                this.onFirstOptimization(r);
            }
            ArrayList<IArrayGroup> groups = new ArrayList<IArrayGroup>();
            ArrayLogicalRoot logicalRoot = this.getLogicalGroups(r, parentElement);
            if (r.size() <= this.getLimit()) {
                if (logicalRoot.groupSize() == 0) {
                    return r.toArray();
                }
                if (logicalRoot.groupSize() == 1 && logicalRoot.singleSize() < this.performanceLimit) {
                    return r.toArray();
                }
            }
            int groupIndex = 0;
            int packageIndex = 0;
            ArrayList<Integer> singlePackages = new ArrayList<Integer>();
            for (Integer i : logicalRoot.singles()) {
                Object rx = r.get(i);
                if (this.mayBeInArrayGroup(rx)) continue;
                singlePackages.add(i);
            }
            if (!logicalRoot.isEmpty()) {
                for (ArrayLogicalGroup logicalGroup : logicalRoot.group()) {
                    if (logicalGroup.isPackaged()) {
                        while (!singlePackages.isEmpty() && (Integer)singlePackages.get(0) < logicalGroup.getReferenceIndex()) {
                            int i = (Integer)singlePackages.remove(0);
                            groups.add(packageIndex, this.getVirtualElement(r.get(i), i, null));
                            ++packageIndex;
                        }
                        groups.add(packageIndex, logicalGroup);
                        ++packageIndex;
                        continue;
                    }
                    groups.add(packageIndex + groupIndex, logicalGroup);
                    ++groupIndex;
                }
            }
            while (!singlePackages.isEmpty()) {
                int i = (Integer)singlePackages.remove(0);
                groups.add(packageIndex, this.getVirtualElement(r.get(i), i, null));
                ++packageIndex;
            }
            ArrayGroup currentGroup = null;
            boolean shouldCreateIntermediateGroups = logicalRoot.singleSize() > this.getLimit();
            for (Integer i : logicalRoot.singles()) {
                Object rx;
                if (shouldCreateIntermediateGroups && (currentGroup == null || currentGroup.count() >= this.getGroupLimit())) {
                    currentGroup = this.getArrayGroup(parentElement, i, 0);
                    groups.add(currentGroup);
                }
                if (!this.mayBeInArrayGroup(rx = r.get(i))) continue;
                if (currentGroup == null) {
                    groups.add(this.getVirtualElement(rx, i, null));
                    continue;
                }
                currentGroup.put(i, rx);
            }
            return this.noMoreThanNChildrenGroup(groups, parentElement, 1);
        }
        return r.toArray();
    }

    private Object[] noMoreThanNChildrenGroup(List<IArrayGroup> r, Object parentElement, int toplevel) {
        if (r.size() > this.getLimit()) {
            IArrayGroup subGroup;
            int packageIndex;
            ArrayList<IArrayGroup> groups = new ArrayList<IArrayGroup>();
            for (packageIndex = 0; packageIndex < r.size() && (subGroup = r.get(packageIndex)) instanceof VirtualArrayGroup && !this.mayBeInArrayGroup(subGroup.getFirstElement()); ++packageIndex) {
                groups.add(subGroup);
            }
            if (r.size() - packageIndex <= this.getLimit()) {
                return r.toArray();
            }
            ArrayGroup currentGroup = null;
            for (int i = packageIndex; i < r.size(); ++i) {
                IArrayGroup subGroup2 = r.get(i);
                if (currentGroup == null || currentGroup.count() >= this.getGroupLimit()) {
                    currentGroup = this.getArrayGroup(parentElement, subGroup2.getReferenceIndex(), toplevel);
                    groups.add(currentGroup);
                }
                currentGroup.put(i, subGroup2);
                if (!(subGroup2 instanceof ArrayGroup)) continue;
                ((ArrayGroup)subGroup2).setParent(currentGroup);
            }
            return this.noMoreThanNChildrenGroup(groups, parentElement, toplevel + 1);
        }
        return r.toArray();
    }

    public ArrayLogicalRoot getLogicalGroups(List<?> r, Object parentElement) {
        ArrayLogicalRoot logicalRoot = new ArrayLogicalRoot();
        LabelRule labelRule = new LabelRule();
        List<SeparatorRule> separators = this.getRuleSeparators();
        LinkedHashMap<Couple<String, SeparatorRule>, List<Integer>> groupsByStart = new LinkedHashMap<Couple<String, SeparatorRule>, List<Integer>>();
        for (int i = 0; i < r.size(); ++i) {
            Object o = r.get(i);
            if (this.searchStartExpression(groupsByStart, o, separators, i, 0)) continue;
            logicalRoot.addSingle(i);
        }
        for (Map.Entry groups : groupsByStart.entrySet()) {
            this.addLogicalGroup(logicalRoot, r, parentElement, (List)groups.getValue(), (String)((Couple)groups.getKey()).getFirst(), (SeparatorRule)((Couple)groups.getKey()).getSecond(), labelRule);
        }
        labelRule.setOriginalLabels();
        return logicalRoot;
    }

    private boolean searchStartExpression(Map<Couple<String, SeparatorRule>, List<Integer>> groupsByStart, Object o, List<SeparatorRule> separators, int i, int startExpressionIndex) {
        String label = this.getLabel(o);
        if (label != null && this.mayBeInArrayGroup(o)) {
            String startExpression = null;
            SeparatorRule rule = null;
            for (SeparatorRule separator : separators) {
                startExpression = separator.getStartExpression(label, startExpressionIndex);
                if (startExpression == null) continue;
                rule = separator;
                break;
            }
            if (startExpression == null) {
                return false;
            }
            Couple<Object, Object> key = new Couple<Object, Object>(startExpression, rule);
            List<Integer> indexes = groupsByStart.get(key);
            if (indexes == null) {
                indexes = new ArrayList<Integer>();
                groupsByStart.put(key, indexes);
            }
            indexes.add(i);
            return true;
        }
        return false;
    }

    private void addLogicalGroup(ArrayLogicalRoot logicalRoot, List<?> r, Object parentElement, List<Integer> indexes, String startExpression, SeparatorRule rule, LabelRule labelRule) {
        if (indexes.size() >= this.properties.getMinLogicalGroupSize()) {
            if (rule.isPackage()) {
                ArrayLogicalGroup group = this.addPackagedGroup(r, parentElement, indexes, "", startExpression, rule, 1);
                logicalRoot.add(group);
                return;
            }
            if (indexes.size() > this.getGroupLimit()) {
                int realSize;
                for (int i = 0; i < indexes.size() && (realSize = Math.min(indexes.size() - i * this.getGroupLimit(), this.getGroupLimit())) > 0; ++i) {
                    String groupName = rule.format(startExpression) + " group_" + (i + 1);
                    String label = labelRule.withNumberItemsSuffix(groupName, realSize);
                    ArrayLogicalGroup group = this.buildLogicalGroup(r, parentElement, indexes.subList(i * this.getGroupLimit(), i * this.getGroupLimit() + realSize), label);
                    logicalRoot.add(group);
                }
            } else {
                ArrayLogicalGroup logicalGroup = this.buildLogicalGroup(r, parentElement, indexes, labelRule.generateGroupName());
                logicalRoot.add(logicalGroup);
                labelRule.saveValidLabel(logicalGroup, rule.format(startExpression));
            }
        }
    }

    private ArrayLogicalGroup buildLogicalGroup(List<?> r, Object parentElement, List<Integer> indexes, String groupName) {
        ArrayLogicalGroup group = this.getArrayLogicalGroup(parentElement, indexes.get(0), groupName, false, 0);
        for (int index : indexes) {
            group.put(index, r.get(index));
        }
        return group;
    }

    private ArrayLogicalGroup addPackagedGroup(List<?> r, Object parentElement, List<Integer> indexes, String parentStartExpression, String startExpression, SeparatorRule rule, int toplevel) {
        ArrayLogicalGroup group = this.getArrayLogicalGroup(parentElement, indexes.get(0), rule.format(startExpression.substring(parentStartExpression.length())), true, toplevel);
        LinkedHashMap<Couple<String, SeparatorRule>, List<Integer>> groupsByStart = new LinkedHashMap<Couple<String, SeparatorRule>, List<Integer>>();
        List<SeparatorRule> separators = Arrays.asList(rule);
        Iterator<Object> iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            Object o = r.get(n);
            String label = this.getLabel(o);
            if (label == null) continue;
            if (!label.startsWith(startExpression)) {
                group.put(n, this.getVirtualElement(r.get(n), n, label));
                continue;
            }
            if (this.searchStartExpression(groupsByStart, o, separators, n, startExpression.length())) continue;
            group.put(n, this.getVirtualElement(r.get(n), n, label.substring(startExpression.length())));
        }
        for (Map.Entry entry : groupsByStart.entrySet()) {
            ArrayLogicalGroup subgroup = this.addPackagedGroup(r, parentElement, (List)entry.getValue(), startExpression, (String)((Couple)entry.getKey()).getFirst(), rule, toplevel + 1);
            group.put((Integer)((List)entry.getValue()).get(0), subgroup);
        }
        return group;
    }

    protected List<SeparatorRule> getRuleSeparators() {
        return this.properties.getSeparatorRules();
    }

    public abstract List<?> getChildren2(Object var1);

    public abstract void sort(Object[] var1);

    public void onFirstOptimization(List<?> r) {
    }

    protected boolean mayBeInArrayGroup(Object rx) {
        return true;
    }

    protected abstract String getLabel(Object var1);

    public static String getStringAt(IFilteredLabelProvider labelProvider, Object element, int index) {
        if (element instanceof IArrayGroup) {
            IArrayGroup v = (IArrayGroup)element;
            if (v instanceof ArrayLogicalGroup && index == 0) {
                return ((ArrayLogicalGroup)element).getGroupName();
            }
            if (v.isSingle()) {
                return labelProvider.getStringAt(v.getFirstElement(), index);
            }
            if (index == 0) {
                return Strings.ff("[%d..%d]", v.getReferenceIndex(), v.getEndIndex());
            }
        }
        return null;
    }

    public int getLimit() {
        return this.properties.getLimit() < 10 ? 10 : this.properties.getLimit();
    }

    public int getGroupLimit() {
        return this.properties.getGroupLimit() < 10 ? this.getLimit() : this.properties.getGroupLimit();
    }

    static class LabelRule {
        private static final String prefix = "group_";
        private int groupNumber = 1;
        Map<String, List<ArrayLogicalGroup>> groupByName = new HashMap<String, List<ArrayLogicalGroup>>();

        LabelRule() {
        }

        public String generateGroupName() {
            String groupName = prefix + this.groupNumber;
            ++this.groupNumber;
            return groupName;
        }

        public void setOriginalLabels() {
            for (Map.Entry<String, List<ArrayLogicalGroup>> e : this.groupByName.entrySet()) {
                if (e.getValue().size() != 1) continue;
                e.getValue().get(0).setGroupName(this.withNumberItemsSuffix(e.getKey(), e.getValue().get(0).size()));
            }
        }

        private void saveValidLabel(ArrayLogicalGroup logicalGroup, String label) {
            Maps.putMulti(this.groupByName, label, logicalGroup);
        }

        private String withNumberItemsSuffix(String groupName, int items) {
            StringBuilder stb = new StringBuilder(groupName);
            stb.append(" (").append(items).append(" items)");
            return stb.toString();
        }
    }
}

