/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.themes;

import com.pnfsoftware.jeb.client.Licensing;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.Graph;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.DarkTheme;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.IThemeChangeListener;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.LightTheme;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.StandardTheme;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.Theme;
import com.pnfsoftware.jeb.util.base.OSType;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class ThemeManager {
    private static final ILogger logger = GlobalLog.getLogger(ThemeManager.class);
    public static final String ID_THEME_STANDARD = "theme.standard";
    public static final String ID_THEME_DARK = "theme.dark";
    public static final String ID_THEME_LIGHT = "theme.light";
    private static final Theme standardTheme = new StandardTheme();
    private static ThemeManager instance = new ThemeManager();
    Display display;
    boolean isAppStartedDark;
    Listener filter;
    LinkedHashMap<String, Theme> themes = new LinkedHashMap();
    Theme activeTheme;
    List<IThemeChangeListener> listeners = new ArrayList<IThemeChangeListener>();
    WeakIdentityHashMap<Widget, Integer> seen = new WeakIdentityHashMap();
    public static final int FLAG_PROCEED = 0;
    public static final int FLAG_SKIP_GENERIC = 1;
    public static final int FLAG_SKIP_RECURSION = 2;
    public static final int FLAG_SKIP_ALL = 3;
    private static final String STORED_ORG_COLORS = "storedOriginalColors";
    private static final String BG_SEL_TAB = "cBgSelTab";
    private static final String FG_SEL_TAB = "cFgSelTab";
    private static final String BG_TABLE_HDR = "cBgTableHdr";
    private static final String FG_TABLE_HDR = "cFgTableHdr";
    private static final String BG_TABLE = "cBgTable";
    private static final String FG_TABLE = "cFgTable";
    private static final String BG_TREE_HDR = "cBgTreeHdr";
    private static final String FG_TREE_HDR = "cFgTreeHdr";
    private static final String BG_TREE = "cBgTree";
    private static final String FG_TREE = "cFgTree";
    private static final String BG_TEXT = "cBgText";
    private static final String FG_TEXT = "cFgText";
    private static final String BG_PUSH = "cBgPush";
    private static final String FG_PUSH = "cFgPush";
    private static final String BG_GENERIC = "cBg";
    private static final String FG_GENERIC = "cFg";
    private Map<String, Color> recorder = new HashMap<String, Color>();
    private Map<String, List<ColorMethod>> colmmap = new HashMap<String, List<ColorMethod>>();

    public static ThemeManager getInstance() {
        return instance;
    }

    private ThemeManager() {
        this.display = Display.getCurrent();
        if (this.display == null) {
            throw new RuntimeException("The display must be initialized");
        }
        Color cBg = this.display.getSystemColor(22);
        double lum = cBg.getRGB().getHSB()[2];
        this.isAppStartedDark = lum < 0.25;
        this.activeTheme = this.registerTheme(standardTheme);
        this.registerTheme(new DarkTheme());
        this.registerTheme(new LightTheme());
    }

    private Theme registerTheme(Theme theme) {
        if (this.themes.put(theme.getId(), theme) != null) {
            throw new RuntimeException("Attempt to overwrite a theme");
        }
        return theme;
    }

    public Collection<String> getThemeIds() {
        return Collections.unmodifiableCollection(this.themes.keySet());
    }

    public Collection<Theme> getThemes() {
        return Collections.unmodifiableCollection(this.themes.values());
    }

    public String getActiveThemeId() {
        return this.activeTheme.getId();
    }

    public boolean isStandardTheme() {
        return ID_THEME_STANDARD.equals(this.activeTheme.getId());
    }

    public boolean isDark() {
        return ID_THEME_DARK.equals(this.activeTheme.getId()) || ID_THEME_STANDARD.equals(this.activeTheme.getId()) && this.isAppStartedDark;
    }

    public boolean isLight() {
        return ID_THEME_LIGHT.equals(this.activeTheme.getId()) || ID_THEME_STANDARD.equals(this.activeTheme.getId()) && !this.isAppStartedDark;
    }

    public boolean setNextTheme() {
        ArrayList<String> ids = new ArrayList<String>(this.themes.keySet());
        if (ids.size() <= 1) {
            return false;
        }
        for (int i = 0; i < ids.size(); ++i) {
            String id = (String)ids.get(i);
            if (!id.equals(this.activeTheme.getId())) continue;
            String nextId = (String)ids.get((i + 1) % ids.size());
            return this.setActiveTheme(nextId);
        }
        return false;
    }

    public boolean setActiveTheme(String themeId) {
        Theme wantedTheme;
        if (themeId == null || themeId.isEmpty()) {
            themeId = ID_THEME_STANDARD;
        }
        if ((wantedTheme = this.themes.get(themeId)) == null) {
            throw new IllegalArgumentException("Unknown theme: " + themeId);
        }
        this.setThemeInternal(wantedTheme, false, true);
        return true;
    }

    public void reapplyTheme() {
        this.setThemeInternal(this.activeTheme, true, true);
    }

    private void setThemeInternal(Theme theme, boolean force, boolean notify) {
        if (theme == this.activeTheme && !force) {
            return;
        }
        this.activeTheme = theme;
        if (this.filter == null) {
            this.filter = new Listener(){

                public void handleEvent(Event event) {
                    ThemeManager.this.processControls(event.widget);
                }
            };
            this.display.addFilter(26, this.filter);
            this.display.addFilter(11, this.filter);
        }
        this.seen = new WeakIdentityHashMap();
        for (Shell shell : this.display.getShells()) {
            this.processControls((Widget)shell);
        }
        (new Object[1])[0] = this.activeTheme;
        if (notify) {
            this.notifyThemeChangeListeners(theme == null ? null : theme.getId());
        }
    }

    public void processControlForcibly(Widget w) {
        this.processControls(w, true);
    }

    void processControls(Widget w) {
        this.processControls(w, false);
    }

    void processControls(Widget w, boolean force) {
        if (w == null) {
            return;
        }
        if (this.seen.get(w) != null) {
            if (!force) {
                return;
            }
        } else {
            this.seen.put(w, 0);
        }
        if (!(w instanceof Control)) {
            return;
        }
        Control ctl = (Control)w;
        int r = this.processSpecificControl(ctl);
        boolean alsoProcessGenericBgFg = false;
        if (!alsoProcessGenericBgFg && (r & 1) == 0) {
            if (this.shouldRecord(ctl)) {
                this.record(ctl, BG_GENERIC, ctl.getBackground(), FG_GENERIC, ctl.getForeground());
            }
            if (this.activeTheme == standardTheme) {
                ctl.setBackground((Color)ctl.getData(BG_GENERIC));
                ctl.setForeground((Color)ctl.getData(FG_GENERIC));
            } else {
                ctl.setBackground(this.activeTheme.cBackground);
                ctl.setForeground(this.activeTheme.cForeground);
            }
        }
        if ((r & 2) == 0 && ctl instanceof Composite) {
            for (Control c : ((Composite)ctl).getChildren()) {
                this.processControls((Widget)c, force);
            }
        }
    }

    private boolean shouldRecord(Control ctl) {
        return ctl.getData(STORED_ORG_COLORS) == null;
    }

    private void setRecorded(Control ctl) {
        ctl.setData(STORED_ORG_COLORS, (Object)true);
    }

    private void record(Control ctl, String bgKey, Color bgColor, String fgKey, Color fgColor) {
        ctl.setData(bgKey, (Object)bgColor);
        ctl.setData(fgKey, (Object)fgColor);
        this.setRecorded(ctl);
        if (Licensing.isDebugBuild()) {
            Color bgCol0 = this.recorder.put(bgKey, bgColor);
            if (bgCol0 != null && !bgCol0.equals((Object)bgColor)) {
                Object[] objectArray = new Object[]{bgKey, ctl.getClass().getSimpleName(), bgColor, bgCol0};
            } else if (bgCol0 == null) {
                Object[] objectArray = new Object[]{bgKey, ctl.getClass().getSimpleName(), bgColor};
            }
            Color fgCol0 = this.recorder.put(fgKey, fgColor);
            if (fgCol0 != null && !fgCol0.equals((Object)fgColor)) {
                Object[] objectArray = new Object[]{fgKey, ctl.getClass().getSimpleName(), fgColor, fgCol0};
            } else if (fgCol0 == null) {
                Object[] objectArray = new Object[]{fgKey, ctl.getClass().getSimpleName(), fgColor};
            }
        }
    }

    private int processSpecificControl(Control ctl) {
        if (ctl instanceof CTabFolder) {
            CTabFolder c = (CTabFolder)ctl;
            if (this.shouldRecord(ctl)) {
                this.record(ctl, BG_SEL_TAB, c.getSelectionBackground(), FG_SEL_TAB, c.getSelectionForeground());
            }
            if (this.activeTheme == standardTheme) {
                c.setSelectionBackground((Color)ctl.getData(BG_SEL_TAB));
                c.setSelectionForeground((Color)ctl.getData(FG_SEL_TAB));
            } else {
                c.setSelectionBackground(this.activeTheme.cBackgroundSelectedTab);
                c.setSelectionForeground(this.activeTheme.cForegroundSelectedTab);
            }
            return 0;
        }
        if (ctl instanceof Table) {
            Table c = (Table)ctl;
            if (this.shouldRecord(ctl)) {
                this.record(ctl, BG_TABLE_HDR, c.getHeaderBackground(), FG_TABLE_HDR, c.getHeaderForeground());
                this.record(ctl, BG_TABLE, c.getBackground(), FG_TABLE, c.getForeground());
            }
            if (this.activeTheme == standardTheme) {
                c.setHeaderBackground((Color)ctl.getData(BG_TABLE_HDR));
                c.setHeaderForeground((Color)ctl.getData(FG_TABLE_HDR));
                c.setBackground((Color)ctl.getData(BG_TABLE));
                c.setForeground((Color)ctl.getData(FG_TABLE));
            } else {
                c.setHeaderBackground(this.activeTheme.cBackgroundTableHeader);
                c.setHeaderForeground(this.activeTheme.cForegroundTableHeader);
                c.setBackground(this.activeTheme.cBackgroundTable);
                c.setForeground(this.activeTheme.cForegroundTable);
            }
            return 1;
        }
        if (ctl instanceof Tree) {
            Tree c = (Tree)ctl;
            if (this.shouldRecord(ctl)) {
                this.record(ctl, BG_TREE_HDR, c.getHeaderBackground(), FG_TREE_HDR, c.getHeaderForeground());
                this.record(ctl, BG_TREE, c.getBackground(), FG_TREE, c.getForeground());
            }
            if (this.activeTheme == standardTheme) {
                c.setHeaderBackground((Color)ctl.getData(BG_TREE_HDR));
                c.setHeaderForeground((Color)ctl.getData(FG_TREE_HDR));
                c.setBackground((Color)ctl.getData(BG_TREE));
                c.setForeground((Color)ctl.getData(FG_TREE));
            } else {
                c.setHeaderBackground(this.activeTheme.cBackgroundTableHeader);
                c.setHeaderForeground(this.activeTheme.cForegroundTableHeader);
                c.setBackground(this.activeTheme.cBackgroundTable);
                c.setForeground(this.activeTheme.cForegroundTable);
            }
            return 1;
        }
        if (ctl instanceof Text) {
            if (this.shouldRecord(ctl)) {
                this.record(ctl, BG_TEXT, ctl.getBackground(), FG_TEXT, ctl.getForeground());
            }
            if (this.activeTheme == standardTheme) {
                ctl.setBackground((Color)ctl.getData(BG_TEXT));
                ctl.setForeground((Color)ctl.getData(FG_TEXT));
            } else {
                Color fg;
                Color bg;
                boolean isReadOnly;
                boolean bl = isReadOnly = (((Text)ctl).getStyle() & 8) != 0;
                if (isReadOnly) {
                    bg = this.activeTheme.cBackgroundFilterRO;
                    fg = this.activeTheme.cForegroundFilterRO;
                } else {
                    bg = this.activeTheme.cBackgroundFilter;
                    fg = this.activeTheme.cForegroundFilter;
                }
                ctl.setBackground(bg);
                ctl.setForeground(fg);
            }
            return 3;
        }
        if ((ctl.getStyle() & 8) != 0) {
            if (this.shouldRecord(ctl)) {
                this.record(ctl, BG_PUSH, ctl.getBackground(), FG_PUSH, ctl.getForeground());
            }
            if (this.activeTheme == standardTheme) {
                if (!OSType.determine().isLinux()) {
                    ctl.setBackground((Color)ctl.getData(BG_PUSH));
                }
                ctl.setForeground((Color)ctl.getData(FG_PUSH));
            } else {
                ctl.setBackground(this.activeTheme.cBackgroundFilter);
                ctl.setForeground(this.activeTheme.cForegroundFilter);
            }
            return 3;
        }
        if (ctl instanceof Graph || ctl instanceof Sash) {
            return 1;
        }
        return 0;
    }

    public void addThemeChangeListener(IThemeChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeThemeChangeListener(IThemeChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyThemeChangeListeners(String themeId) {
        for (IThemeChangeListener listener : this.listeners) {
            listener.onThemeChange(this.activeTheme);
        }
    }

    public Color getBackgroundColor() {
        return this.activeTheme.getBackground();
    }

    public Color getForegroundColor() {
        return this.activeTheme.getForeground();
    }

    public void registerWidget(Control ctl) {
        ctl.setBackground(this.getBackgroundColor());
        IThemeChangeListener listener = e -> ctl.setBackground(this.getBackgroundColor());
        this.addThemeChangeListener(listener);
        ctl.addDisposeListener(e -> this.removeThemeChangeListener(listener));
    }

    private int processSpecificControl_M2(Control ctl, boolean alsoProcessGenericBgFg) {
        Class<?> c = ctl.getClass();
        List<ColorMethod> methods = this.colmmap.get(c.getName());
        if (methods == null) {
            methods = new ArrayList<ColorMethod>();
            this.colmmap.put(c.getName(), methods);
            for (Method m : c.getMethods()) {
                String name;
                if ((m.getModifiers() & 1) == 0 || m.getParameterCount() != 1 || m.getParameterTypes()[0] != Color.class || !(name = m.getName()).startsWith("set")) continue;
                String action = name.substring(3);
                Method m2 = this.findColorGetter(c, action);
                methods.add(new ColorMethod(action, m, m2));
            }
            Object[] objectArray = new Object[]{c.getName(), methods};
        }
        boolean record = this.shouldRecord(ctl);
        for (ColorMethod e : methods) {
            if (!alsoProcessGenericBgFg && Strings.isContainedIn(e.action, "Foreground", "Background")) continue;
            String key = "col_" + e.action;
            if (record) {
                ctl.setData(key, (Object)this.execColorGetter(e.getter, ctl));
            }
            if (this.activeTheme == standardTheme) {
                this.execColorSetter(e.setter, ctl, (Color)ctl.getData(key));
                continue;
            }
            Color col = (Color)ctl.getData(key);
            col = this.activeTheme.experimentMakeMoreRed(col, e.action);
            this.execColorSetter(e.setter, ctl, col);
        }
        if (record) {
            this.setRecorded(ctl);
        }
        return 0;
    }

    private Method findColorGetter(Class<?> c, String action) {
        try {
            String name = "get" + action;
            Method m = c.getMethod(name, new Class[0]);
            if ((m.getModifiers() & 1) != 0 && m.getParameterCount() == 0 && m.getReturnType() == Color.class) {
                return m;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return null;
    }

    private void execColorSetter(Method m, Control ctl, Color col) {
        if (m != null) {
            try {
                m.invoke((Object)ctl, col);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
        }
    }

    private Color execColorGetter(Method m, Control ctl) {
        if (m != null) {
            try {
                return (Color)m.invoke((Object)ctl, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
        }
        return null;
    }

    private static class ColorMethod {
        String action;
        Method setter;
        Method getter;

        public ColorMethod(String action, Method setter, Method getter) {
            if (action == null || setter == null) {
                throw new IllegalArgumentException();
            }
            this.action = action;
            this.setter = setter;
            this.getter = getter;
        }

        public String toString() {
            return Strings.ff("%s: %s/%s", this.action, this.setter != null, this.getter != null);
        }
    }
}

