/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.themes;

import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.util.format.Strings;
import org.eclipse.swt.graphics.Color;

public abstract class Theme {
    private String id;
    private String name;
    protected Color cBackground;
    protected Color cForeground;
    protected Color cBackgroundSelectedTab;
    protected Color cForegroundSelectedTab;
    protected Color cBackgroundTableHeader;
    protected Color cForegroundTableHeader;
    protected Color cBackgroundFilter;
    protected Color cForegroundFilter;
    protected Color cBackgroundFilterRO;
    protected Color cForegroundFilterRO;
    protected Color cBackgroundReadOnlyText;
    protected Color cForegroundReadOnlyText;
    protected Color cBackgroundTable;
    protected Color cForegroundTable;

    public Theme(String id, String name) {
        if (id == null) {
            throw new NullPointerException("Theme id cannot be null");
        }
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Color getBackground() {
        return this.cBackground;
    }

    public Color getForeground() {
        return this.cForeground;
    }

    public String toString() {
        return Strings.ff("Theme{%s}", this.id);
    }

    public Color experimentMakeMoreRed(Color col, String action) {
        int mode = 0;
        if (action.toLowerCase().contains("foreground")) {
            mode = 1;
        } else if (action.toLowerCase().contains("background")) {
            mode = 2;
        }
        if (col == null) {
            if (mode == 1) {
                return this.getForeground();
            }
            if (mode == 2) {
                return this.getBackground();
            }
            return this.getForeground();
        }
        col = UIAssetManager.getInstance().getColor(255, col.getGreen(), col.getBlue());
        return col;
    }
}

