/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.search;

import com.pnfsoftware.jeb.rcpclient.extensions.search.FindTextOptions;
import com.pnfsoftware.jeb.rcpclient.extensions.search.IFinder;
import com.pnfsoftware.jeb.rcpclient.extensions.search.SimpleTextFindResults;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;

public class StyledTextFindImpl
implements IFinder<SimpleTextFindResults> {
    private static final ILogger logger = GlobalLog.getLogger(StyledTextFindImpl.class);
    StyledText widget;
    FindTextOptions findOptions;
    String text;
    int position;

    public StyledTextFindImpl(StyledText widget) {
        if (widget == null) {
            throw new NullPointerException();
        }
        this.widget = widget;
    }

    @Override
    public boolean supportCaseInsensitive() {
        return true;
    }

    @Override
    public boolean supportRegex() {
        return true;
    }

    @Override
    public boolean supportReverseSearch() {
        return true;
    }

    @Override
    public boolean supportWrapAround() {
        return true;
    }

    @Override
    public void resetFindTextOptions() {
        this.findOptions = null;
    }

    @Override
    public void setFindTextOptions(FindTextOptions options) {
        this.findOptions = options;
    }

    @Override
    public FindTextOptions getFindTextOptions(boolean update) {
        if (this.findOptions == null) {
            this.findOptions = new FindTextOptions(this.widget.getSelectionText());
        }
        if (update) {
            this.text = this.widget.getText();
            this.position = this.widget.getCaretOffset();
        }
        return this.findOptions;
    }

    @Override
    public SimpleTextFindResults findText(FindTextOptions optionsOverride) {
        FindTextOptions options;
        if (this.text == null) {
            return null;
        }
        FindTextOptions findTextOptions = options = optionsOverride != null ? optionsOverride : this.findOptions;
        if (options == null || options.getSearchString() == null || options.getSearchString().isEmpty()) {
            return null;
        }
        if (options.isBinary()) {
            return null;
        }
        boolean wrappedAround = false;
        while (true) {
            int index;
            if ((index = Strings.search(this.text, this.position, options.getSearchString(), options.isRegularExpression(), options.isCaseSensitive(), options.isReverseSearch())) >= 0) {
                return new SimpleTextFindResults(index, index + options.getSearchString().length(), wrappedAround);
            }
            if (!options.isWrapAround()) break;
            if (!options.isReverseSearch()) {
                if (this.position == 0) break;
                this.position = 0;
            } else {
                if (this.position == this.text.length()) break;
                this.position = this.text.length();
            }
            wrappedAround = true;
        }
        return SimpleTextFindResults.EOS;
    }

    @Override
    public void processFindResult(SimpleTextFindResults r) {
        if (r == null) {
            return;
        }
        if (r.isEndOfSearch()) {
            Display.getCurrent().beep();
            logger.trace("End of search", new Object[0]);
            return;
        }
        if (r.isWrappedAround()) {
            Display.getCurrent().beep();
            logger.trace("Search wrapped around", new Object[0]);
        }
        if (!this.findOptions.isReverseSearch()) {
            this.widget.setSelection(r.getIndexBegin(), r.getIndexEnd());
        } else {
            this.widget.setSelection(r.getIndexEnd(), r.getIndexBegin());
        }
    }

    @Override
    public void clearFindResult() {
        int offset = this.widget.getCaretOffset();
        this.widget.setSelection(offset);
    }
}

