/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.search;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.rcpclient.IGraphicalTaskExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.search.FindTextOptions;
import com.pnfsoftware.jeb.rcpclient.extensions.search.IFindTextResult;
import com.pnfsoftware.jeb.rcpclient.extensions.search.IFinder;
import com.pnfsoftware.jeb.util.concurrent.MonitorInfoAdapter;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;

public class FinderManager<FindTextResult extends IFindTextResult> {
    private IGraphicalTaskExecutor taskExecutor;
    private IFinder<FindTextResult> defaultFinder;
    private IFinder<FindTextResult> binaryFinder;
    private IFinder<FindTextResult> finder0;
    private FindTextResult lastResult;
    private boolean searchInterrupted;

    public FinderManager(IFinder<FindTextResult> defaultFinder, IGraphicalTaskExecutor taskExecutor) {
        if (defaultFinder == null) {
            throw new NullPointerException();
        }
        this.defaultFinder = defaultFinder;
        this.taskExecutor = taskExecutor;
    }

    public IFinder<FindTextResult> retrieveFinderFromOptions(FindTextOptions opt) {
        if (opt == null) {
            return null;
        }
        return opt.isBinary() ? this.getBinaryFinder() : this.getDefaultFinder();
    }

    public IFinder<FindTextResult> getDefaultFinder() {
        return this.defaultFinder;
    }

    public void setBinaryFinder(IFinder<FindTextResult> binaryFinder) {
        this.binaryFinder = binaryFinder;
    }

    public IFinder<FindTextResult> getBinaryFinder() {
        return this.binaryFinder;
    }

    public IFinder<FindTextResult> getLastUsedFinder() {
        return this.finder0 != null ? this.finder0 : this.defaultFinder;
    }

    public boolean isReady() {
        return true;
    }

    public synchronized void search(FindTextOptions opt) {
        IFinder<FindTextResult> finder = this.retrieveFinderFromOptions(opt);
        if (finder == null) {
            finder = this.finder0;
        }
        if (finder == null) {
            this.lastResult = null;
            return;
        }
        this.finder0 = finder;
        finder.getFindTextOptions(true);
        this.lastResult = null;
        this.searchInterrupted = false;
        if (this.taskExecutor == null) {
            this.lastResult = finder.findText(opt);
        } else {
            MonitorInfoAdapter monitor = new MonitorInfoAdapter(3000L, 300L){

                @Override
                public void onInterrupt() {
                    FinderManager.this.searchInterrupted = true;
                }
            };
            ThreadUtil.monitor(ThreadUtil.start(() -> {
                this.lastResult = this.finder0.findText(opt);
            }), monitor);
            if (this.lastResult == null) {
                if (!this.searchInterrupted) {
                    return;
                }
                this.taskExecutor.executeTask(S.s(714) + "...", () -> {
                    this.lastResult = this.finder0.findText(opt);
                    return this.lastResult;
                });
            }
        }
        if (this.lastResult != null) {
            finder.processFindResult(this.lastResult);
        }
    }

    public boolean isEndOfSearch() {
        return this.lastResult != null && this.lastResult.isEndOfSearch();
    }
}

