/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.graph.model;

import com.pnfsoftware.jeb.rcpclient.extensions.graph.fast.P;
import com.pnfsoftware.jeb.util.graph.Digraph;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Random;

public class CommunityDetector {
    private static final ILogger logger = GlobalLog.getLogger(CommunityDetector.class);
    private Random prng = new Random(0L);

    public Node perform(Digraph g) {
        Node root = new Node();
        this.performRecurse(g, root);
        return root;
    }

    public Node perform(Digraph g, int subgraphCountThreshold) {
        return this.performIter(g, subgraphCountThreshold);
    }

    private int performRecurse(Digraph g, Node node) {
        List<Digraph> subgraphs;
        if (g.getVertexCount() == 1) {
            node.vertexId = g.getVertexByIndex(0).getId();
            return 1;
        }
        while ((subgraphs = g.getWeaklyConnectedComponents()).size() <= 1) {
            double score;
            int cnt;
            List<Integer> ebOrder = g.computeEdgeBetweenness();
            Digraph.E e = g.getEdge(ebOrder.get(0));
            double bestScore = e.getEdgeBetweennessScore();
            ArrayList<Digraph.E> tbr = new ArrayList<Digraph.E>();
            tbr.add(e);
            for (cnt = 1; cnt < g.getEdgeCount() && CommunityDetector.almostEquals(score = (e = g.getEdge(ebOrder.get(cnt))).getEdgeBetweennessScore().doubleValue(), bestScore); ++cnt) {
                tbr.add(e);
            }
            if (cnt >= 2) {
                Object[] objectArray = new Object[]{cnt, bestScore};
            }
            for (Digraph.E edge : tbr) {
                g.removeEdge(edge);
            }
        }
        (new Object[1])[0] = subgraphs.size();
        node.children = new ArrayList<Node>(subgraphs.size());
        for (Digraph subgraph : subgraphs) {
            Node subnode = new Node();
            node.children.add(subnode);
            int cnt = this.performRecurse(subgraph, subnode);
            node.descCount += cnt;
        }
        return node.descCount;
    }

    private Node performIter(Digraph inputGraph, int subgraphCountThreshold) {
        ArrayList<Digraph> q = new ArrayList<Digraph>();
        q.add(inputGraph);
        IdentityHashMap<Digraph, Node> map = new IdentityHashMap<Digraph, Node>();
        Node inputNode = new Node(inputGraph);
        map.put(inputGraph, inputNode);
        while (!(q.isEmpty() || subgraphCountThreshold > 0 && q.size() >= subgraphCountThreshold)) {
            List<Digraph> subgraphs;
            Digraph g = (Digraph)q.remove(0);
            Node node = (Node)map.get(g);
            if (g.getVertexCount() == 1) {
                node.vertexId = g.getVertexByIndex(0).getId();
                continue;
            }
            while ((subgraphs = g.getWeaklyConnectedComponents()).size() <= 1) {
                double score;
                int cnt;
                List<Integer> ebOrder = g.computeEdgeBetweenness();
                Digraph.E e = g.getEdge(ebOrder.get(0));
                double bestScore = e.getEdgeBetweennessScore();
                ArrayList<Digraph.E> tbr = new ArrayList<Digraph.E>();
                tbr.add(e);
                for (cnt = 1; cnt < g.getEdgeCount() && CommunityDetector.almostEquals(score = (e = g.getEdge(ebOrder.get(cnt))).getEdgeBetweennessScore().doubleValue(), bestScore); ++cnt) {
                    tbr.add(e);
                }
                if (cnt >= 2) {
                    Object[] objectArray = new Object[]{cnt, bestScore};
                }
                for (Digraph.E edge : tbr) {
                    g.removeEdge(edge);
                }
            }
            (new Object[1])[0] = subgraphs.size();
            node.children = new ArrayList<Node>(subgraphs.size());
            for (Digraph subgraph : subgraphs) {
                Node subnode = new Node(subgraph);
                node.children.add(subnode);
                map.put(subgraph, subnode);
            }
            q.addAll(subgraphs);
        }
        return inputNode;
    }

    private static boolean almostEquals(double a, double b) {
        return Math.abs(a - b) <= 1.0E-7;
    }

    public List<P> layout(Node root) {
        return this.layout(root, 0.0, 0.0, 1.0, 1.0);
    }

    public List<P> layout(Node root, double gridX, double gridY, double gridW, double gridH) {
        ArrayList<P> points = new ArrayList<P>();
        this.layoutInternal(root, gridX, gridY, gridW, gridH, points);
        return points;
    }

    public void layoutInternal(Node node, double gridX, double gridY, double gridW, double gridH, List<P> points) {
        if (node.children != null) {
            boolean splitHorz = gridW > gridH;
            int N = node.descCount;
            if (splitHorz) {
                double W = gridW / (double)N;
                for (Node child : node.children) {
                    double w = W * (double)Math.max(1, child.descCount);
                    this.layoutInternal(child, gridX, gridY, w, gridH, points);
                    gridX += w;
                }
            } else {
                double H = gridH / (double)N;
                for (Node child : node.children) {
                    double h = H * (double)Math.max(1, child.descCount);
                    this.layoutInternal(child, gridX, gridY, gridW, h, points);
                    gridY += h;
                }
            }
        } else {
            double x = gridX + gridW / 2.0;
            double y = gridY + gridH / 2.0;
            points.add(new P(node.vertexId, x, y));
        }
    }

    public static class Node {
        Digraph originalSubgraphRef;
        List<Node> children;
        Integer vertexId;
        int descCount;

        Node() {
        }

        Node(Digraph g) {
            this.originalSubgraphRef = g;
            this.descCount = this.originalSubgraphRef.getVertexCount();
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public Integer getVertexId() {
            return this.vertexId;
        }

        public String toString() {
            if (this.children != null) {
                return this.descCount + ":" + this.children.toString();
            }
            return Integer.toString(this.vertexId);
        }
    }
}

