/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.graph.layout;

import com.pnfsoftware.jeb.rcpclient.extensions.graph.layout.Cell;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.layout.RowCol;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;

public class Spreadsheet<T> {
    private static final ILogger logger = GlobalLog.getLogger(Spreadsheet.class);
    List<List<Cell<T>>> grid = new ArrayList<List<Cell<T>>>();
    int lastRowIndex;
    int lastColumnIndex;

    public Spreadsheet() {
        this(0, 0);
    }

    public Spreadsheet(int idealRowCount, int idealColumnCount) {
    }

    public int getLastRowIndex() {
        return this.lastRowIndex;
    }

    public int getLastColumnIndex() {
        return this.lastColumnIndex;
    }

    public int getRowCount() {
        return this.lastRowIndex + 1;
    }

    public int getColumnCount() {
        return this.lastColumnIndex + 1;
    }

    public void verify() {
        List<Cell<T>> cellrow;
        int row;
        if (this.grid.size() != this.getRowCount()) {
            throw new RuntimeException(Strings.ff("Expected %d rows, got %d", this.getRowCount(), this.grid.size()));
        }
        for (row = 0; row < this.getRowCount(); ++row) {
            cellrow = this.grid.get(row);
            if (cellrow == null || cellrow.size() == this.getColumnCount()) continue;
            throw new RuntimeException(Strings.ff("Row %d: Expected %d columns, got %d", row, this.getColumnCount(), cellrow.size()));
        }
        for (row = 0; row < this.getRowCount(); ++row) {
            cellrow = this.grid.get(row);
            if (cellrow == null) continue;
            for (int col = 0; col < this.getColumnCount(); ++col) {
                Cell<T> cell = cellrow.get(col);
                if (cell == null || !cell.isPartOfMergedCell()) continue;
                if (cell.getRow() != row || cell.getColumn() != col) {
                    throw new RuntimeException(Strings.ff("Inconsistent cell coordinates: expected (%d,%d), got (%d,%d)", row, col, cell.getRow(), cell.getColumn()));
                }
                if (cell.horiMergerDisp > 0 && cell.horiMergerDisp < 0) {
                    throw new RuntimeException();
                }
                if (cell.vertMergerDisp > 0 && cell.vertMergerDisp < 0) {
                    throw new RuntimeException();
                }
                if (cell.isPrimary()) {
                    int i = 0;
                    for (int row2 = row; row2 <= row + cell.vertMergerDisp; ++row2) {
                        for (int col2 = col; col2 <= col + cell.horiMergerDisp; ++col2) {
                            if (i++ == 0) continue;
                            Cell<T> slave = this.getCellInternal(row2, col2);
                            if (slave == null) {
                                throw new RuntimeException(Strings.ff("%d,%d: Expected slave cell, got null", row2, col2));
                            }
                            if (row2 + slave.vertMergerDisp != row) {
                                throw new RuntimeException(Strings.ff("%d,%d: Bad slave vertical displacement", row2, col2));
                            }
                            if (col2 + slave.horiMergerDisp == col) continue;
                            throw new RuntimeException(Strings.ff("%d,%d: Bad slave horizontal displacement", row2, col2));
                        }
                    }
                    continue;
                }
                int row2 = row + cell.vertMergerDisp;
                int col2 = col + cell.horiMergerDisp;
                Cell<T> master = this.getCellInternal(row2, col2);
                if (master != null && master.isPrimary() && master.isPartOfMergedCell()) continue;
                throw new RuntimeException(Strings.ff("%d,%d: slave does not reference a master cell", row, col));
            }
        }
    }

    public int clearNullCells(boolean includeNullMergers) {
        int cnt = 0;
        for (int row = 0; row < this.getRowCount(); ++row) {
            List<Cell<T>> cellrow = this.grid.get(row);
            if (cellrow == null) continue;
            for (int col = 0; col < this.getColumnCount(); ++col) {
                Cell<T> cell = cellrow.get(col);
                if (cell == null || cell.getObject() != null || !includeNullMergers && cell.isPartOfMergedCell()) continue;
                for (int row2 = row; row2 <= row + cell.vertMergerDisp; ++row2) {
                    for (int col2 = col; col2 <= col + cell.horiMergerDisp; ++col2) {
                        this.grid.get(row2).set(col2, null);
                        ++cnt;
                    }
                }
            }
        }
        return cnt;
    }

    public int findNullRow(int rowStart, boolean includeNullMergers) {
        block0: for (int row = rowStart; row < this.getRowCount(); ++row) {
            List<Cell<T>> cellrow = this.grid.get(row);
            if (cellrow == null) {
                return row;
            }
            for (int col = 0; col < this.getColumnCount(); ++col) {
                Cell<T> cell = cellrow.get(col);
                if (cell != null && (cell.getObject() != null || cell.isPartOfMergedCell() && (!includeNullMergers || cell.getPrimary(this).getObject() != null))) continue block0;
            }
            return row;
        }
        return -1;
    }

    public int findNullColumn(int columnStart, boolean includeNullMergers) {
        block0: for (int col = columnStart; col < this.getColumnCount(); ++col) {
            for (int row = 0; row < this.getRowCount(); ++row) {
                Cell<T> cell = this.getCellInternal(row, col);
                if (cell != null && (cell.getObject() != null || cell.isPartOfMergedCell() && (!includeNullMergers || cell.getPrimary(this).getObject() != null))) continue block0;
            }
            return col;
        }
        return -1;
    }

    public void removeRow(int row) {
        List<Cell<T>> cells = this.grid.get(row);
        if (cells == null) {
            this.grid.remove(row);
            return;
        }
        for (int col = 0; col < this.getColumnCount(); ++col) {
            Cell<T> cell = cells.get(col);
            if (cell == null) {
                cells.remove(col);
                continue;
            }
            if (cell.isPartOfMergedCell()) {
                throw new RuntimeException();
            }
            cells.remove(col);
        }
    }

    public void removeColumn(int col) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            List<Cell<T>> cells = this.grid.get(row);
            if (cells == null) continue;
            Cell<T> cell = cells.get(col);
            if (cell == null) {
                cells.remove(col);
                continue;
            }
            if (cell.isPartOfMergedCell()) {
                throw new RuntimeException();
            }
            cells.remove(col);
        }
    }

    private Cell<T> nullifyCell(int row, int col) {
        return this.writeCell(row, col, null);
    }

    public Cell<T> writeCell(int row, int col, T object) {
        return this.writeCell(row, col, 0, 0, object, false);
    }

    public Cell<T> writeCell(int row, int col, int hspan, int vspan, T object) {
        return this.writeCell(row, col, hspan, vspan, object, false);
    }

    public Cell<T> writeCell(int row, int col, int hspan, int vspan, T object, boolean failOnOverwrite) {
        if (row < 0 || col < 0) {
            throw new IllegalArgumentException("Illegal cell coordinates");
        }
        if (hspan < 0 || vspan < 0) {
            throw new IllegalArgumentException("Illegal spanning");
        }
        if (hspan == 0 && vspan != 0 || hspan != 0 && vspan == 0) {
            throw new IllegalArgumentException("Illegal hspan/vspan combo");
        }
        while (row >= this.grid.size()) {
            this.grid.add(null);
        }
        List<Cell<T>> cells = this.grid.get(row);
        if (cells == null) {
            cells = new ArrayList<Cell<T>>();
            this.grid.set(row, cells);
        }
        if (row > this.lastRowIndex) {
            this.lastRowIndex = row;
        }
        while (col >= cells.size()) {
            cells.add(null);
        }
        Cell<T> cell = cells.get(col);
        if (cell == null) {
            cell = new Cell(row, col);
            cells.set(col, cell);
        }
        if (col > this.lastColumnIndex) {
            this.lastColumnIndex = col;
        } else if (col < this.lastColumnIndex) {
            while (cells.size() < this.lastColumnIndex + 1) {
                cells.add(null);
            }
        }
        cell = hspan == 0 && vspan == 0 ? cell.getPrimary(this) : this.mergeCells(row, col, hspan, vspan);
        if (failOnOverwrite && cell.obj != null) {
            throw new RuntimeException(Strings.ff("Cell: Cannot overwrite '%s' by '%s'", cell.obj, object));
        }
        cell.obj = object;
        return cell;
    }

    Cell<T> getCellInternal(int row, int col) {
        if (row < 0 || col < 0) {
            throw new IllegalArgumentException("Illegal cell coordinnates");
        }
        if (row >= this.grid.size()) {
            return null;
        }
        List<Cell<T>> cells = this.grid.get(row);
        if (cells == null) {
            return null;
        }
        if (col >= cells.size()) {
            return null;
        }
        return cells.get(col);
    }

    public Cell<T> getCellSmart(int row, int col, boolean adjustCoordinatesForMergedCells) {
        Cell<T> cell = this.getCellInternal(row, col);
        if (cell != null && adjustCoordinatesForMergedCells) {
            cell = cell.getPrimary(this);
        }
        return cell;
    }

    public Cell<T> getCell(int row, int col) {
        return this.getCell(row, col, false);
    }

    public Cell<T> getCell(int row, int col, boolean createIfNull) {
        Cell<Object> cell = this.getCellInternal(row, col);
        if (cell == null) {
            if (createIfNull) {
                cell = this.writeCell(row, col, null);
            }
        } else if (!cell.isPrimary()) {
            throw new IllegalArgumentException(Strings.ff("The cell at (%d,%d) is not a primary cell", row, col));
        }
        return cell;
    }

    public boolean isFree(int row, int col) {
        return this.isFree(row, col, 1, 1);
    }

    public boolean isRangeFree(int row, int colBegin, int colEnd) {
        return this.isFree(row, colBegin, colEnd - colBegin, 1);
    }

    public boolean isFree(int row, int col, int hspan, int vspan) {
        for (int i = row; i < row + vspan; ++i) {
            for (int j = col; j < col + hspan; ++j) {
                if (this.getCellInternal(i, j) == null) continue;
                return false;
            }
        }
        return true;
    }

    public Cell<T> mergeCells(int row, int col, int horizontalSpan, int verticalSpan) {
        if (horizontalSpan <= 0 || verticalSpan <= 0) {
            throw new IllegalArgumentException("Spanning requirements cannot be negative or zero");
        }
        Cell<Object> cell = this.getCellInternal(row, col);
        if (cell == null) {
            cell = this.writeCell(row, col, null);
        } else {
            if (!cell.isPrimary()) {
                throw new IllegalArgumentException("Main cell is not a primary");
            }
            if (cell.getHorizontalSpan() == horizontalSpan && cell.getVerticalSpan() == verticalSpan) {
                return cell;
            }
        }
        for (int i = row; i < row + verticalSpan; ++i) {
            for (int j = col; j < col + horizontalSpan; ++j) {
                Cell<T> master;
                Cell<T> c = this.getCellInternal(i, j);
                if (c == null || (master = c.getPrimary(this)).getRow() >= row && master.getNextRow() <= row + verticalSpan && master.getColumn() >= col && master.getColumn() <= col + horizontalSpan) continue;
                throw new RuntimeException("Merging partially overlaps other merged cells");
            }
        }
        int vdisp = 0;
        for (int i = row; i < row + verticalSpan; ++i) {
            int hdisp = 0;
            for (int j = col; j < col + horizontalSpan; ++j) {
                Cell<T> c = this.getCellInternal(i, j);
                if (c == null) {
                    c = this.nullifyCell(i, j);
                } else if (c != cell) {
                    c.obj = null;
                }
                if (i == row && j == col) {
                    c.horiMergerDisp = horizontalSpan - 1;
                    c.vertMergerDisp = verticalSpan - 1;
                } else {
                    c.horiMergerDisp = hdisp;
                    c.vertMergerDisp = vdisp;
                }
                --hdisp;
            }
            --vdisp;
        }
        return cell;
    }

    public Cell<T> splitCell(Cell<T> cell, boolean horizontal) {
        if (!cell.isPrimary()) {
            throw new IllegalArgumentException("The cell must be a primary cell");
        }
        Cell splitcell = null;
        if (horizontal) {
            int targetrow = cell.getRow();
            int targetcol = cell.getColumn();
            if (cell.horiMergerDisp > 0) {
                int row;
                int i = 0;
                for (row = targetrow; row <= targetrow + cell.vertMergerDisp; ++row) {
                    List<Cell<T>> cells = this.grid.get(row);
                    for (int col = targetcol + 1; col <= targetcol + cell.horiMergerDisp; ++col) {
                        Cell<T> cell2 = cells.get(col);
                        if (i++ == 0) {
                            cell2.horiMergerDisp = cell.horiMergerDisp - 1;
                            cell2.vertMergerDisp = cell.vertMergerDisp;
                            splitcell = cell2;
                            continue;
                        }
                        ++cell2.horiMergerDisp;
                    }
                }
                for (row = targetrow; row <= targetrow + cell.vertMergerDisp; ++row) {
                    this.getCellInternal((int)row, (int)targetcol).horiMergerDisp = 0;
                }
            } else {
                int inscol = targetcol + 1;
                int row = 0;
                for (List<Cell<T>> cellrow : this.grid) {
                    if (cellrow != null) {
                        int base = 0;
                        if (row != targetrow) {
                            for (int col = targetcol; col >= 0; --col) {
                                Cell<T> c = cellrow.get(col);
                                if (c == null) {
                                    c = new Cell(row, col);
                                    cellrow.set(col, c);
                                }
                                if (c.horiMergerDisp >= 0) {
                                    ++c.horiMergerDisp;
                                    break;
                                }
                                --base;
                            }
                        }
                        Cell ci = new Cell(row, inscol);
                        cellrow.add(inscol, ci);
                        if (row != targetrow) {
                            ci.horiMergerDisp = base - 1;
                        } else {
                            splitcell = ci;
                        }
                        boolean mergerUpdate = true;
                        for (int col = inscol + 1; col < cellrow.size(); ++col) {
                            Cell<T> c = cellrow.get(col);
                            if (c == null) {
                                c = new Cell(row, col);
                                cellrow.set(col, c);
                            }
                            c.coords = new RowCol(row, col);
                            if (!mergerUpdate) continue;
                            if (c.horiMergerDisp >= 0) {
                                mergerUpdate = false;
                                continue;
                            }
                            --c.horiMergerDisp;
                        }
                    }
                    ++row;
                }
                ++this.lastColumnIndex;
            }
        } else {
            throw new RuntimeException("Vertical splits for cells are not supported yet");
        }
        return splitcell;
    }

    public Cell<T> moveCell(Cell<T> cell, int dstRow, int dstCol, boolean keepSpanning) {
        Assert.a(cell.isPrimary(), "Expected a primary cell");
        int dstHspan = 1;
        int dstVspan = 1;
        if (keepSpanning) {
            dstHspan = cell.getHorizontalSpan();
            dstVspan = cell.getVerticalSpan();
        }
        if (!this.isFree(dstRow, dstCol, dstHspan, dstVspan)) {
            return null;
        }
        T obj = cell.getObject();
        this.deleteCell(cell);
        Cell<T> dst = this.writeCell(dstRow, dstCol, dstHspan, dstVspan, obj);
        Assert.a(dst != null, "Unexpected cell creation failure");
        return dst;
    }

    public void deleteCell(Cell<T> cell) {
        Assert.a(cell.isPrimary(), "Expected a primary cell");
        for (int row = cell.getRow(); row < cell.getNextRow(); ++row) {
            List<Cell<T>> cells = this.grid.get(row);
            for (int col = cell.getColumn(); col < cell.getNextColumn(); ++col) {
                cells.set(col, null);
            }
        }
    }

    public int expandRight() {
        for (int row = 0; row < this.grid.size(); ++row) {
            List<Cell<T>> cells = this.grid.get(row);
            if (cells == null) continue;
            for (Cell<T> cell : cells) {
                if (cell == null || !cell.isPrimary() || cell.getVerticalSpan() < 2) continue;
                return 0;
            }
        }
        int cntmod = 0;
        block2: for (int row = 0; row < this.grid.size(); ++row) {
            Cell<T> cell;
            int col;
            List<Cell<T>> cells = this.grid.get(row);
            if (cells == null) continue;
            this.fillupRow(cells);
            int nullcnt = 0;
            for (col = 0; col < cells.size(); ++col) {
                cell = cells.get(col);
                if (cell != null) {
                    if (nullcnt <= 0) break;
                    this.moveCell(cell, row, 0, false);
                    break;
                }
                ++nullcnt;
            }
            for (col = 0; col < cells.size(); ++col) {
                cell = cells.get(col);
                if (cell == null || !cell.isPrimary()) continue;
                int nextcol = cell.getNextColumn();
                if (nextcol >= cells.size()) continue block2;
                int ext = 0;
                for (int i = nextcol; i < cells.size() && cells.get(i) == null; ++i) {
                    ++ext;
                }
                if (ext <= 0) continue;
                int endcol = nextcol + ext;
                cell.horiMergerDisp += ext;
                for (int col2 = nextcol; col2 < endcol; ++col2) {
                    Cell cell1 = new Cell(row, col2);
                    cell1.horiMergerDisp = col - col2;
                    cells.set(col2, cell1);
                }
                ++cntmod;
            }
        }
        return cntmod;
    }

    private void fillupRow(List<Cell<T>> cells) {
        while (cells.size() <= this.lastColumnIndex) {
            cells.add(null);
        }
    }

    public List<Cell<T>> getRealCells() {
        ArrayList<Cell<T>> r = new ArrayList<Cell<T>>();
        for (int row = 0; row < this.grid.size(); ++row) {
            this.getRealCellsOnRow(row, r);
        }
        return r;
    }

    public List<Cell<T>> getRealCellsOnRow(int row) {
        ArrayList<Cell<T>> r = new ArrayList<Cell<T>>();
        this.getRealCellsOnRow(row, r);
        return r;
    }

    private void getRealCellsOnRow(int row, List<Cell<T>> sink) {
        List<Cell<T>> cells = this.grid.get(row);
        if (cells != null) {
            for (int col = 0; col < cells.size(); ++col) {
                Cell<T> cell = cells.get(col);
                if (cell == null || cell.obj == null || cell.horiMergerDisp < 0 || cell.vertMergerDisp < 0) continue;
                sink.add(cell);
            }
        }
    }

    public Cell<T> createFirstAvailableOnRow(int row, int col) {
        Cell<T> cell = this.getCellInternal(row, col);
        if (cell == null) {
            cell = this.nullifyCell(row, col);
            Assert.a(cell.getRow() == row && cell.getColumn() == col);
            return cell;
        }
        cell = cell.getPrimary(this);
        do {
            Assert.a(cell.isPrimary());
            if (cell.obj != null) continue;
            return cell;
        } while ((cell = this.getCellSmart(row, col = cell.getColumn() + cell.getHorizontalSpan(), false)) != null);
        return this.nullifyCell(row, col);
    }

    public Cell<T> getCellByObject(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        for (Cell<T> cell : this.getRealCells()) {
            if (!obj.equals(cell.obj)) continue;
            return cell;
        }
        return null;
    }

    public String formatCells() {
        return this.getRealCells().toString();
    }

    public String toString() {
        return this.format();
    }

    public String format() {
        if (this.grid.isEmpty()) {
            return "(empty)";
        }
        StringBuilder sb = new StringBuilder();
        char ch = '?';
        for (int row = 0; row <= this.lastRowIndex; ++row) {
            int col;
            List<Cell<T>> rowcells = this.grid.get(row);
            if (rowcells != null) {
                for (col = 0; col < rowcells.size(); ++col) {
                    Cell<T> cell = rowcells.get(col);
                    if (cell != null) {
                        if (cell.horiMergerDisp >= 0) {
                            ch = cell.obj != null ? (char)'x' : 'o';
                            sb.append(ch);
                            if (cell.horiMergerDisp != 0) continue;
                            sb.append(' ');
                            continue;
                        }
                        sb.append('=').append(ch);
                        if (col + 1 <= this.lastColumnIndex && col + 1 < rowcells.size() && rowcells.get(col + 1) != null && rowcells.get((int)(col + 1)).horiMergerDisp < 0) continue;
                        sb.append(" ");
                        continue;
                    }
                    sb.append("- ");
                }
            }
            while (col <= this.lastColumnIndex) {
                sb.append("- ");
                ++col;
            }
            if (row >= this.lastRowIndex) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

