/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.graph.layout;

import com.pnfsoftware.jeb.core.units.code.IInstruction;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.BasicBlock;
import com.pnfsoftware.jeb.core.units.code.asm.cfg.CFG;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.layout.Cell;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.layout.ICFGLayout;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.layout.RowCol;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.layout.Spreadsheet;
import com.pnfsoftware.jeb.util.base.Assert;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

@Deprecated
class CFGLayoutExp1<T extends IInstruction>
implements ICFGLayout<T> {
    private static final ILogger logger = GlobalLog.getLogger(CFGLayoutExp1.class);
    CFG<T> cfg;
    Spreadsheet<BasicBlock<T>> grid;
    LinkedHashMap<Long, BasicBlock<T>> blockmap;

    @Override
    public Spreadsheet<BasicBlock<T>> build(CFG<T> cfg) {
        if (this.grid != null) {
            return this.grid;
        }
        if (cfg == null || cfg.size() == 0) {
            throw new IllegalArgumentException("Illegal CFG");
        }
        this.cfg = cfg;
        this.grid = new Spreadsheet();
        this.blockmap = new LinkedHashMap();
        for (BasicBlock<T> b : cfg) {
            this.blockmap.put(b.getFirstAddress(), b);
        }
        long addr = this.blockmap.keySet().iterator().next();
        BasicBlock b = (BasicBlock)this.blockmap.remove(addr);
        Cell<BasicBlock> cell0 = this.grid.writeCell(0, 0, b);
        ArrayList<Cell<BasicBlock<T>>> parents = new ArrayList<Cell<BasicBlock<T>>>();
        parents.add(cell0);
        this.addChildren(parents);
        this.improveLayoutMultiPass();
        return this.grid;
    }

    private int improveLayoutMultiPass() {
        Iterator<Cell<BasicBlock<T>>> iterator = this.grid.getRealCells().iterator();
        while (iterator.hasNext()) {
            Cell<BasicBlock<BasicBlock<T>>> cell;
            (new Object[1])[0] = cell = iterator.next();
        }
        int ipass = 0;
        int totalChanges = 0;
        while (true) {
            ++ipass;
            int changes = 0;
            for (int row = 0; row < this.grid.getRowCount(); ++row) {
                List<Cell<BasicBlock<T>>> rowcells = this.grid.getRealCellsOnRow(row);
                int cnt = rowcells.size();
                for (int j = cnt - 1; j >= 0; --j) {
                    Cell<BasicBlock<T>> cell = rowcells.get(j);
                    RowCol srcCoord = cell.getCoordinates();
                    BasicBlock<T> bb = cell.getObject();
                    List<Cell<BasicBlock<T>>> dstCells = this.getDestinationCells(bb);
                    int[] limits = this.findLimits(dstCells, row + 1);
                    int hspan = limits[1] - limits[0];
                    if (hspan == 0 || srcCoord.getColumn() > limits[0]) continue;
                    if (srcCoord.getColumn() < limits[0]) {
                        if (!this.grid.isFree(srcCoord.getRow(), limits[0])) continue;
                        cell = this.grid.moveCell(cell, srcCoord.getRow(), limits[0], false);
                    }
                    if (hspan == cell.getHorizontalSpan() || !this.grid.isRangeFree(cell.getRow(), cell.getNextColumn(), limits[1])) continue;
                    Object[] objectArray = new Object[]{cell, hspan};
                    this.grid.mergeCells(cell.getRow(), cell.getColumn(), hspan, 1);
                    ++changes;
                }
            }
            if (changes == 0) break;
            totalChanges += changes;
            (new Object[1])[0] = ipass;
        }
        return totalChanges;
    }

    private int[] findLimits(List<Cell<BasicBlock<T>>> dstCells, int wantedRow) {
        int min = 0;
        int max = 0;
        for (Cell<BasicBlock<T>> cell : dstCells) {
            if (cell.getRow() != wantedRow) continue;
            int col = cell.getColumn();
            if (col < min) {
                min = col;
            }
            if ((col = cell.getNextColumn()) <= max) continue;
            max = col;
        }
        return new int[]{min, max};
    }

    private void addChildren(List<Cell<BasicBlock<T>>> parents) {
        while (!parents.isEmpty()) {
            ArrayList<Cell<BasicBlock<T>>> nextParents = new ArrayList<Cell<BasicBlock<T>>>();
            for (Cell<BasicBlock<T>> parent : parents) {
                int srcRow = parent.getCoordinates().getRow();
                int srcCol = parent.getCoordinates().getColumn();
                List<BasicBlock<T>> dstlist = parent.getObject().getOutputBlocks();
                for (BasicBlock<T> dst : dstlist) {
                    long addr = dst.getFirstAddress();
                    if (!this.blockmap.containsKey(addr)) continue;
                    this.blockmap.remove(addr);
                    Cell<BasicBlock<BasicBlock<T>>> cell = this.grid.createFirstAvailableOnRow(srcRow + 1, srcCol);
                    cell.setObject(dst);
                    nextParents.add(cell);
                }
            }
            parents = nextParents;
        }
    }

    private List<Cell<BasicBlock<T>>> getDestinationCells(BasicBlock<T> src) {
        ArrayList<Cell<BasicBlock<T>>> r = new ArrayList<Cell<BasicBlock<T>>>();
        for (BasicBlock<T> dst : src.getOutputBlocks()) {
            Cell<BasicBlock<T>> cell = this.grid.getCellByObject(dst);
            Assert.a(cell != null, "Cannot find cell for block: " + dst);
            r.add(cell);
        }
        return r;
    }
}

