/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.graph;

import com.pnfsoftware.jeb.rcpclient.extensions.UI;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.AbstractGraph;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphChangeListener;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphMode;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphPreview;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class GraphPlaceholder<G extends AbstractGraph>
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(GraphPlaceholder.class);
    G graph;
    GraphPreview<G> preview;
    ToolBar toolbar;
    public static final String standardHepMessage = "Standard graph controls:\n\n" + UI.MOD1 + "+Wheel ... Zoom in or out\n] ... Zoom in\n[ ... Zoom out\n" + UI.MOD1 + "+\\ (slash) ... Reset zoom\n\\ (slash) ... Center the graph\nClick on Edge ... Go to the destination node\n" + UI.MOD1 + "+Click on Edge ... Go to the source node\n";

    public GraphPlaceholder(Composite parent, int style, boolean createPreview, boolean createToolbar) {
        super(parent, style);
        FormData formData;
        FormLayout layout = new FormLayout();
        this.setLayout((Layout)layout);
        this.graph = this.createGraph(this, null);
        this.attachGraph();
        if (createPreview) {
            this.preview = new GraphPreview(this, 2048, true);
            this.preview.moveAbove((Control)this.graph);
            this.preview.setGraph(this.graph);
            formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.left = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(10, 0);
            formData.right = new FormAttachment(10, 0);
            this.preview.setLayoutData(formData);
        }
        if (createToolbar) {
            this.toolbar = new ToolBar((Composite)this, 320);
            this.toolbar.moveAbove(this.graph);
            formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.left = this.preview == null ? new FormAttachment(0, 0) : new FormAttachment(this.preview);
            formData.right = new FormAttachment(100, 0);
            this.toolbar.setLayoutData((Object)formData);
            ToolItem item = new ToolItem(this.toolbar, 0);
            item.setText(" ");
            item.setEnabled(false);
        }
    }

    protected abstract G createGraph(GraphPlaceholder<G> var1, G var2);

    private void attachGraph() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.right = new FormAttachment(100, 0);
        this.graph.setLayoutData((Object)formData);
    }

    public G getGraph() {
        return this.graph;
    }

    public GraphPreview<G> getGraphPreview() {
        return this.preview;
    }

    public ToolBar getToolbar() {
        return this.toolbar;
    }

    public boolean setFocus() {
        return this.graph.setFocus();
    }

    public G reset() {
        if (this.graph != null) {
            this.graph.dispose();
            this.graph = null;
        }
        this.graph = this.createGraph(this, this.graph);
        this.attachGraph();
        if (this.preview != null) {
            this.preview.setGraph(this.graph);
        }
        return this.graph;
    }

    private void verifyPreview() {
        if (this.preview == null) {
            throw new IllegalStateException("There is no preview widget");
        }
    }

    private void verifyToolbar() {
        if (this.toolbar == null) {
            throw new IllegalStateException("There is no toolbar widget");
        }
    }

    public Button addHelpButtonToToolbar(String msg) {
        this.verifyToolbar();
        final String msg0 = Strings.safe(msg, standardHepMessage);
        Button item = this.addPushbox("Help");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UI.info(null, "Help", msg0);
            }
        });
        return item;
    }

    public Combo addComboBox(List<String> entries, int initialSelection) {
        this.verifyToolbar();
        new ToolItem(this.toolbar, 2);
        ToolItem item = new ToolItem(this.toolbar, 2);
        Combo w = new Combo((Composite)this.toolbar, 8);
        for (String entry : entries) {
            w.add(entry);
        }
        w.select(initialSelection);
        w.pack();
        item.setWidth(w.getSize().x);
        item.setControl((Control)w);
        return w;
    }

    public Button addPushbox(String name) {
        this.verifyToolbar();
        new ToolItem(this.toolbar, 2);
        ToolItem item = new ToolItem(this.toolbar, 2);
        Button w = new Button((Composite)this.toolbar, 8);
        w.setText(name);
        w.pack();
        item.setWidth(w.getSize().x);
        item.setControl((Control)w);
        return w;
    }

    public Button addCheckbox(String name, boolean initialState) {
        this.verifyToolbar();
        new ToolItem(this.toolbar, 2);
        ToolItem item = new ToolItem(this.toolbar, 2);
        Button w = new Button((Composite)this.toolbar, 32);
        w.setText(name);
        w.setSelection(initialState);
        w.pack();
        item.setWidth(w.getSize().x);
        item.setControl((Control)w);
        return w;
    }

    public void addModesBoxToToolbar() {
        ArrayList<String> modenames = new ArrayList<String>();
        for (GraphMode mode : ((AbstractGraph)this.graph).getSupportedModes()) {
            modenames.add(mode.getName());
        }
        final Combo wModes = this.addComboBox(modenames, 0);
        wModes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GraphPlaceholder.this.graph == null) {
                    return;
                }
                int index = ((Combo)e.widget).getSelectionIndex();
                if (index < 0 || index >= ((AbstractGraph)GraphPlaceholder.this.graph).getSupportedModes().size()) {
                    return;
                }
                ((AbstractGraph)GraphPlaceholder.this.graph).setMode(((AbstractGraph)GraphPlaceholder.this.graph).getSupportedModes().get(index));
            }
        });
        ((AbstractGraph)this.graph).addGraphChangeListener(new GraphChangeListener(){

            @Override
            public void onModeChange(AbstractGraph g, GraphMode mode) {
                (new Object[1])[0] = mode;
                int index = g.getSupportedModes().indexOf(mode);
                wModes.select(index);
            }
        });
    }
}

