/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.graph;

import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.Anchor;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.Graph;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphEdge;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphEdgeManager;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphEdgeSquare;
import com.pnfsoftware.jeb.rcpclient.extensions.graph.GraphNode;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class GraphEdgeSquareManager
extends GraphEdgeManager {
    private static final ILogger logger = GlobalLog.getLogger(GraphEdgeSquareManager.class);
    private static final int SPACING_MIN = 20;
    private static final int MARGIN_MIN = 10;
    private static final int EDGE_SEP = 8;
    private boolean minimizeBlockCrossover = true;
    private boolean preferStraightRouting = true;
    private Map<Integer, NodeEx> renderedNodesmap = new HashMap<Integer, NodeEx>();
    private List<EdgeEx> renderedEdges = new ArrayList<EdgeEx>();
    private List<Rectangle> nbounds_sorted_x1;
    private List<Rectangle> nbounds_revsorted_x0;
    private static final Comparator<EdgeEx> cmpEdgesIn = new Comparator<EdgeEx>(){

        @Override
        public int compare(EdgeEx a, EdgeEx b) {
            if (a.incat != b.incat) {
                return Integer.compare(a.incat, b.incat);
            }
            if (a.incat == 1 || a.incat == 2) {
                return Integer.compare(a.xIn, b.xIn);
            }
            return -Integer.compare(a.xIn, b.xIn);
        }
    };
    private static final Comparator<EdgeEx> cmpEdgesOut = new Comparator<EdgeEx>(){

        @Override
        public int compare(EdgeEx a, EdgeEx b) {
            if (a.outcat != b.outcat) {
                return Integer.compare(a.outcat, b.outcat);
            }
            if (a.outcat == 1 || a.outcat == 2) {
                return Integer.compare(a.xOut, b.xOut);
            }
            return -Integer.compare(a.xOut, b.xOut);
        }
    };

    public GraphEdgeSquareManager(Graph graph) {
        super(graph);
    }

    @Override
    public GraphEdgeSquare create(GraphNode src, GraphNode dst) {
        GraphEdgeSquare edge = new GraphEdgeSquare(this.graph, src, dst);
        return edge;
    }

    @Override
    public void draw(GC gc, int redrawCause, Object redrawObject) {
        Object[] objectArray = new Object[]{gc.getClipping(), redrawCause, redrawObject};
        long ts0 = System.currentTimeMillis();
        this.renderedNodesmap.clear();
        this.renderedEdges.clear();
        if (this.minimizeBlockCrossover) {
            this.nbounds_sorted_x1 = new ArrayList<Rectangle>(this.graph.getNodeCount());
            this.nbounds_revsorted_x0 = new ArrayList<Rectangle>(this.graph.getNodeCount());
            for (GraphNode node : this.graph.getNodes()) {
                this.nbounds_sorted_x1.add(node.getBounds());
                this.nbounds_revsorted_x0.add(node.getBounds());
            }
            this.nbounds_sorted_x1.sort((r0, r1) -> Integer.compare(r0.x + r0.width, r1.x + r1.width));
            this.nbounds_revsorted_x0.sort((r0, r1) -> -Integer.compare(r0.x, r1.x));
        }
        for (GraphEdge edge : this.graph.getEdges()) {
            EdgeEx edge2 = this.createEdgeForRendering((GraphEdgeSquare)edge, gc);
            if (edge2 == null) continue;
            this.renderedEdges.add(edge2);
            GraphNode n = edge.src;
            NodeEx info = this.renderedNodesmap.get(n.id);
            if (info == null) {
                info = new NodeEx(n);
                this.renderedNodesmap.put(n.id, info);
            }
            info.outputs.add(edge2);
            n = edge.dst;
            info = this.renderedNodesmap.get(n.id);
            if (info == null) {
                info = new NodeEx(n);
                this.renderedNodesmap.put(n.id, info);
            }
            info.inputs.add(edge2);
        }
        this.determineEdgeAnchors();
        ArrayList<NodeEx> coll = new ArrayList<NodeEx>(this.renderedNodesmap.values());
        for (int i = coll.size() - 1; i >= 0; --i) {
            NodeEx node2 = (NodeEx)coll.get(i);
            for (int idx = 0; idx < node2.inputs.size(); ++idx) {
                this.drawEdge(node2.inputs, idx, gc);
            }
        }
        long exectime = System.currentTimeMillis() - ts0;
        Object[] objectArray2 = new Object[]{exectime, this.renderedEdges.size(), this.graph.getEdges().size()};
    }

    private EdgeEx createEdgeForRendering(GraphEdgeSquare edge, GC gc) {
        if (edge.srcAnchor != Anchor.BOTTOM || edge.dstAnchor != Anchor.TOP) {
            throw new IllegalStateException();
        }
        Rectangle cr = gc.getClipping();
        int cr_x0 = cr.x;
        int cr_y0 = cr.y;
        int cr_x1 = cr.x + cr.width;
        int cr_y1 = cr.y + cr.height;
        Rectangle a = edge.src.getBounds();
        Rectangle b = edge.dst.getBounds();
        int a_x0 = a.x;
        int a_y0 = a.y;
        int b_x0 = b.x;
        int b_y0 = b.y;
        int a_x1 = a.x + a.width;
        int a_y1 = a.y + a.height;
        int b_x1 = b.x + b.width;
        int b_y1 = b.y + b.height;
        int a_xcenter = a.x + a.width / 2;
        int b_xcenter = b.x + b.width / 2;
        if (a_y1 < cr_y0 && b_y1 < cr_y0) {
            return null;
        }
        if (a_y0 >= cr_y1 && b_y0 >= cr_y1) {
            return null;
        }
        if (a_x1 < cr_x0 && b_x1 < cr_x0) {
            return null;
        }
        if (a_x0 >= cr_x1 && b_x0 >= cr_x1) {
            return null;
        }
        boolean xOverlap = b_x0 <= a.x && b_x1 > a.x || b_x0 <= a_x1 && b_x1 > a_x1 || b_x0 >= a.x && b_x1 <= a_x1;
        int x0 = UIUtil.getCenterX((Control)edge.src);
        int x1 = UIUtil.getCenterX((Control)edge.dst);
        if (b_y0 - a_y1 >= 20 || b_y0 - a_y1 >= 0 && xOverlap) {
            int yi = b_y0 - 10;
            int[] r = this.avoidVerticalLineOverlapWithNodes(x0, a_y1, yi);
            if (r == null) {
                int subcl = x0 > x1 ? 1 : 2;
                return new EdgeEx(edge, 1, subcl, x0, x1);
            }
            int xE = r[1];
            int subcl = xE > x1 ? 3 : 4;
            return new EdgeEx(edge, 1, subcl, xE);
        }
        if (b_x0 > a_x1 + 20) {
            int xi = b_x0 - 10;
            int yi = a_y1 + 10;
            int yj = b_y0 - 10;
            xi = this.adjustVerticalLine(xi, yj, yi, true);
            return new EdgeEx(edge, 2, 1, xi);
        }
        if (b_x1 + 20 < a_x0) {
            int xi = b_x1 + 10;
            int yi = a_y1 + 10;
            int yj = b_y0 - 10;
            xi = this.adjustVerticalLine(xi, yj, yi, false);
            return new EdgeEx(edge, 2, 2, xi);
        }
        if (b_xcenter >= a_xcenter) {
            int xi = Math.max(b_x1 + 10, a_x1 + 10);
            int yi = Math.max(a_y1 + 10, b_y1 + 10);
            int yj = b_y0 - 10;
            xi = this.adjustVerticalLine(xi, yj, yi, true);
            return new EdgeEx(edge, 2, 3, xi);
        }
        int xi = Math.min(b_x0 - 10, a_x0 - 10);
        int yi = Math.max(a_y1 + 10, b_y1 + 10);
        int yj = b_y0 - 10;
        xi = this.adjustVerticalLine(xi, yj, yi, false);
        return new EdgeEx(edge, 2, 4, xi);
    }

    private void determineEdgeAnchors() {
        int xdeltasep = this.graph.virtualOrigin.x % 8;
        for (NodeEx node2 : this.renderedNodesmap.values()) {
            int outcnt;
            node2.inputs.sort(cmpEdgesIn);
            node2.outputs.sort(cmpEdgesOut);
            Rectangle r = node2.node.getBounds();
            int incnt = node2.inputs.size();
            if (incnt >= 1) {
                int xstart = r.x + (r.width - (incnt - 1) * 8) / 2;
                int shift = (xstart - xdeltasep) % 8;
                int i = 0;
                int x = xstart += 8 - shift;
                while (i < incnt) {
                    node2.inputs.get((int)i).xInCalculated = x;
                    ++i;
                    x += 8;
                }
            }
            if ((outcnt = node2.outputs.size()) < 1) continue;
            int xstart = r.x + (r.width - (outcnt - 1) * 8) / 2;
            int shift = (xstart - xdeltasep) % 8;
            int i = 0;
            int x = xstart += 8 - shift;
            while (i < outcnt) {
                node2.outputs.get((int)i).xOutCalculated = x;
                ++i;
                x += 8;
            }
        }
    }

    private void drawEdge(List<EdgeEx> rendered_edges, int i, GC gc) {
        EdgeEx edge2 = rendered_edges.get(i);
        GraphEdgeSquare edge = edge2.edge;
        Rectangle a = edge.src.getBounds();
        Rectangle b = edge.dst.getBounds();
        int a_x0 = a.x;
        int cfr_ignored_0 = a.y;
        int b_x0 = b.x;
        int b_y0 = b.y;
        int a_x1 = a.x + a.width;
        int a_y1 = a.y + a.height;
        int b_x1 = b.x + b.width;
        int b_y1 = b.y + b.height;
        int a_xcenter = a.x + a.width / 2;
        int b_xcenter = b.x + b.width / 2;
        boolean xOverlap = b_x0 <= a.x && b_x1 > a.x || b_x0 <= a_x1 && b_x1 > a_x1 || b_x0 >= a.x && b_x1 <= a_x1;
        int x0 = edge2.xOutCalculated;
        int x1 = edge2.xInCalculated;
        int originalX0 = x0;
        int originalX1 = x1;
        if (b_y0 - a_y1 >= 20 || b_y0 - a_y1 >= 0 && xOverlap) {
            int _shift = 0;
            if (edge2.incat == 1) {
                _shift += i * 10;
            } else if (edge2.incat == 2) {
                _shift += (rendered_edges.size() - i - 1) * 10;
            }
            int yi = this.graph.requestHorizontalLine(x0, x1, b_y0 - 10 - _shift, -8);
            x0 = this.graph.requestVerticalLine(a_y1, yi, x0, 8);
            x1 = this.graph.requestVerticalLine(yi, b_y0, x1, 8);
            int[] r = this.avoidVerticalLineOverlapWithNodes(x0, a_y1, yi);
            if (r != null) {
                int yE = r[0];
                int xE = r[1];
                int yE1 = yi;
                this.graph.releaseHorizontalLine(originalX0, originalX1, yi);
                this.graph.releaseVerticalLine(yi, b_y0, x1);
                this.graph.releaseVerticalLine(a_y1, yi, x0);
                x0 = this.graph.requestVerticalLine(a_y1, yE, originalX0, 8);
                x1 = this.graph.requestVerticalLine(yE1, b_y0, originalX1, 8);
                yE1 = this.graph.requestHorizontalLine(xE, x1, b_y0 - 10 - _shift, -8);
                yE = this.graph.requestHorizontalLine(x0, xE, yE, -8);
                xE = this.graph.requestVerticalLine(yE, yE1, xE, 8);
                edge.drawLine(gc, x0, a_y1, x0, yE);
                edge.drawLine(gc, x0, yE, xE, yE);
                edge.drawLine(gc, xE, yE, xE, yE1);
                edge.drawLine(gc, xE, yE1, x1, yE1);
                edge.drawLine(gc, x1, yE1, x1, b_y0);
            } else {
                if (this.preferStraightRouting && x0 != x1 && Math.abs(x0 - x1) < 20 && x0 > b_x0 && x0 < b_x1) {
                    this.graph.releaseHorizontalLine(originalX0, originalX1, yi);
                    this.graph.releaseVerticalLine(a_y1, yi, x0);
                    this.graph.releaseVerticalLine(yi, b_y0, x1);
                    x1 = x0 = this.graph.requestVerticalLine(a_y1, b_y0, originalX0, 8);
                }
                if (x1 != x0) {
                    edge.drawLine(gc, x0, a_y1, x0, yi);
                    edge.drawLine(gc, x0, yi, x1, yi);
                    edge.drawLine(gc, x1, yi, x1, b_y0);
                } else {
                    edge.drawLine(gc, x0, a_y1, x0, b_y0);
                }
            }
        } else {
            int adjxi;
            int adjx1;
            int adjx0;
            int yj;
            int yi;
            int xi;
            if (b_x0 > a_x1 + 20) {
                xi = b_x0 - 10;
                yi = a_y1 + 10;
                yj = b_y0 - 10;
                xi = this.adjustVerticalLine(xi, yj, yi, true);
                adjx0 = 1;
                adjx1 = -1;
                adjxi = -1;
            } else if (b_x1 + 20 < a_x0) {
                xi = b_x1 + 10;
                yi = a_y1 + 10;
                yj = b_y0 - 10;
                xi = this.adjustVerticalLine(xi, yj, yi, false);
                adjx0 = -1;
                adjx1 = 1;
                adjxi = 1;
            } else if (b_xcenter >= a_xcenter) {
                xi = Math.max(b_x1 + 10, a_x1 + 10);
                yi = Math.max(a_y1 + 10, b_y1 + 10);
                yj = b_y0 - 10;
                xi = this.adjustVerticalLine(xi, yj, yi, true);
                adjx0 = 1;
                adjx1 = 1;
                adjxi = 1;
            } else {
                xi = Math.min(b_x0 - 10, a_x0 - 10);
                yi = Math.max(a_y1 + 10, b_y1 + 10);
                yj = b_y0 - 10;
                xi = this.adjustVerticalLine(xi, yj, yi, false);
                adjx0 = -1;
                adjx1 = -1;
                adjxi = -1;
            }
            int _shift = 0;
            if (edge2.incat == 0) {
                _shift += i * 10;
            } else if (edge2.incat == 3) {
                _shift += (rendered_edges.size() - i - 1) * 10;
            }
            x0 = this.graph.requestVerticalLine(a_y1, yi, x0, adjx0 * 8);
            x1 = this.graph.requestVerticalLine(yj, b_y0, x1, adjx1 * 8);
            yi = this.graph.requestHorizontalLine(x0, xi, yi, 8);
            yj = this.graph.requestHorizontalLine(xi, x1, yj - _shift, -8);
            xi = this.graph.requestVerticalLine(yi, yj, xi + adjxi * _shift, adjxi * 8);
            edge.drawLine(gc, x0, a_y1, x0, yi);
            edge.drawLine(gc, x0, yi, xi, yi);
            edge.drawLine(gc, xi, yi, xi, yj);
            edge.drawLine(gc, xi, yj, x1, yj);
            edge.drawLine(gc, x1, yj, x1, b_y0);
        }
        edge.drawArrow(gc, x1, b_y0 - 1, x1, b_y0);
    }

    private int[] avoidVerticalLineOverlapWithNodes(int x, int y0, int y1) {
        if (!this.minimizeBlockCrossover) {
            return null;
        }
        int xU = x;
        int yU = Integer.MAX_VALUE;
        for (Rectangle r : this.nbounds_sorted_x1) {
            if (r.x - 10 >= xU || r.x + r.width <= xU || y0 >= r.y - 10 || y1 <= r.y + r.height) continue;
            xU = r.x + r.width;
            yU = Math.min(r.y, yU);
        }
        if (yU == Integer.MAX_VALUE) {
            return null;
        }
        return new int[]{yU - 10, xU + 10};
    }

    private int adjustVerticalLine(int x, int y0, int y1, boolean moveRight) {
        if (!this.minimizeBlockCrossover) {
            return x;
        }
        int xU = x;
        if (moveRight) {
            for (Rectangle r : this.nbounds_sorted_x1) {
                if (r.x - 10 >= xU || r.x + r.width <= xU || y0 >= r.y || y1 <= r.y + r.height) continue;
                xU = r.x + r.width;
            }
            if (xU == x) {
                return xU;
            }
            return xU + 10;
        }
        for (Rectangle r : this.nbounds_revsorted_x0) {
            if (r.x >= xU || r.x + r.width + 10 <= xU || y0 >= r.y || y1 <= r.y + r.height) continue;
            xU = r.x;
        }
        if (xU == x) {
            return xU;
        }
        return xU - 10;
    }

    static class EdgeEx {
        GraphEdgeSquare edge;
        int cl;
        int subcl;
        int xIn;
        int xOut;
        private int incat;
        private int outcat;
        private int xInCalculated;
        private int xOutCalculated;

        EdgeEx(GraphEdgeSquare edge, int cl, int subcl, int x) {
            this(edge, cl, subcl, x, x);
        }

        EdgeEx(GraphEdgeSquare edge, int cl, int subcl, int xIn, int xOut) {
            this.edge = edge;
            this.cl = cl;
            this.subcl = subcl;
            this.xIn = xIn;
            this.xOut = xOut;
            if (cl == 2) {
                this.incat = subcl == 1 || subcl == 4 ? 0 : 3;
            } else {
                int n = this.incat = subcl == 2 || subcl == 4 ? 1 : 2;
            }
            this.outcat = cl == 2 ? (subcl == 2 || subcl == 4 ? 0 : 3) : (subcl == 1 || subcl == 4 ? 1 : 2);
        }

        public String toString() {
            return Strings.ff("%s -> %s", this.edge.src.name, this.edge.dst.name);
        }
    }

    static class NodeEx {
        GraphNode node;
        List<EdgeEx> inputs = new ArrayList<EdgeEx>();
        List<EdgeEx> outputs = new ArrayList<EdgeEx>();

        NodeEx(GraphNode node) {
            this.node = node;
        }

        public String toString() {
            return Strings.ff("%s", this.node.name);
        }
    }
}

