/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.filter;

import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredLabelProvider;
import com.pnfsoftware.jeb.rcpclient.util.regex.IPattern;
import com.pnfsoftware.jeb.util.format.Strings;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;

public abstract class AbstractFilteredFilter
extends ViewerFilter {
    protected String simplePattern;
    protected IPattern regexPattern;
    private StructuredViewer viewer;
    protected boolean patternChanged = true;

    public AbstractFilteredFilter(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public void setFilterText(String text, boolean refresh) {
        this.simplePattern = text;
        this.regexPattern = null;
        this.patternChanged = true;
        if (refresh) {
            this.safeRefresh();
        }
    }

    protected void onRefreshDone() {
    }

    public void setFilterPattern(IPattern pattern, boolean refresh) {
        this.simplePattern = null;
        this.regexPattern = pattern;
        this.patternChanged = true;
        if (refresh) {
            this.safeRefresh();
        }
    }

    private void safeRefresh() {
        try {
            this.viewer.refresh();
        }
        catch (Exception e) {
            String msg = Strings.ff("error on filter: text='%s' regex='%s'", this.simplePattern, this.regexPattern);
            RuntimeException ex = new RuntimeException(msg, e);
            RcpClientContext.getInstance().getErrorHandler().processThrowableSilent(ex);
        }
    }

    public boolean isFiltered() {
        return this.simplePattern != null || this.regexPattern != null;
    }

    public boolean isElementMatch(Object element) {
        if (!this.isFiltered()) {
            return true;
        }
        Object[] list = this.getProvider().getRowElements(element);
        if (list == null) {
            return true;
        }
        return this.isRowMatch(list);
    }

    public boolean isRowMatch(Object[] list) {
        if (this.regexPattern != null) {
            return this.regexPattern.match(list);
        }
        if (this.simplePattern != null && this.simplePattern.length() > 0) {
            for (Object o : list) {
                if (o == null || !o.toString().contains(this.simplePattern)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public abstract IFilteredLabelProvider getProvider();

    public StructuredViewer getViewer() {
        return this.viewer;
    }

    public void inputChanged() {
    }
}

