/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.google.common.net.MediaType;
import com.pnfsoftware.jeb.client.api.IUnitTextFragment;
import com.pnfsoftware.jeb.core.input.IInput;
import com.pnfsoftware.jeb.core.output.IGenericDocument;
import com.pnfsoftware.jeb.core.output.IUnitDocumentPresentation;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.table.ITableDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.impl.HexDumpDocument;
import com.pnfsoftware.jeb.core.output.tree.INode;
import com.pnfsoftware.jeb.core.output.tree.ITreeDocument;
import com.pnfsoftware.jeb.core.units.IBinaryUnit;
import com.pnfsoftware.jeb.core.units.IDuplicatedUnit;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnknownBinaryUnit;
import com.pnfsoftware.jeb.core.units.codeobject.ICodeObjectUnit;
import com.pnfsoftware.jeb.core.units.impl.ContainerUnit;
import com.pnfsoftware.jeb.rcpclient.IRcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.WebImageViewer;
import com.pnfsoftware.jeb.rcpclient.handlers.HandlerUtil;
import com.pnfsoftware.jeb.rcpclient.parts.UnitPartManager;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractDataFrameFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractTextFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.AbstractUnitFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.BinaryDataFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.IDocumentBasedFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.SwitchableTextFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.TableFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.TextFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.TreeFragment;
import com.pnfsoftware.jeb.rcpclient.parts.units.codeobject.CodeLoaderInfoFragment;
import com.pnfsoftware.jeb.rcpclient.util.Extensions;
import com.pnfsoftware.jeb.rcpclient.util.regex.IPattern;
import com.pnfsoftware.jeb.rcpclient.util.regex.SimplePattern;
import com.pnfsoftware.jeb.util.encoding.MimeType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class WindowExplorerView
extends ScrolledComposite {
    private static final int LIST_MAX_LINES = 15;
    private static final int DEFAULT_TEXT_HEIGHT = 15;
    private static final boolean DEBUG_SHOW_BACKGROUNDS = false;
    private List<Listener> unitModifiedListeners = new ArrayList<Listener>();
    private IUnit unit;
    private IRcpClientContext context;
    private Composite c;
    private Composite[] cs;
    private static final int MAX_ITEM_PER_COMPOSITE = 1000;
    private boolean zoom = false;
    private int maxLabelHeight = 15;
    private WindowLayout windowLayout = WindowLayout.SMALL_GRID;
    private PreviewType previewType = PreviewType.Image;
    private IPattern pattern = new SimplePattern("");
    private boolean fullRefresh = false;

    public WindowExplorerView(Composite parent, IUnit unit, IRcpClientContext context) {
        super(parent, 512);
        this.c = new Composite((Composite)this, 0);
        this.setContent((Control)this.c);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.addListener(11, event -> this.autoSize());
        this.context = context;
        this.unit = unit;
        this.updateContent();
    }

    private void autoSize() {
        int width = this.getClientArea().width;
        this.setMinSize(this.c.computeSize(width, -1));
    }

    public void setUnit(IUnit unit, boolean notify) {
        this.unit = unit;
        for (Listener l : this.unitModifiedListeners) {
            Event ev = new Event();
            ev.widget = this;
            ev.data = unit;
            l.handleEvent(ev);
        }
    }

    public void updateContent() {
        int i;
        this.setOrigin(0, 0);
        this.windowLayout.setLayout(this.c, true);
        Control[] currentChildren = this.c.getChildren();
        List<? extends IUnit> children = this.unit.getChildren();
        if (this.fullRefresh || currentChildren.length == 0 || children.size() != currentChildren.length || children.size() >= 1000) {
            this.fullRefresh();
            this.fullRefresh = false;
            return;
        }
        this.maxLabelHeight = 0;
        for (i = 0; i < children.size(); ++i) {
            if (!(currentChildren[i] instanceof FileWidget)) continue;
            this.maxLabelHeight = Math.max(this.maxLabelHeight, ((FileWidget)currentChildren[i]).getLabelHeight(true));
        }
        for (i = 0; i < children.size(); ++i) {
            IUnit child = children.get(i);
            if (currentChildren[i] instanceof Group) {
                Group group = (Group)currentChildren[i];
                IUnitWidget unitWidget = (IUnitWidget)group.getData("FolderWidget");
                if (child == unitWidget.getUnit()) {
                    unitWidget.updateLayout();
                    List<? extends IUnit> grandChildren = child.getChildren();
                    Control[] currentGrandChildren = group.getChildren();
                    if (grandChildren.size() < 4 && currentGrandChildren.length != grandChildren.size() || grandChildren.size() >= 4 && currentGrandChildren.length != 4) {
                        this.fullRefresh();
                        return;
                    }
                    for (int j = 0; j < currentGrandChildren.length; ++j) {
                        IUnit grandChild = grandChildren.get(j);
                        if (currentGrandChildren[j] instanceof FileWidget) {
                            if (grandChild != ((FileWidget)currentGrandChildren[j]).getUnit()) {
                                this.fullRefresh();
                                return;
                            }
                        } else {
                            this.fullRefresh();
                            return;
                        }
                        ((FileWidget)currentGrandChildren[j]).updateLayout();
                    }
                    continue;
                }
                this.fullRefresh();
                return;
            }
            if (currentChildren[i] instanceof FileWidget) {
                if (child == ((FileWidget)currentChildren[i]).getUnit()) {
                    ((FileWidget)currentChildren[i]).updateLayout();
                    continue;
                }
                this.fullRefresh();
                return;
            }
            this.fullRefresh();
            return;
        }
        this.autoSize();
    }

    private void initializeSubComposites() {
        int childrenSize = this.unit.getChildren().size();
        if (childrenSize >= 1000) {
            this.c.setLayout((Layout)new GridLayout(1, true));
            this.cs = new Composite[(int)Math.ceil((double)childrenSize / 1000.0)];
            for (int i = 0; i < this.cs.length; ++i) {
                this.cs[i] = new Composite(this.c, 0);
                this.windowLayout.setLayout(this.cs[i], true);
                this.cs[i].setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
            }
        } else {
            this.windowLayout.setLayout(this.c, true);
        }
    }

    private Composite getParentComposite(int i) {
        if (this.cs == null) {
            return this.c;
        }
        return this.cs[(int)((double)i / 1000.0)];
    }

    private void updateAllLayouts() {
        if (this.cs == null) {
            for (Control child : this.c.getChildren()) {
                if (!(child instanceof IUnitWidget)) continue;
                ((IUnitWidget)child).updateLayout();
            }
        } else {
            for (Composite csx : this.cs) {
                for (Control child : csx.getChildren()) {
                    if (!(child instanceof IUnitWidget)) continue;
                    ((IUnitWidget)child).updateLayout();
                }
            }
        }
    }

    public void fullRefresh() {
        for (Control child : this.c.getChildren()) {
            if (child.isDisposed()) continue;
            child.dispose();
        }
        this.cs = null;
        this.setOrigin(0, 0);
        this.maxLabelHeight = 0;
        this.initializeSubComposites();
        for (int i = 0; i < this.unit.getChildren().size(); ++i) {
            this.checkIsProcessed(this.unit.getChildren().get(i));
            IUnitWidget item = this.addFile(this.getParentComposite(i), this.unit.getChildren().get(i), this.context, 0, null);
            if (item == null) continue;
            this.maxLabelHeight = Math.max(item.getLabelHeight(false), this.maxLabelHeight);
        }
        this.updateAllLayouts();
        this.autoSize();
        this.c.requestLayout();
    }

    public boolean isZoom() {
        return this.zoom;
    }

    public void setZoom(boolean zoom) {
        this.zoom = zoom;
    }

    public WindowLayout getWindowLayout() {
        return this.windowLayout;
    }

    public void setWindowLayout(WindowLayout windowLayout) {
        this.windowLayout = windowLayout;
    }

    public PreviewType getPreviewType() {
        return this.previewType;
    }

    public void setPreviewType(PreviewType previewType) {
        if (this.previewType != previewType) {
            this.fullRefresh = true;
        }
        this.previewType = previewType;
    }

    public boolean setFilterText(String filterString) {
        try {
            this.pattern.setPattern(filterString);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
        this.fullRefresh = true;
        return true;
    }

    private IUnitWidget addFile(Composite parent, IUnit child, IRcpClientContext context, int level, MouseListener mouseListener) {
        if (level == 0 && this.pattern != null && !this.pattern.match(child.getName())) {
            return null;
        }
        if (level == 0 && (child instanceof ContainerUnit || !child.getChildren().isEmpty())) {
            mouseListener = new DblClickGoTo(child);
            FolderWidget group = new FolderWidget(parent, 0, child, mouseListener);
            if (level == 0) {
                for (int i = 0; i < child.getChildren().size() && i < 4; ++i) {
                    this.checkIsProcessed(child.getChildren().get(i));
                    this.addFile((Composite)group.group, child.getChildren().get(i), context, child.getChildren().size(), mouseListener);
                }
            }
            return group;
        }
        FileWidget childComposite = new FileWidget(parent, 0, child, level, mouseListener);
        if (level != 0) {
            childComposite.updateLayout();
        }
        return childComposite;
    }

    private boolean checkIsProcessed(IUnit unit) {
        if (!unit.isProcessed() && this.shouldProcess(unit)) {
            unit.process();
        }
        return unit.isProcessed();
    }

    private boolean shouldProcess(IUnit unit) {
        switch (this.previewType) {
            case All: {
                return true;
            }
            case Image: {
                if (unit instanceof IBinaryUnit) {
                    MediaType mt = UnitPartManager.getMediaTypeForUnit(unit);
                    if (mt.is(MediaType.ANY_IMAGE_TYPE)) {
                        return true;
                    }
                    String mimeType = MimeType.determineFromContent(((IBinaryUnit)unit).getInput());
                    if (mimeType == null) {
                        return false;
                    }
                    String[] parts = mimeType.split("/");
                    if (parts.length != 2) {
                        return false;
                    }
                    try {
                        return "image".equals(parts[0]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public void addUnitModifiedListener(Listener listener) {
        this.unitModifiedListeners.add(listener);
    }

    public void removeUnitModifiedListener(Listener listener) {
        this.unitModifiedListeners.remove(listener);
    }

    public static enum WindowLayout {
        LIST(150, false),
        SMALL_GRID(80),
        LARGE_GRID(150);

        private static final int MARGIN = 3;
        private static final int SPACING_0 = 20;
        private static final int SPACING_x = 3;
        private final int height;
        private final boolean square;

        private WindowLayout(int height) {
            this.height = height;
            this.square = true;
        }

        private WindowLayout(int height, boolean square) {
            this.height = height;
            this.square = square;
        }

        private void setLayout(Composite c, boolean main) {
            if (this.square) {
                RowLayout r = UIUtil.createRowLayout(false, true);
                r.pack = false;
                r.marginLeft = 3;
                r.marginRight = 3;
                r.marginBottom = 3;
                r.marginTop = 3;
                r.spacing = main ? 20 : 3;
                c.setLayout((Layout)r);
            } else {
                GridLayout g = UIUtil.setStandardLayout(c, 4, 0, 3);
                g.verticalSpacing = main ? 20 : 3;
            }
        }

        private int getAvailableSize(int level) {
            int minimargins = this.square ? 4 : 10;
            switch (level) {
                case 0: {
                    return this.height;
                }
            }
            return this.height / 2 - minimargins;
        }

        private void setLayoutData(Control c, int level, int maxLabelHeight, boolean useAllSpace) {
            if (this.square) {
                int size = this.getAvailableSize(level);
                RowData rowData = new RowData(size, size + maxLabelHeight);
                c.setLayoutData((Object)rowData);
            } else {
                GridData layoutData = UIUtil.createGridDataFillHorizontally();
                if (useAllSpace) {
                    layoutData.horizontalSpan = 4;
                }
                c.setLayoutData((Object)layoutData);
            }
        }

        private int getMaxGroupName() {
            if (!this.square) {
                return -1;
            }
            return this.height * 18 / 150;
        }
    }

    public static enum PreviewType {
        All,
        Image;

    }

    private class FileWidget
    extends Composite
    implements IUnitWidget {
        private final IUnit unit;
        private Label l;
        private Font minifont;
        private boolean useAllSpace;
        private int level;
        private int preferredWidth;
        private int labelHeight;
        private int previewHeight;
        private Runnable preferredHeightCallback;

        public FileWidget(Composite parent, int style, final IUnit unit, int level, MouseListener mouseListener) {
            Font oldFont;
            FontData[] fontdata;
            super(parent, style);
            this.minifont = null;
            this.useAllSpace = false;
            this.unit = unit;
            this.level = level;
            GridLayout layout = UIUtil.setStandardLayout(this, 1, 0, 0);
            layout.verticalSpacing = 0;
            if (mouseListener == null) {
                mouseListener = new MouseAdapter(){

                    public void mouseDoubleClick(MouseEvent e) {
                        IUnit u = unit;
                        if (HandlerUtil.processUnit(FileWidget.this.getShell(), WindowExplorerView.this.context, u, false)) {
                            if (u.isDisposed() && u instanceof UnknownBinaryUnit && (u = ((UnknownBinaryUnit)u).getKnownUnit()) == null) {
                                return;
                            }
                            WindowExplorerView.this.context.getPartManager().create(u, true);
                        }
                    }
                };
            }
            this.updatePreferredHeight();
            this.displayPreview(style, unit, (MouseListener)mouseListener);
            this.l = new Label((Composite)this, level == 0 ? 0x1000040 : 0);
            this.l.setText(unit.getName());
            this.l.setToolTipText(unit.getName());
            if (mouseListener != null) {
                this.addMouseListener((MouseListener)mouseListener);
                this.l.addMouseListener(mouseListener);
            }
            if (level != 0 && (fontdata = (oldFont = this.l.getFont()).getFontData()) != null) {
                for (FontData f : fontdata) {
                    f.setHeight((int)((double)f.getHeight() * 0.8));
                }
                this.minifont = new Font((Device)this.getDisplay(), fontdata);
                this.l.setFont(this.minifont);
                this.addDisposeListener(e -> this.minifont.dispose());
            }
            GridData gd = UIUtil.createGridDataFillHorizontally();
            this.l.setLayoutData((Object)gd);
            this.updateLabel();
        }

        private void updateLabel() {
            Point size = this.l.computeSize(WindowExplorerView.this.windowLayout.getAvailableSize(this.level), -1);
            this.labelHeight = size.y;
        }

        private Control displayPreview(int style, IUnit unit, MouseListener mouseListener) {
            if (unit instanceof IDuplicatedUnit) {
                unit = ((IDuplicatedUnit)unit).getOriginal();
            }
            if (!WindowExplorerView.this.checkIsProcessed(unit)) {
                return this.displayIcon(unit, style, mouseListener);
            }
            if (WindowExplorerView.this.previewType == PreviewType.All) {
                Control rep = this.getDefaultRepresentation(unit, WindowExplorerView.this.context);
                if (rep instanceof IDocumentBasedFragment && rep instanceof IUnitTextFragment) {
                    this.setTextLayoutData(rep, (ITextDocument)((IDocumentBasedFragment)rep).getDocument(), this.level);
                    return rep;
                }
                if (rep instanceof TableFragment) {
                    this.setTableLayoutData((TableFragment)rep, (ITableDocument)((IDocumentBasedFragment)rep).getDocument(), this.level);
                    return rep;
                }
                if (rep instanceof TreeFragment) {
                    this.setTreeLayoutData((TreeFragment)rep, (ITreeDocument)((IDocumentBasedFragment)rep).getDocument(), this.level);
                    return rep;
                }
            }
            if (WindowExplorerView.this.previewType == PreviewType.All && unit instanceof ICodeObjectUnit) {
                CodeLoaderInfoFragment infoview = new CodeLoaderInfoFragment(this, 0, WindowExplorerView.this.context, (ICodeObjectUnit)unit);
                this.setDataFrameLayoutData(infoview, this.level);
                return infoview;
            }
            if (unit instanceof IBinaryUnit) {
                MediaType mt = UnitPartManager.getMediaTypeForUnit(unit);
                if (((IBinaryUnit)unit).getMimeType().equals("image/webp")) {
                    try {
                        if (UIUtil.canUseBrowser(this)) {
                            WebImageViewer.WebpDocument _doc = new WebImageViewer.WebpDocument(WindowExplorerView.this.context, (IBinaryUnit)unit);
                            new WebImageViewer(this, _doc, image -> {
                                ImageCanvas canvas = this.createImageCanvas(style, (Image)image, mouseListener);
                                canvas.moveAbove(null);
                                this.layout(true, true);
                            });
                            return null;
                        }
                        return this.displayIcon(unit, style, mouseListener);
                    }
                    catch (IOException iOException) {}
                } else if (mt.is(MediaType.ANY_IMAGE_TYPE)) {
                    ImageCanvas imageCanvas;
                    block23: {
                        InputStream stream = ((IBinaryUnit)unit).getInput().getStream();
                        try {
                            Image img = new Image((Device)this.getDisplay(), stream);
                            UIUtil.dbgImageResTrack(img);
                            imageCanvas = this.createImageCanvas(style, img, mouseListener);
                            if (stream == null) break block23;
                        }
                        catch (Throwable img) {
                            try {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable) {
                                        img.addSuppressed(throwable);
                                    }
                                }
                                throw img;
                            }
                            catch (Exception exception) {}
                        }
                        stream.close();
                    }
                    return imageCanvas;
                }
                String unitName = unit.getName();
                if (WindowExplorerView.this.previewType == PreviewType.All && (!Extensions.hasExtension(unitName) || Extensions.hasKnownTextDocumentExtension(unitName))) {
                    IInput input = ((IBinaryUnit)unit).getInput();
                    ITextDocument rawDoc = SwitchableTextFragment.buildDocument(input, "UTF-8");
                    TextFragment textdump = new TextFragment(this, 0, WindowExplorerView.this.context, unit, null, rawDoc, true);
                    this.setTextLayoutData((Control)textdump, rawDoc, this.level);
                    return textdump;
                }
            }
            return this.displayIcon(unit, style, mouseListener);
        }

        private ImageCanvas createImageCanvas(int style, Image image, MouseListener mouseListener) {
            return this.createImageCanvas(style, image, mouseListener, true, false);
        }

        private ImageCanvas createImageCanvas(int style, Image image, MouseListener mouseListener, boolean disposeOnClose, boolean alwaysZoom) {
            ImageCanvas canvas = new ImageCanvas(this, style, image, disposeOnClose, alwaysZoom);
            this.preferredHeightCallback = () -> {
                GridData gdUnit = UIUtil.createGridDataFillHorizontally();
                gdUnit.heightHint = this.previewHeight;
                canvas.setLayoutData(gdUnit);
                if (!alwaysZoom && canvas.shouldRefresh()) {
                    canvas.redraw();
                }
            };
            if (mouseListener != null) {
                canvas.addMouseListener(mouseListener);
            }
            this.preferredHeightCallback.run();
            return canvas;
        }

        @Override
        public IUnit getUnit() {
            return this.unit;
        }

        @Override
        public int getLabelHeight(boolean compute) {
            if (compute) {
                this.updateLabel();
            }
            return this.labelHeight;
        }

        @Override
        public void updateLayout() {
            this.updateLabel();
            this.updatePreferredHeight();
            WindowExplorerView.this.windowLayout.setLayoutData((Control)this, this.level, this.level != 0 ? 15 : WindowExplorerView.this.maxLabelHeight, this.useAllSpace);
        }

        private void updatePreferredHeight() {
            int size;
            this.preferredWidth = size = WindowExplorerView.this.windowLayout.getAvailableSize(this.level);
            this.previewHeight = this.level == 0 ? size - 3 : size - 15;
            if (this.preferredHeightCallback != null) {
                this.preferredHeightCallback.run();
            }
        }

        private ImageCanvas displayIcon(IUnit unit, int style, MouseListener mouseListener) {
            Image icon = UnitPartManager.getIconForUnit(unit);
            if (icon == null) {
                icon = UnitPartManager.getIconForUnit(null);
            }
            if (icon != null) {
                ImageCanvas canvas = this.createImageCanvas(style, icon, mouseListener, false, true);
                canvas.setEnabled(false);
                return canvas;
            }
            return null;
        }

        private void setTextLayoutData(Control text, ITextDocument rawDoc, int level) {
            int nbLines = 16;
            int lineSize = 20;
            if (level <= 1 && rawDoc.getAnchorCount() <= 15L) {
                if (text instanceof AbstractTextFragment) {
                    lineSize = ((AbstractTextFragment)text).getViewer().getTextWidget().getLineHeight();
                }
                nbLines = rawDoc.getDocumentPart(0L, 15).getLines().size() + 2;
            }
            this.setGenericLayoutData(text, nbLines, lineSize, level);
        }

        private void setDataFrameLayoutData(AbstractDataFrameFragment<?> ctl, int level) {
            ctl.setFilterVisibility(false, false);
            int nbLines = ctl.getRowCount() + 1;
            int lineSize = 20;
            this.setGenericLayoutData((Control)ctl, nbLines, lineSize, level);
        }

        private void setTableLayoutData(TableFragment ctl, ITableDocument rawDoc, int level) {
            ctl.setFilterVisibility(false, false);
            int nbLines = rawDoc.getRowCount() + 1;
            int lineSize = 20;
            this.setGenericLayoutData((Control)ctl, nbLines, lineSize, level);
        }

        private void setTreeLayoutData(TreeFragment ctl, ITreeDocument rawDoc, int level) {
            ctl.setFilterVisibility(false, false);
            int nbLines = this.getRowCount(rawDoc);
            int lineSize = 20;
            this.setGenericLayoutData((Control)ctl, nbLines, lineSize, level);
        }

        private int getRowCount(ITreeDocument rawDoc) {
            return this.getRowCount(rawDoc, rawDoc.getRoots(), 0, 0);
        }

        private int getRowCount(ITreeDocument rawDoc, List<? extends INode> nodes, int level, int size) {
            if ((size += nodes.size()) > 15 || rawDoc.getInitialExpansionLevel() == level) {
                return size;
            }
            for (INode iNode : nodes) {
                size = this.getRowCount(rawDoc, iNode.getChildren(), level + 1, size);
                if (size <= 15) continue;
                return size;
            }
            return size;
        }

        private void setGenericLayoutData(Control ctl, int nbLines, int lineSize, int level) {
            this.useAllSpace = true;
            this.preferredHeightCallback = () -> {
                GridData gdUnit = UIUtil.createGridDataFillHorizontally();
                gdUnit.heightHint = this.previewHeight;
                ctl.setLayoutData((Object)gdUnit);
            };
            this.preferredHeightCallback.run();
        }

        private Control getDefaultRepresentation(IUnit unit, IRcpClientContext context) {
            IUnitFormatter unitFormatter = unit.getFormatter();
            if (unitFormatter.getPresentationCount() == 0) {
                return null;
            }
            for (IUnitDocumentPresentation pres : unitFormatter.getPresentations()) {
                if (!pres.isDefaultRepresentation()) continue;
                try {
                    return this.getRepresentation(unit, context, pres);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return null;
        }

        private Control getRepresentation(IUnit unit, IRcpClientContext context, IUnitDocumentPresentation pres) throws Exception {
            IGenericDocument doc = pres.getDocument();
            if (doc instanceof HexDumpDocument) {
                BinaryDataFragment fragment = new BinaryDataFragment(this, 0, context, unit, null, (HexDumpDocument)doc);
                this.wrapDocumentFragment(fragment);
                return fragment;
            }
            if (doc instanceof ITextDocument) {
                TextFragment fragment = new TextFragment(this, 0, context, unit, null, (ITextDocument)doc, true);
                this.wrapDocumentFragment(fragment);
                return fragment;
            }
            if (doc instanceof ITableDocument) {
                TableFragment fragment = new TableFragment(this, 0, context, unit, (ITableDocument)doc, null);
                this.wrapDocumentFragment(fragment);
                return fragment;
            }
            if (doc instanceof ITreeDocument) {
                TreeFragment fragment = new TreeFragment(this, 0, context, unit, (ITreeDocument)doc, null);
                this.wrapDocumentFragment(fragment);
                return fragment;
            }
            return null;
        }

        private void wrapDocumentFragment(AbstractUnitFragment<?> fragment) {
            IGenericDocument doc = ((IDocumentBasedFragment)((Object)fragment)).getDocument();
            fragment.addDisposeListener(e -> doc.dispose());
        }

        private class ImageCanvas
        extends Canvas {
            private FileWidget parent;
            private Image image;
            private int currentWidth;
            private int currentHeight;
            private boolean currentZoom;

            public ImageCanvas(FileWidget parent, int style, Image img, boolean disposeOnClose, boolean alwaysZoom) {
                super((Composite)parent, style | 0x40000);
                this.image = null;
                this.parent = parent;
                if (img == null) {
                    return;
                }
                this.image = img;
                this.addPaintListener(e -> {
                    Rectangle bounds = this.image.getBounds();
                    this.currentWidth = parent.preferredWidth;
                    this.currentHeight = parent.previewHeight;
                    this.currentZoom = WindowExplorerView.this.zoom;
                    double ratio = UIUtil.getBestRatio(this.image, this.currentWidth, this.currentHeight);
                    if (ratio > 1.0) {
                        if (WindowExplorerView.this.zoom || alwaysZoom) {
                            if (ratio > 3.0) {
                                ratio = 3.0;
                            }
                        } else {
                            ratio = 1.0;
                        }
                    }
                    int finalWidth = (int)((double)bounds.width * ratio);
                    int finalHeight = (int)((double)bounds.height * ratio);
                    int destX = finalWidth < this.currentWidth ? (this.currentWidth - finalWidth) / 2 : 0;
                    int destY = finalHeight < this.currentHeight ? this.currentHeight - finalHeight : 0;
                    e.gc.drawImage(this.image, 0, 0, bounds.width, bounds.height, destX, destY, finalWidth, finalHeight);
                });
                if (disposeOnClose) {
                    this.addDisposeListener(e -> this.image.dispose());
                }
            }

            public boolean shouldRefresh() {
                return this.currentZoom != WindowExplorerView.this.zoom || this.currentWidth != this.parent.preferredWidth || this.currentHeight != this.parent.previewHeight;
            }
        }
    }

    private static interface IUnitWidget {
        public IUnit getUnit();

        public int getLabelHeight(boolean var1);

        public void updateLayout();
    }

    private class DblClickGoTo
    implements MouseListener {
        private IUnit currentUnit;

        public DblClickGoTo(IUnit currentUnit) {
            this.currentUnit = currentUnit;
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
            WindowExplorerView.this.setUnit(this.currentUnit, true);
        }
    }

    private class FolderWidget
    implements IUnitWidget {
        private final Group group;
        private final String groupName;
        private final IUnit unit;

        public FolderWidget(Composite parent, int style, IUnit child, MouseListener mouseListener) {
            this.group = new Group(parent, 0);
            this.group.setData("FolderWidget", (Object)this);
            if (mouseListener != null) {
                this.group.addMouseListener(mouseListener);
            }
            this.unit = child;
            this.groupName = child.getName();
            this.updateLayout();
        }

        @Override
        public void updateLayout() {
            for (Control child : this.group.getChildren()) {
                child.setLayoutData(null);
            }
            int maxGroupName = WindowExplorerView.this.windowLayout.getMaxGroupName();
            if (maxGroupName == -1 || this.groupName.length() <= maxGroupName) {
                this.group.setText(this.groupName);
                this.group.setToolTipText(null);
            } else {
                this.group.setText(this.groupName.substring(0, maxGroupName - 3) + "...");
                this.group.setToolTipText(this.groupName);
            }
            WindowExplorerView.this.windowLayout.setLayout((Composite)this.group, false);
            WindowExplorerView.this.windowLayout.setLayoutData((Control)this.group, 0, 15, true);
        }

        @Override
        public IUnit getUnit() {
            return this.unit;
        }

        @Override
        public int getLabelHeight(boolean compute) {
            return 0;
        }
    }
}

