/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.rcpclient.extensions.webbrowser.IWebBrowserSource;
import java.util.function.Consumer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;

public class WebBrowserView
extends Composite {
    private static final int INITIAL_SVG_SIZE = 200;
    private Browser browser = new Browser((Composite)this, 0);
    private double scale = 1.0;

    public WebBrowserView(Composite parent, IWebBrowserSource input) {
        this(parent, input, null, null);
    }

    public WebBrowserView(Composite parent, IWebBrowserSource input, Consumer<Browser> browserFunction) {
        this(parent, input, browserFunction, null);
    }

    public WebBrowserView(Composite parent, IWebBrowserSource input, ProgressListener listener) {
        this(parent, input, null, listener);
    }

    public WebBrowserView(final Composite parent, IWebBrowserSource input, Consumer<Browser> browserFunction, ProgressListener listener) {
        super(parent, 0);
        this.browser.setJavascriptEnabled(browserFunction != null);
        if (browserFunction != null) {
            browserFunction.accept(this.browser);
        }
        this.browser.setMenu(new Menu((Control)this));
        if (input.getWidthHint() != -1 && input.getHeightHint() != -1) {
            this.browser.setBounds(0, 0, input.getWidthHint(), input.getHeightHint());
        } else {
            this.setLayout((Layout)new FillLayout());
        }
        if (input.isImage()) {
            this.browser.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    Rectangle bounds = parent.getBounds();
                    WebBrowserView.this.browser.setBounds(0, 0, Math.min(bounds.width, (int)(200.0 * WebBrowserView.this.scale)), Math.min(bounds.height, (int)(200.0 * WebBrowserView.this.scale)));
                }
            });
            this.browser.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Rectangle bounds = parent.getBounds();
                    WebBrowserView.this.browser.setBounds(0, 0, Math.min(bounds.width, (int)(200.0 * WebBrowserView.this.scale)), Math.min(bounds.height, (int)(200.0 * WebBrowserView.this.scale)));
                }
            });
            this.browser.addListener(37, new Listener(){

                public void handleEvent(Event event) {
                    WebBrowserView.this.scale = event.count > 0 ? (WebBrowserView.this.scale += (double)0.2f) : (WebBrowserView.this.scale -= (double)0.2f);
                    WebBrowserView.this.scale = Math.max(WebBrowserView.this.scale, (double)0.2f);
                    WebBrowserView.this.browser.redraw();
                }
            });
        }
        if (listener != null) {
            this.browser.addProgressListener(listener);
        }
        if (input.isUrl()) {
            this.browser.setUrl(input.getUrl());
        } else {
            this.browser.setText(input.getText());
        }
    }
}

