/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.core.actions.ActionContext;
import com.pnfsoftware.jeb.core.actions.ActionTypeHierarchyData;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.tree.ICodeNode;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeClass;
import com.pnfsoftware.jeb.core.units.code.ICodeField;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.core.units.code.ICodeMethod;
import com.pnfsoftware.jeb.core.units.code.ICodeType;
import com.pnfsoftware.jeb.core.units.code.ICodeUnit;
import com.pnfsoftware.jeb.core.units.code.IDecompilerUnit;
import com.pnfsoftware.jeb.core.units.code.ISourceUnit;
import com.pnfsoftware.jeb.core.units.code.android.IDexUnit;
import com.pnfsoftware.jeb.rcpclient.AssetManagerOverlay;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultStyledCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTreeViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTreeContentProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.PatternTreeViewer;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.CodeFragmentUtil;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.base.Couple;
import com.pnfsoftware.jeb.util.collect.ArrayUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class TypeHierarchyView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(TypeHierarchyView.class);
    RcpClientContext context;
    Display display;
    IInteractiveUnit sourceUnit;
    ITextDocument sourceDoc;
    long sourceItemId;
    String sourceAddress;
    Button wLockedSource;
    boolean lockedSource;
    Text wSource;
    FilteredTreeViewer ftviewer;
    DataFrame df1;
    DataFrameView dfv1;
    DataFrame df2;
    DataFrameView dfv2;
    DataFrame df3;
    DataFrameView dfv3;

    public TypeHierarchyView(Composite parent, RcpClientContext context) {
        super(parent, 0);
        this.context = context;
        this.display = parent.getDisplay();
        UIUtil.setStandardLayout(this, 1, 0, 0);
        Composite c1 = UIUtil.createCompositeGrid(this, 0, 1, 6, 0);
        UIUtil.createLabel(c1, "Source: ");
        this.wSource = UIUtil.createTextboxInGrid(c1, 2056, 100, 1, true, false);
        this.createControlWidgets(c1);
        SashForm sash = new SashForm((Composite)this, 512);
        sash.setLayoutData((Object)UIUtil.createGridDataFill(true, true));
        SashForm sash1 = new SashForm((Composite)sash, 256);
        sash1.setLayoutData((Object)UIUtil.createGridDataFill(true, true));
        this.ftviewer = new PatternTreeViewer((Composite)sash1, 65536, new String[]{"Type", "Signature"}, null, true);
        this.ftviewer.getFilteredTreeWidget().setFilterVisibility(false);
        this.ftviewer.getFilteredTreeWidget().setLayoutData(UIUtil.createGridDataFill(true, true));
        this.ftviewer.displayTreeAsTable();
        this.ftviewer.setContentProvider(new ContentProvider());
        this.ftviewer.setLabelProvider(new LabelProvider());
        this.ftviewer.expandAll();
        this.ftviewer.addSelectionChangedListener(e -> {
            ICodeNode node = null;
            TreeSelection sel = (TreeSelection)e.getSelection();
            if (sel != null) {
                node = (ICodeNode)sel.getFirstElement();
            }
            this.updateOtherViewers(node);
        });
        if (context != null) {
            this.ftviewer.addDoubleClickListener(e -> {
                TreeSelection sel = (TreeSelection)e.getSelection();
                this.navTo(sel);
            });
        }
        this.df1 = new DataFrame("Interface", "Signature");
        this.dfv1 = new DataFrameView((Composite)sash1, this.df1, false);
        this.dfv1.disableFilters();
        this.dfv1.setLayoutData(UIUtil.createGridDataFillHorizontally());
        this.dfv1.addDoubleClickListener(e -> {
            IStructuredSelection sel = (IStructuredSelection)this.dfv1.getSelection();
            this.navTo(sel);
        });
        SashForm sash2 = new SashForm((Composite)sash, 256);
        sash2.setLayoutData((Object)UIUtil.createGridDataFill(true, true));
        this.df2 = new DataFrame("Method", "Full name");
        this.dfv2 = new DataFrameView((Composite)sash2, this.df2, false);
        this.dfv2.setFilterVisibility(false);
        this.dfv2.setDisabledFilterToggle(true);
        this.dfv2.addDoubleClickListener(e -> {
            IStructuredSelection sel = (IStructuredSelection)this.dfv2.getSelection();
            this.navTo(sel);
        });
        this.df3 = new DataFrame("Field", "Type");
        this.dfv3 = new DataFrameView((Composite)sash2, this.df3, false);
        this.dfv3.setFilterVisibility(false);
        this.dfv3.setDisabledFilterToggle(true);
        this.dfv3.addDoubleClickListener(e -> {
            IStructuredSelection sel = (IStructuredSelection)this.dfv3.getSelection();
            this.navTo(sel);
        });
        this.wSource.setFocus();
        this.wSource.forceFocus();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TypeHierarchyView.this.resetSource();
            }
        });
    }

    void navTo(IStructuredSelection sel) {
        ICodeItem item = null;
        if (sel != null && sel.getFirstElement() != null) {
            Object o = sel.getFirstElement();
            if (o instanceof DataFrame.Row) {
                item = (ICodeItem)((DataFrame.Row)o).data;
            } else if (o instanceof ICodeNode) {
                item = ((ICodeNode)o).getObject();
            }
            if (item != null && this.context != null) {
                String address = item.getAddress();
                GraphicalActionExecutor.gotoAddress(this.context, this.sourceUnit, address);
            }
        }
    }

    void createControlWidgets(Composite parent) {
        this.wLockedSource = UIUtil.createCheckbox(parent, "Lock", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TypeHierarchyView.this.lockedSource = TypeHierarchyView.this.wLockedSource.getSelection();
            }
        });
        this.wLockedSource.setToolTipText("Tick to prevent auto-refresh (disable the widget)");
    }

    public boolean forceFocus() {
        return this.ftviewer.getFilteredTreeWidget().forceFocus();
    }

    public boolean setFocus() {
        return this.ftviewer.getFilteredTreeWidget().setFocus();
    }

    void updateOtherViewers(ICodeNode node) {
        Object sig;
        Image img;
        this.df1.clear();
        this.df2.clear();
        this.df3.clear();
        if (node == null) {
            this.dfv1.refresh();
            this.dfv2.refresh();
            this.dfv3.refresh();
            return;
        }
        ICodeItem item = node.getObject();
        ICodeClass c = null;
        if (item instanceof ICodeType) {
            ICodeType t = (ICodeType)item;
            c = t.getImplementingClass();
        }
        if (c != null) {
            Iterator<ICodeItem> iterator = c.getImplementedInterfaces().iterator();
            while (iterator.hasNext()) {
                ICodeType iCodeType;
                ICodeItem bestitem = iCodeType = iterator.next();
                ICodeClass ic = iCodeType.getImplementingClass();
                if (ic != null) {
                    bestitem = ic;
                }
                Image img2 = CodeFragmentUtil.getCodeNodeIcon2(bestitem, null);
                this.df1.addRow(new DataFrame.Row(Arrays.asList(iCodeType.getName(), iCodeType.getSignature(true, false)), img2, bestitem));
            }
        }
        this.dfv1.refresh();
        if (c != null) {
            for (ICodeMethod iCodeMethod : c.getMethods()) {
                img = CodeFragmentUtil.getCodeNodeIcon2(iCodeMethod, null);
                sig = iCodeMethod.getReturnType().getSignature(true, false) + " " + iCodeMethod.getSignature(true, false);
                this.df2.addRow(new DataFrame.Row(Arrays.asList(iCodeMethod.getName(), sig), img, iCodeMethod));
            }
        }
        this.dfv2.refresh();
        if (c != null) {
            for (ICodeField iCodeField : c.getFields()) {
                img = CodeFragmentUtil.getCodeNodeIcon2(iCodeField, null);
                sig = iCodeField.getFieldType().getSignature(true, false);
                this.df3.addRow(new DataFrame.Row(Arrays.asList(iCodeField.getName(), sig), img, iCodeField));
            }
        }
        this.dfv3.refresh();
    }

    public void setLockedSource(boolean locked) {
        if (this.lockedSource == locked) {
            return;
        }
        this.lockedSource = locked;
        this.wLockedSource.setSelection(locked);
    }

    public boolean isLockedSource() {
        return this.lockedSource;
    }

    public void resetSource() {
        this.setSource(null, null, 0L, null);
    }

    public boolean setSource(IInteractiveUnit sourceUnit, ITextDocument sourceDoc, long sourceItemId, String sourceAddress) {
        if (this.lockedSource) {
            return false;
        }
        this.sourceUnit = sourceUnit;
        this.sourceDoc = sourceDoc;
        this.sourceItemId = sourceItemId;
        this.sourceAddress = sourceAddress;
        String s = "";
        if (sourceUnit != null && sourceItemId != 0L) {
            String addr = sourceUnit.getAddressOfItem(sourceItemId);
            s = addr != null ? addr : Strings.ff("Item: 0x%X", sourceItemId);
        } else if (sourceAddress != null) {
            s = sourceAddress;
        }
        this.wSource.setText(s);
        this.determineHierarchy(s);
        return true;
    }

    private void determineHierarchy(String addr) {
        if (this.sourceUnit == null || addr == null) {
            this.ftviewer.setInput(null);
            return;
        }
        logger.debug("Type Hierarchy: entry: %s", addr);
        ICodeNode entryNode = null;
        ArrayList<ICodeNode> segments = new ArrayList<ICodeNode>();
        ICodeUnit code = null;
        IInteractiveUnit iInteractiveUnit = this.sourceUnit;
        if (iInteractiveUnit instanceof ICodeUnit) {
            ICodeUnit _code;
            code = _code = (ICodeUnit)iInteractiveUnit;
        } else {
            iInteractiveUnit = this.sourceUnit;
            if (iInteractiveUnit instanceof IDecompilerUnit) {
                IDecompilerUnit decomp = (IDecompilerUnit)iInteractiveUnit;
                code = decomp.getCodeUnit();
            } else {
                iInteractiveUnit = this.sourceUnit;
                if (iInteractiveUnit instanceof ISourceUnit) {
                    ISourceUnit src = (ISourceUnit)iInteractiveUnit;
                    code = src.getDecompiler().getCodeUnit();
                }
            }
        }
        if (code instanceof IDexUnit) {
            entryNode = ((IDexUnit)code).getTypeHierarchy(addr, 500, true);
        } else {
            ActionContext info = new ActionContext(this.sourceUnit, 12, 0L, addr);
            ActionTypeHierarchyData data = new ActionTypeHierarchyData();
            if (info.getUnit().prepareExecution(info, data)) {
                entryNode = data.getBaseNode();
            }
        }
        ICodeNode n0 = entryNode;
        if (n0 != null) {
            while (true) {
                segments.add(0, n0);
                ICodeNode parent = n0.getParent();
                if (parent == null) break;
                n0 = parent;
            }
        }
        ICodeNode rootNode = n0;
        this.ftviewer.setInput(new ICodeNode[]{rootNode, entryNode});
        this.ftviewer.expandAll();
        this.ftviewer.setSelection(new TreeSelection(new TreePath(segments.toArray())), true);
    }

    public class ContentProvider
    implements IFilteredTreeContentProvider {
        ICodeNode rootNode;

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.rootNode = null;
            if (newInput == null) {
                return;
            }
            this.rootNode = ((ICodeNode[])newInput)[0];
        }

        @Override
        public Object[] getElements(Object inputElement) {
            if (this.rootNode == null) {
                return ArrayUtil.NO_OBJECT;
            }
            return new ICodeNode[]{this.rootNode};
        }

        @Override
        public Object getParent(Object element) {
            ICodeNode node = (ICodeNode)element;
            return node.getParent();
        }

        @Override
        public boolean hasChildren(Object element) {
            ICodeNode node = (ICodeNode)element;
            return node.hasChildren();
        }

        @Override
        public Object[] getChildren(Object element) {
            ICodeNode node = (ICodeNode)element;
            return node.getChildren().toArray();
        }
    }

    class LabelProvider
    extends DefaultStyledCellLabelProvider {
        LabelProvider() {
        }

        @Override
        public void update(ViewerCell cell) {
            ICodeClass ic;
            int index = cell.getColumnIndex();
            String iconRelPath = null;
            Image img = null;
            AssetManagerOverlay overlay = null;
            ICodeNode node = (ICodeNode)cell.getElement();
            ICodeItem item = node.getObject();
            if (item instanceof ICodeType && (ic = ((ICodeType)item).getImplementingClass()) != null) {
                item = ic;
            }
            cell.setForeground(null);
            cell.setBackground(null);
            if (index == 0) {
                Couple<String, AssetManagerOverlay> r = CodeFragmentUtil.getCodeNodeIcon(item, null);
                iconRelPath = r.getFirst();
                overlay = r.getSecond();
                Couple<Color, Color> cols = CodeFragmentUtil.getCodeNodeTextColors(item, null);
                if (cols != null) {
                    Color bg;
                    Color fg = cols.getFirst();
                    if (fg != null) {
                        cell.setForeground(fg);
                    }
                    if ((bg = cols.getSecond()) != null) {
                        cell.setBackground(bg);
                    }
                }
            }
            if (img == null && iconRelPath != null) {
                img = UIAssetManager.getInstance().getImage(iconRelPath, overlay);
            }
            if (img != null) {
                cell.setImage(img);
            }
            super.update(cell);
        }

        @Override
        public String getStringAt(Object element, int key) {
            ICodeNode node = (ICodeNode)element;
            if (key == 0) {
                return node.getLabel();
            }
            if (key == 1) {
                ICodeItem item = node.getObject();
                return item.getSignature(true, false);
            }
            return null;
        }

        @Override
        public Object[] getRowElements(Object elt) {
            return new String[]{this.getStringAt(elt, 0), this.getStringAt(elt, 1)};
        }
    }
}

