/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.core.actions.ActionContext;
import com.pnfsoftware.jeb.core.actions.ActionXrefsData;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ReferencesView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(ReferencesView.class);
    public static final int DEFAULT_MAX_RESULTS = 30;
    RcpClientContext context;
    Display display;
    IInteractiveUnit sourceUnit;
    ITextDocument sourceDoc;
    long sourceItemId;
    String sourceAddress;
    Text wCap;
    int maxResults = 30;
    Button wLockedSource;
    boolean lockedSource;
    Text wSource;
    StyledText wTextPreview;
    DataFrameView dfvResult;
    DataFrame dfResult;
    Label wInfoLabel;
    List<Result> results = new ArrayList<Result>();

    public ReferencesView(Composite parent, final RcpClientContext context) {
        super(parent, 0);
        this.context = context;
        this.display = parent.getDisplay();
        ReferencesView canvas = this;
        UIUtil.setStandardLayout(this, 1, 0, 0);
        Composite c1 = UIUtil.createCompositeGrid(canvas, 0, 1, 6, 0);
        UIUtil.createLabel(c1, "Source: ");
        this.wSource = UIUtil.createTextboxInGrid(c1, 2056, 100, 1, true, false);
        this.createControlWidgets(c1);
        SashForm sash = new SashForm((Composite)canvas, 512);
        sash.setLayoutData((Object)UIUtil.createGridDataFill(true, true));
        this.dfResult = new DataFrame("Location", "Details");
        this.dfvResult = new DataFrameView((Composite)sash, this.dfResult, true, false);
        this.dfvResult.setFilterVisibility(false);
        this.dfvResult.setDisabledFilterToggle(true);
        this.dfvResult.addExtraEntriesToContextMenu();
        this.dfvResult.setLayoutData(UIUtil.createGridDataFillHorizontally());
        this.dfvResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = ReferencesView.this.dfvResult.getSelectionIndex();
                if (idx >= 0 && idx < ReferencesView.this.results.size()) {
                    Result r = ReferencesView.this.results.get(idx);
                    ReferencesView.this.updatePreview(r);
                }
            }
        });
        this.dfvResult.addDoubleClickListener(new IDoubleClickListener(){

            @Override
            public void doubleClick(DoubleClickEvent event) {
                boolean res = false;
                int idx = ReferencesView.this.dfvResult.getSelectionIndex();
                if (idx >= 0 && idx < ReferencesView.this.results.size()) {
                    Result r = ReferencesView.this.results.get(idx);
                    if (context != null && !(res = GraphicalActionExecutor.gotoAddress(context, ReferencesView.this.sourceUnit, r.address)) && r.coord != null) {
                        res = GraphicalActionExecutor.gotoAddress(context, ReferencesView.this.sourceUnit, r.coord.toString());
                    }
                }
                if (!res) {
                    logger.debug("Navigation failed", new Object[0]);
                }
            }
        });
        int style = 2826;
        this.wTextPreview = UIUtil.createStyledText((Composite)sash, style);
        Font font = context == null ? JFaceResources.getTextFont() : context.getFontManager().getCodeFont();
        this.wTextPreview.setFont(font);
        this.wInfoLabel = new Label((Composite)canvas, 16960);
        this.wInfoLabel.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, false));
        this.wInfoLabel.setText("");
        this.wSource.setFocus();
        this.wSource.forceFocus();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ReferencesView.this.resetSource();
            }
        });
    }

    void createControlWidgets(Composite parent) {
        UIUtil.createLabel(parent, "Cap results to: ");
        this.wCap = UIUtil.createTextboxInGrid(parent, 2048, 5, 1, false, false);
        this.wCap.setText("" + this.maxResults);
        this.wCap.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ReferencesView.this.wCap.selectAll();
            }
        });
        this.wCap.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int newCap;
                String str = ReferencesView.this.wCap.getText();
                if (Strings.isBlank(str)) {
                    newCap = Integer.MAX_VALUE;
                } else {
                    try {
                        newCap = Integer.parseInt(str);
                    }
                    catch (NumberFormatException numberFormatException) {
                        newCap = 30;
                    }
                }
                if (newCap != ReferencesView.this.maxResults) {
                    ReferencesView.this.maxResults = newCap;
                    ReferencesView.this.determineRefs();
                }
            }
        });
        this.wLockedSource = UIUtil.createCheckbox(parent, "Lock", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferencesView.this.lockedSource = ReferencesView.this.wLockedSource.getSelection();
            }
        });
        this.wLockedSource.setToolTipText("Tick to prevent auto-refresh (disable the widget)");
    }

    public boolean forceFocus() {
        return this.dfvResult.forceFocus();
    }

    public boolean setFocus() {
        return this.dfvResult.setFocus();
    }

    boolean updatePreview(Result r) {
        ITextDocumentPart part;
        if (r == null) {
            this.wTextPreview.setText("");
            return true;
        }
        if (r.coord == null) {
            this.wTextPreview.setText("");
            return true;
        }
        long aid = r.coord.getAnchorId();
        int ldelta = r.coord.getLineDelta();
        try {
            part = this.sourceDoc.getDocumentPart(aid, ldelta + 5, 5);
        }
        catch (Exception exception) {
            this.wTextPreview.setText("Rendering failed");
            return false;
        }
        String s = TextPartUtil.buildRawTextFromPart(part);
        this.wTextPreview.setText(s);
        int lineidx = TextPartUtil.coordinatesToLineIndex(part, r.coord);
        if (lineidx >= 0 && lineidx < this.wTextPreview.getLineCount()) {
            int visicharsPerLine;
            int off = this.wTextPreview.getOffsetAtLine(lineidx);
            int selbeg = off + r.coord.getColumnOffset();
            int selend = off + this.wTextPreview.getLine(lineidx).length();
            this.wTextPreview.setSelection(selbeg, selend);
            int bottomidx = JFaceTextUtil.getBottomIndex(this.wTextPreview);
            if (bottomidx == lineidx) {
                int top = this.wTextPreview.getTopIndex();
                this.wTextPreview.setTopIndex(top + 2);
            }
            if (selend >= (visicharsPerLine = this.wTextPreview.getClientArea().x / JFaceTextUtil.getAverageCharWidth((Control)this.wTextPreview))) {
                int h = this.wTextPreview.getHorizontalIndex();
                this.wTextPreview.setHorizontalIndex(h + 5);
            }
        }
        return true;
    }

    public void setLockedSource(boolean locked) {
        if (this.lockedSource == locked) {
            return;
        }
        this.lockedSource = locked;
        this.wLockedSource.setSelection(locked);
    }

    public boolean isLockedSource() {
        return this.lockedSource;
    }

    public void resetSource() {
        this.setSource(null, null, 0L, null);
    }

    public boolean setSource(IInteractiveUnit sourceUnit, ITextDocument sourceDoc, long sourceItemId, String sourceAddress) {
        if (this.lockedSource) {
            return false;
        }
        this.sourceUnit = sourceUnit;
        this.sourceDoc = sourceDoc;
        this.sourceItemId = sourceItemId;
        this.sourceAddress = sourceAddress;
        String s = "";
        if (sourceUnit != null && sourceItemId != 0L) {
            String addr = sourceUnit.getAddressOfItem(sourceItemId);
            s = addr != null ? addr : Strings.ff("Item: 0x%X", sourceItemId);
        } else if (sourceAddress != null) {
            s = sourceAddress;
        }
        this.wSource.setText(s);
        this.determineRefs();
        return true;
    }

    private void determineRefs() {
        this.results.clear();
        this.dfResult.clear();
        this.dfvResult.refresh();
        this.updatePreview(null);
        if (this.sourceUnit == null || this.sourceItemId == 0L && this.sourceAddress == null) {
            return;
        }
        ActionContext info = new ActionContext(this.sourceUnit, 4, this.sourceItemId, this.sourceAddress);
        ActionXrefsData data = new ActionXrefsData();
        data.setHintMaxResults(this.maxResults);
        if (this.sourceUnit.prepareExecution(info, data)) {
            List<String> addresses = data.getAddresses();
            List<String> userAddresses = this.context.getPropertyManager().getBoolean(".ui.PreferRealAddressesInDialogs") ? null : data.getUserAddresses();
            List<String> details = data.getDetails();
            if (addresses != null) {
                int i = 0;
                for (String addr : addresses) {
                    ICoordinates c;
                    Coordinates coord = null;
                    if (this.sourceDoc != null && (c = this.sourceDoc.addressToCoordinates(addr)) != null) {
                        coord = new Coordinates(c.getAnchorId(), c.getLineDelta(), c.getColumnOffset());
                    }
                    this.results.add(new Result(addr, coord));
                    this.dfResult.addRow(userAddresses == null ? addr : userAddresses.get(i), details == null ? "" : details.get(i));
                    ++i;
                }
            }
            this.dfvResult.refresh();
        }
    }

    static class Result {
        String address;
        ICoordinates coord;

        public Result(String address, Coordinates coord) {
            this.address = address;
            this.coord = coord;
        }
    }
}

