/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.core.IRuntimeProject;
import com.pnfsoftware.jeb.core.RuntimeProjectUtil;
import com.pnfsoftware.jeb.core.output.IGenericDocument;
import com.pnfsoftware.jeb.core.output.IUnitDocumentPresentation;
import com.pnfsoftware.jeb.core.output.IUnitFormatter;
import com.pnfsoftware.jeb.core.output.text.ICoordinates;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.text.ITextDocumentPart;
import com.pnfsoftware.jeb.core.output.text.TextPartUtil;
import com.pnfsoftware.jeb.core.output.text.impl.Coordinates;
import com.pnfsoftware.jeb.core.units.IUnit;
import com.pnfsoftware.jeb.core.units.UnitUtil;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.base.StarMatcher;
import com.pnfsoftware.jeb.util.concurrent.ActiveTask;
import com.pnfsoftware.jeb.util.format.PluralFormatter;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class QuickSearchView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(QuickSearchView.class);
    public static final int DEFAULT_MAX_RESULTS_PER_SEARCH = 100;
    public static final boolean DEFAULT_REVERSE_SEARCH = false;
    public static final boolean DEFAULT_CASE_SENSITIVE = false;
    private RcpClientContext context;
    private boolean offerSearchScopes;
    private Display display;
    private IRuntimeProject sourceProject;
    private IUnit sourceUnit;
    private ITextDocument sourceDoc;
    private ICoordinates sourceDocCoord;
    private int currentScopeId;
    private List<Button> wScopeRadios;
    private Button wCase;
    private Text wCap;
    private Text wTextSS;
    private StyledText wTextPreview;
    private DataFrameView dfvResult;
    private DataFrame dfResult;
    private Label wInfoLabel;
    private List<Result> results = new ArrayList<Result>();
    private Result displayedResult = null;
    volatile boolean reverseSearch = false;
    volatile boolean caseSensitive = false;
    volatile int maxResultsPerSearch = 100;
    private String searchString;
    private SearchRoutine sr;
    private List<SourceEntry> sourceEntries = null;
    private int scopeForCurrentEntries = -1;

    public QuickSearchView(Composite parent, final RcpClientContext context, final boolean offerSearchScopes) {
        super(parent, 0);
        this.context = context;
        this.offerSearchScopes = offerSearchScopes;
        this.display = parent.getDisplay();
        QuickSearchView canvas = this;
        UIUtil.setStandardLayout(this, 1, 0, 0);
        Composite c0 = UIUtil.createCompositeGrid(canvas, 0, 1, 9, 0);
        if (offerSearchScopes) {
            this.currentScopeId = -1;
            this.createScopeWidget(c0);
            this.createControlWidgets(c0);
            this.createRefreshWidget(c0);
        } else {
            this.currentScopeId = 0;
        }
        Composite c1 = UIUtil.createCompositeGrid(canvas, 0, 1, 6, 0);
        UIUtil.createLabel(c1, "Search string (*/? accepted): ");
        this.wTextSS = UIUtil.createTextboxInGrid(c1, 2048, 100, 1, true, false);
        this.wTextSS.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!offerSearchScopes && QuickSearchView.this.sourceProject == null && context != null) {
                    QuickSearchView.this.sourceProject = context.getOpenedProject();
                }
                QuickSearchView.this.searchString = QuickSearchView.this.wTextSS.getText();
                QuickSearchView.this.search(false);
            }
        });
        this.wTextSS.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Table table;
                if (e.keyCode == 0x1000002 && (table = QuickSearchView.this.dfvResult.getTable()).getItemCount() > 0) {
                    table.setFocus();
                    table.select(0);
                    table.notifyListeners(13, new Event());
                }
            }
        });
        if (!offerSearchScopes) {
            this.createControlWidgets(c1);
            this.createRefreshWidget(c1);
        }
        SashForm sash = new SashForm((Composite)canvas, 512);
        sash.setLayoutData((Object)UIUtil.createGridDataFill(true, true));
        this.dfResult = new DataFrame("Text", "Unit", "Document", "Location");
        this.dfvResult = new DataFrameView((Composite)sash, this.dfResult, true, true);
        this.dfvResult.disableFilters();
        this.dfvResult.addExtraEntriesToContextMenu();
        this.dfvResult.setLayoutData(UIUtil.createGridDataFillHorizontally());
        this.dfvResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List<Integer> indexes = QuickSearchView.this.dfvResult.getSelectedRows();
                if (indexes.size() != 1) {
                    QuickSearchView.this.updatePreview(null);
                    return;
                }
                int idx = indexes.get(0);
                if (idx >= 0 && idx < QuickSearchView.this.results.size()) {
                    Result r = QuickSearchView.this.results.get(idx);
                    QuickSearchView.this.updatePreview(r);
                }
            }
        });
        this.dfvResult.addDoubleClickListener(new IDoubleClickListener(){

            @Override
            public void doubleClick(DoubleClickEvent event) {
                boolean res = false;
                int idx = QuickSearchView.this.dfvResult.getSelectionIndex();
                if (idx >= 0 && idx < QuickSearchView.this.results.size()) {
                    Result r = QuickSearchView.this.results.get(idx);
                    if (context != null && !(res = GraphicalActionExecutor.gotoAddress(context, r.entry.unit, r.address))) {
                        res = GraphicalActionExecutor.gotoAddress(context, r.entry.unit, r.coord.toString());
                    }
                }
                if (!res) {
                    logger.debug("Navigation failed", new Object[0]);
                }
            }
        });
        int style = 2826;
        this.wTextPreview = UIUtil.createStyledText((Composite)sash, style);
        Font font = context == null ? JFaceResources.getTextFont() : context.getFontManager().getCodeFont();
        this.wTextPreview.setFont(font);
        this.wInfoLabel = new Label((Composite)canvas, 16960);
        this.wInfoLabel.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(1, true, false));
        this.wInfoLabel.setText("");
        this.wTextSS.setFocus();
        this.wTextSS.forceFocus();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                QuickSearchView.this.stopSearch(0L);
                QuickSearchView.this.discardSourceEntries();
            }
        });
    }

    private void createScopeWidget(Composite parent) {
        UIUtil.createLabel(parent, "Search in...");
        SelectionAdapter lScope = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button btn = (Button)e.widget;
                boolean sel = btn.getSelection();
                if (sel) {
                    int id = QuickSearchView.this.wScopeRadios.indexOf(btn);
                    QuickSearchView.this.setScope(id);
                }
            }
        };
        this.wScopeRadios = UIUtil.createRadioButtons(parent, Arrays.asList("Entire Project", "Current Unit", "Current Document"), (SelectionListener)lScope);
        this.updateScopeButtons();
        this.currentScopeId = this.selectMostRelevantScope();
    }

    private void createRefreshWidget(Composite parent) {
        UIUtil.createPushbox(parent, "Refresh", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QuickSearchView.this.search(true);
            }
        });
    }

    private void createControlWidgets(Composite parent) {
        this.wCase = UIUtil.createCheckbox(parent, "Case Sensitive", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean value = QuickSearchView.this.wCase.getSelection();
                if (value != QuickSearchView.this.caseSensitive) {
                    QuickSearchView.this.caseSensitive = value;
                    if (QuickSearchView.this.sr == null || QuickSearchView.this.sr.isDone()) {
                        QuickSearchView.this.search(false);
                    }
                }
            }
        });
        this.wCase.setSelection(this.caseSensitive);
        this.wCase.setToolTipText("Tick for a case sensitive search string");
        UIUtil.createLabel(parent, "Cap results to: ");
        this.wCap = UIUtil.createTextboxInGrid(parent, 2048, 5, 1, false, false);
        this.wCap.setText("" + this.maxResultsPerSearch);
        this.wCap.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                QuickSearchView.this.wCap.selectAll();
            }
        });
        this.wCap.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int newCap;
                String str = QuickSearchView.this.wCap.getText();
                if (Strings.isBlank(str)) {
                    newCap = Integer.MAX_VALUE;
                } else {
                    try {
                        newCap = Integer.parseInt(str);
                    }
                    catch (NumberFormatException numberFormatException) {
                        newCap = 100;
                    }
                }
                if (newCap != QuickSearchView.this.maxResultsPerSearch) {
                    QuickSearchView.this.maxResultsPerSearch = newCap;
                    if (QuickSearchView.this.sr == null || QuickSearchView.this.sr.isDone()) {
                        QuickSearchView.this.search(false);
                    }
                }
            }
        });
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String str) {
        this.wTextSS.setText(Strings.safe(str));
        this.wTextSS.setSelection(0, this.wTextSS.getText().length());
        this.wTextSS.notifyListeners(24, new Event());
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        if (caseSensitive == this.caseSensitive) {
            return;
        }
        this.caseSensitive = caseSensitive;
        this.wCase.setSelection(caseSensitive);
        this.search(false);
    }

    public int getMaxResultsPerSearch() {
        return this.maxResultsPerSearch;
    }

    public void setMaxResultsPerSearch(int cnt) {
        if (cnt == -1) {
            cnt = 100;
        }
        if (cnt == this.maxResultsPerSearch) {
            return;
        }
        this.maxResultsPerSearch = cnt;
        this.wCap.setText("" + cnt);
        this.search(false);
    }

    int getScope() {
        return this.currentScopeId;
    }

    void setScope(int id) {
        for (int i = 0; i <= 2; ++i) {
            if (i == id) continue;
            this.wScopeRadios.get(i).setSelection(false);
        }
        if (id >= 0 && id <= 2) {
            this.wScopeRadios.get(id).setSelection(true);
            this.currentScopeId = id;
            this.search(false);
        } else {
            this.currentScopeId = this.selectMostRelevantScope();
        }
        this.onSelectScope();
    }

    void onSelectScope() {
        if (this.currentScopeId == 0) {
            this.dfvResult.setColumnVisible(true, 2);
            this.dfvResult.setColumnVisible(true, 3);
        } else if (this.currentScopeId == 1) {
            this.dfvResult.setColumnVisible(false, 2);
            this.dfvResult.setColumnVisible(true, 3);
        } else if (this.currentScopeId == 2) {
            this.dfvResult.setColumnVisible(false, 2);
            this.dfvResult.setColumnVisible(false, 3);
        }
    }

    void updateScopeButtons() {
        if (this.wScopeRadios == null) {
            return;
        }
        this.wScopeRadios.get(0).setEnabled(this.sourceProject != null || this.context != null);
        this.wScopeRadios.get(1).setEnabled(this.sourceUnit != null);
        this.wScopeRadios.get(2).setEnabled(this.sourceUnit != null && this.sourceDoc != null);
    }

    int selectMostRelevantScope() {
        if (this.wScopeRadios != null) {
            if (this.sourceUnit != null && this.sourceDoc != null) {
                this.wScopeRadios.get(2).setSelection(true);
                return 2;
            }
            if (this.sourceUnit != null) {
                this.wScopeRadios.get(1).setSelection(true);
                return 1;
            }
            if (this.sourceProject != null || this.context != null) {
                this.wScopeRadios.get(0).setSelection(true);
                return 0;
            }
        }
        return -1;
    }

    public int getCurrentScopeId() {
        return this.getScope();
    }

    public void setCurrentScopeId(int id) {
        this.setScope(id);
    }

    public boolean forceFocus() {
        if (this.wTextSS.isDisposed()) {
            return false;
        }
        return this.wTextSS.forceFocus();
    }

    public boolean setFocus() {
        if (this.wTextSS.isDisposed()) {
            return false;
        }
        return this.wTextSS.setFocus();
    }

    boolean updatePreview(Result r) {
        ITextDocumentPart part;
        if (r == null) {
            this.displayedResult = r;
            this.wTextPreview.setText("");
            return true;
        }
        if (r.equals(this.displayedResult)) {
            return true;
        }
        this.displayedResult = r;
        ITextDocument doc = r.entry.doc;
        long aid = r.coord.getAnchorId();
        int ldelta = r.coord.getLineDelta();
        try {
            part = doc.getDocumentPart(aid, ldelta + 5, 5);
        }
        catch (Exception exception) {
            this.wTextPreview.setText("Rendering failed");
            return false;
        }
        String s = TextPartUtil.buildRawTextFromPart(part);
        this.wTextPreview.setText(s);
        int lineidx = TextPartUtil.coordinatesToLineIndex(part, r.coord);
        if (lineidx >= 0 && lineidx < this.wTextPreview.getLineCount()) {
            int visicharsPerLine;
            int off = this.wTextPreview.getOffsetAtLine(lineidx);
            int selbeg = off + r.coord.getColumnOffset();
            int selend = off + r.end;
            this.wTextPreview.setSelection(selbeg, selend);
            int bottomidx = JFaceTextUtil.getBottomIndex(this.wTextPreview);
            if (bottomidx == lineidx) {
                int top = this.wTextPreview.getTopIndex();
                this.wTextPreview.setTopIndex(top + 2);
            }
            if (selend >= (visicharsPerLine = this.wTextPreview.getClientArea().x / JFaceTextUtil.getAverageCharWidth((Control)this.wTextPreview))) {
                int h = this.wTextPreview.getHorizontalIndex();
                this.wTextPreview.setHorizontalIndex(h + 5);
            }
        }
        return true;
    }

    public void resetSource() {
        this.sourceProject = null;
        this.sourceUnit = null;
        this.sourceDoc = null;
        this.sourceDocCoord = null;
        this.discardSourceEntries();
        this.updateScopeButtons();
    }

    public void setSource(IRuntimeProject prj) {
        if (prj != this.sourceProject) {
            this.sourceProject = prj;
            this.discardSourceEntries();
        }
        this.updateScopeButtons();
    }

    public void setSource(IUnit unit) {
        if (unit != this.sourceUnit) {
            this.sourceUnit = unit;
            this.discardSourceEntries();
        }
        this.updateScopeButtons();
    }

    public void setSource(ITextDocument doc, ICoordinates coord) {
        if (doc != this.sourceDoc) {
            this.sourceDoc = doc;
            this.sourceDocCoord = coord;
            this.discardSourceEntries();
        }
        this.updateScopeButtons();
    }

    void generateSourceEntries(boolean regen) {
        if (this.sourceEntries != null && regen) {
            this.discardSourceEntries();
        }
        if (this.sourceEntries != null && this.getScope() != this.scopeForCurrentEntries) {
            this.discardSourceEntries();
        }
        if (this.sourceEntries == null) {
            int scope = this.getScope();
            this.sourceEntries = this.getSourceEntries(scope);
            this.scopeForCurrentEntries = scope;
        }
    }

    void discardSourceEntries() {
        if (this.sourceEntries != null) {
            this.stopSearch(1000L);
            this.sourceEntries.forEach(t -> {
                if (!t.doNotDispose) {
                    try {
                        t.doc.dispose();
                    }
                    catch (Exception exception) {}
                }
            });
            this.sourceEntries.clear();
            this.sourceEntries = null;
            this.scopeForCurrentEntries = -1;
        }
    }

    List<SourceEntry> getSourceEntries(int scope) {
        ArrayList<SourceEntry> r = new ArrayList<SourceEntry>();
        if (scope == 0) {
            if (this.sourceProject == null && this.context != null) {
                this.sourceProject = this.context.getOpenedProject();
            }
            if (this.sourceProject != null) {
                for (IUnit unit : RuntimeProjectUtil.getAllUnits(this.sourceProject)) {
                    this.collectSourceEntries(unit, r);
                }
            }
        } else if (scope == 1) {
            if (this.sourceUnit != null) {
                this.collectSourceEntries(this.sourceUnit, r);
            }
        } else if (scope == 2 && this.sourceUnit != null && this.sourceDoc != null) {
            SourceEntry e = new SourceEntry(this.sourceUnit, this.sourceDoc, "");
            e.fromCoord = this.sourceDocCoord;
            e.doNotDispose = true;
            r.add(e);
        }
        return r;
    }

    void collectSourceEntries(IUnit unit, Collection<SourceEntry> sink) {
        if (unit.isDisposed() || !unit.isProcessed()) {
            return;
        }
        IUnitFormatter ufmt = unit.getFormatter();
        for (IUnitDocumentPresentation pres : ufmt.getPresentations()) {
            IGenericDocument doc;
            try {
                doc = pres.getDocument();
            }
            catch (Exception exception) {
                continue;
            }
            if (!(doc instanceof ITextDocument)) {
                doc.dispose();
                continue;
            }
            ITextDocument _doc = (ITextDocument)doc;
            sink.add(new SourceEntry(unit, _doc, pres.getLabel()));
        }
    }

    void search(boolean forceRegenerateSourceEntries) {
        (new Object[1])[0] = this.searchString;
        this.stopSearch(10000L);
        this.wInfoLabel.setText("");
        this.results.clear();
        this.dfResult.clear();
        this.dfvResult.refresh();
        this.updatePreview(null);
        if (this.searchString == null || this.searchString.length() == 0) {
            return;
        }
        this.generateSourceEntries(forceRegenerateSourceEntries);
        this.sr = new SearchRoutine(this.searchString);
        this.sr.start(null);
    }

    void stopSearch(long joinTimeMs) {
        if (this.sr != null) {
            this.sr.cancel(true);
            if (joinTimeMs != 0L) {
                try {
                    this.sr.join(joinTimeMs);
                }
                catch (InterruptedException e) {
                    logger.catching(e);
                    return;
                }
            }
            this.sr = null;
        }
    }

    private String generateInfoLabelString(boolean completed) {
        if (this.sourceEntries == null || this.sourceEntries.isEmpty()) {
            return "No source to search in";
        }
        Object info = Strings.ff("%d %s", this.results.size(), PluralFormatter.count(this.results.size(), "match", "matches"));
        if (this.results.size() >= this.maxResultsPerSearch) {
            info = (String)info + " (capped)";
        } else if (completed) {
            info = (String)info + " (completed)";
        }
        return info;
    }

    static class Result {
        SourceEntry entry;
        Coordinates coord;
        int end;
        String address;

        public Result(SourceEntry entry, Coordinates coord, int end, String address) {
            this.entry = entry;
            this.coord = coord;
            this.end = end;
            this.address = address;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
            result = 31 * result + (this.coord == null ? 0 : this.coord.hashCode());
            result = 31 * result + this.end;
            result = 31 * result + (this.entry == null ? 0 : this.entry.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
                return false;
            }
            if (this.coord == null ? other.coord != null : !this.coord.equals(other.coord)) {
                return false;
            }
            if (this.end != other.end) {
                return false;
            }
            return !(this.entry == null ? other.entry != null : !this.entry.equals(other.entry));
        }
    }

    static class SourceEntry {
        IUnit unit;
        ITextDocument doc;
        ICoordinates fromCoord;
        String label;
        boolean doNotDispose;

        public SourceEntry(IUnit unit, ITextDocument doc, String label) {
            this.unit = unit;
            this.doc = doc;
            this.label = label;
        }
    }

    class SearchRoutine
    extends ActiveTask {
        static final int LINE_GEN_COUNT = 1000;
        String searchString;

        SearchRoutine(String searchString) {
            this.searchString = searchString;
        }

        @Override
        public void runi() {
            block2: {
                try {
                    this.runUnsafe();
                }
                catch (Exception ex) {
                    if (QuickSearchView.this.context == null) break block2;
                    String details = "searchString=" + this.searchString;
                    QuickSearchView.this.context.getErrorHandler().processThrowable(ex, false, false, false, details, null, null);
                }
            }
        }

        private void runUnsafe() {
            if (QuickSearchView.this.sourceEntries == null) {
                return;
            }
            StarMatcher matcher = new StarMatcher(this.searchString, !QuickSearchView.this.caseSensitive, true);
            int matchCount = 0;
            QuickSearchView.this.display.asyncExec((Runnable)new UIRunnable(){

                @Override
                public void runi() {
                    block3: {
                        if (SearchRoutine.this.isCancelled()) {
                            return;
                        }
                        try {
                            QuickSearchView.this.wInfoLabel.setText("Searching...");
                        }
                        catch (Exception ex) {
                            if (QuickSearchView.this.context == null) break block3;
                            QuickSearchView.this.context.getErrorHandler().processThrowableSilent(ex);
                        }
                    }
                }
            });
            for (SourceEntry target : QuickSearchView.this.sourceEntries) {
                if (this.isCancelled()) {
                    return;
                }
                try {
                    IUnit unit = target.doc.getUnit();
                    if (unit != null && (!unit.isProcessed() || unit.isDisposed())) {
                        return;
                    }
                    ITextDocument doc = target.doc;
                    ICoordinates fromCoord = target.fromCoord;
                    final String label = target.label;
                    final String unitpath = UnitUtil.buildFullyQualifiedUnitPath(target.unit);
                    long aidBegin = doc.getFirstAnchor();
                    long aidEnd = aidBegin + doc.getAnchorCount();
                    long aid = aidBegin;
                    long startline = 0L;
                    if (fromCoord != null) {
                        aid = fromCoord.getAnchorId();
                        startline = fromCoord.getLineDelta();
                    }
                    long aid0 = aid;
                    for (int round = 0; round <= 1; ++round) {
                        while (aid < aidEnd || aid == aidEnd && round == 1) {
                            if (this.isCancelled()) {
                                return;
                            }
                            ITextDocumentPart part = doc.getDocumentPart(aid, 1000);
                            if (part.getLines().isEmpty()) break;
                            block5: for (TextPartUtil.LineInfo li : TextPartUtil.iterateLines(part)) {
                                if (this.isCancelled()) {
                                    return;
                                }
                                if (li.getAnchorId() < aid || (round == 0 ? li.getAnchorId() == aid0 && (long)li.getAnchoredLineIndex() < startline : li.getAnchorId() == aid0 && (long)li.getAnchoredLineIndex() >= startline)) continue;
                                final String str = part.getLine(li.getPartLineIndex()).getText().toString();
                                int pos = 0;
                                do {
                                    if (this.isCancelled()) {
                                        return;
                                    }
                                    StarMatcher.Result r = matcher.find(str, pos);
                                    if (r == null) continue block5;
                                    final Coordinates coord = new Coordinates(li.getAnchorId(), li.getAnchoredLineIndex(), r.charStartIndex);
                                    final String addr = doc.coordinatesToAddress(coord);
                                    final Result result = new Result(target, coord, r.charEndIndex, addr);
                                    pos = r.charEndIndex;
                                    QuickSearchView.this.display.asyncExec((Runnable)new UIRunnable(){

                                        @Override
                                        public void runi() {
                                            block3: {
                                                if (SearchRoutine.this.isCancelled()) {
                                                    return;
                                                }
                                                try {
                                                    QuickSearchView.this.results.add(result);
                                                    QuickSearchView.this.dfResult.addRow(str, unitpath, label, addr != null ? addr : coord);
                                                    QuickSearchView.this.dfvResult.refresh();
                                                    QuickSearchView.this.wInfoLabel.setText(QuickSearchView.this.generateInfoLabelString(false));
                                                }
                                                catch (Exception ex) {
                                                    if (QuickSearchView.this.context == null) break block3;
                                                    QuickSearchView.this.context.getErrorHandler().processThrowableSilent(ex);
                                                }
                                            }
                                        }
                                    });
                                } while (++matchCount < QuickSearchView.this.maxResultsPerSearch);
                                return;
                            }
                            long aidLast = TextPartUtil.getLastAnchorId(part);
                            if (aidLast < 0L) break;
                            aid = Math.max(aidLast + 1L, aid + 1L);
                        }
                        aidEnd = aid0;
                        aid = aidBegin;
                    }
                }
                catch (Exception exception) {
                }
            }
            QuickSearchView.this.display.asyncExec((Runnable)new UIRunnable(){

                @Override
                public void runi() {
                    block3: {
                        if (SearchRoutine.this.isCancelled()) {
                            return;
                        }
                        try {
                            QuickSearchView.this.wInfoLabel.setText(QuickSearchView.this.generateInfoLabelString(true));
                        }
                        catch (Exception ex) {
                            if (QuickSearchView.this.context == null) break block3;
                            QuickSearchView.this.context.getErrorHandler().processThrowableSilent(ex);
                        }
                    }
                }
            });
        }
    }
}

