/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PrimitiveDisplayView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(PrimitiveDisplayView.class);
    private DataFrame df;
    private DataFrameView dfv;

    public PrimitiveDisplayView(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.df = new DataFrame("Type", "Value", "Hex value");
        this.dfv = new DataFrameView((Composite)this, this.df, false);
        this.dfv.addExtraEntriesToContextMenu();
    }

    public void setBytes(byte[] data) {
        this.setBytes(data, 0, data != null ? data.length : -1);
    }

    public void setBytes(byte[] data, int offset, int length) {
        this.df.clear();
        if (data != null && offset >= 0 && length > 0 && offset + length <= data.length) {
            ByteBuffer b = ByteBuffer.wrap(data, offset, length);
            if (b.limit() >= 2) {
                b.order(ByteOrder.LITTLE_ENDIAN);
                short s = b.getShort(0);
                this.df.addRow("i16 LE", Short.toString(s), Integer.toHexString(s & 0xFFFF));
                int u = s & 0xFFFF;
                this.df.addRow("u16 LE", Integer.toString(u), Integer.toHexString(u & 0xFFFF));
                b.order(ByteOrder.BIG_ENDIAN);
                short s2 = b.getShort(0);
                this.df.addRow("i16 BE", Short.toString(s2), Integer.toHexString(s2 & 0xFFFF));
                u = s2 & 0xFFFF;
                this.df.addRow("i16 BE", Integer.toString(u), Integer.toHexString(u & 0xFFFF));
            }
            if (b.limit() >= 4) {
                b.order(ByteOrder.LITTLE_ENDIAN);
                int n = b.getInt(0);
                this.df.addRow("i32 LE", Integer.toString(n), Integer.toHexString(n));
                b.order(ByteOrder.BIG_ENDIAN);
                int n2 = b.getInt(0);
                this.df.addRow("i32 BE", Integer.toString(n2), Integer.toHexString(n2));
            }
            if (b.limit() >= 8) {
                b.order(ByteOrder.LITTLE_ENDIAN);
                long l = b.getLong(0);
                this.df.addRow("i64 LE", Long.toString(l), Long.toHexString(l));
                b.order(ByteOrder.BIG_ENDIAN);
                l = b.getLong(0);
                this.df.addRow("i64 BE", Long.toString(l), Long.toHexString(l));
            }
            if (b.limit() >= 4) {
                b.order(ByteOrder.LITTLE_ENDIAN);
                float f = b.getFloat(0);
                this.df.addRow("f32 LE", Float.toString(f), Float.toHexString(f));
                b.order(ByteOrder.BIG_ENDIAN);
                f = b.getFloat(0);
                this.df.addRow("f32 BE", Float.toString(f), Float.toHexString(f));
            }
            if (b.limit() >= 8) {
                b.order(ByteOrder.LITTLE_ENDIAN);
                double d = b.getDouble(0);
                this.df.addRow("f64 LE", Double.toString(d), Double.toHexString(d));
                b.order(ByteOrder.BIG_ENDIAN);
                d = b.getDouble(0);
                this.df.addRow("f64 BE", Double.toString(d), Double.toHexString(d));
            }
            try {
                String string = new String(data, offset, length, "UTF-8");
                this.df.addRow("UTF-8", string);
            }
            catch (Exception exception) {
                logger.catching(exception);
            }
        }
        this.dfv.refresh();
    }
}

