/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.rcpclient.UIAssetManager;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIRunnable;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class PendingBackground {
    private Thread pending;
    private Control widget;
    private PendingState state;

    public PendingBackground(Control widget) {
        this.widget = widget;
    }

    public void activate() {
        if (this.pending != null) {
            return;
        }
        this.state = new PendingState();
        this.pending = ThreadUtil.create(new Runnable(){

            @Override
            public void run() {
                try {
                    while (PendingBackground.this.pending != null && !PendingBackground.this.pending.isInterrupted() && !PendingBackground.this.widget.isDisposed()) {
                        UIExecutor.async((Widget)PendingBackground.this.widget, (UIRunnable)new PendingRunnable());
                        try {
                            Thread.sleep(300L);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                    }
                }
                finally {
                    PendingBackground.this.restoreOriginalBackground();
                }
            }
        });
        this.pending.start();
    }

    public void deactivate() {
        this.pending.interrupt();
        this.pending = null;
        if (this.state != null) {
            this.restoreOriginalBackground();
        }
    }

    private void restoreOriginalBackground() {
        UIExecutor.async((Widget)this.widget, new UIRunnable(){

            @Override
            public void runi() {
                PendingBackground pendingBackground = PendingBackground.this;
                synchronized (pendingBackground) {
                    if (PendingBackground.this.state == null) {
                        return;
                    }
                    Color current = PendingBackground.this.widget.getBackground();
                    if (PendingBackground.this.state.pendingColors.contains(current)) {
                        PendingBackground.this.widget.setBackground(PendingBackground.this.state.reference);
                    }
                    PendingBackground.this.state = null;
                }
            }
        });
    }

    private static class PendingState {
        Set<Color> pendingColors = new HashSet<Color>();
        int colorIndex = 0;
        Color reference = null;
        Color last = null;

        private PendingState() {
        }
    }

    private class PendingRunnable
    extends UIRunnable {
        public PendingRunnable() {
            super("Pending Background");
        }

        @Override
        public void runi() {
            if (PendingBackground.this.pending == null || PendingBackground.this.widget.isDisposed()) {
                return;
            }
            PendingBackground pendingBackground = PendingBackground.this;
            synchronized (pendingBackground) {
                if (PendingBackground.this.state == null) {
                    return;
                }
                Color current = PendingBackground.this.widget.getBackground();
                if (PendingBackground.this.state.last == null) {
                    PendingBackground.this.state.reference = current;
                } else if (!PendingBackground.this.state.pendingColors.contains(current)) {
                    PendingBackground.this.state.reference = current;
                }
                if (PendingBackground.this.state.reference != null) {
                    PendingBackground.this.state.last = PendingBackground.this.state.reference;
                    int gradient = 20;
                    int red = this.convertForGradient(PendingBackground.this.state.reference.getRed(), gradient);
                    int green = this.convertForGradient(PendingBackground.this.state.reference.getGreen(), gradient);
                    int blue = this.convertForGradient(PendingBackground.this.state.reference.getBlue(), gradient);
                    switch (PendingBackground.this.state.colorIndex) {
                        case 0: 
                        case 4: {
                            UIAssetManager aman = UIAssetManager.getInstance();
                            PendingBackground.this.state.last = aman.getColor(red, green, blue);
                            break;
                        }
                        case 1: 
                        case 3: {
                            UIAssetManager aman = UIAssetManager.getInstance();
                            PendingBackground.this.state.last = aman.getColor(red - (gradient >> 1), green - (gradient >> 1), blue - (gradient >> 1));
                            break;
                        }
                        case 2: {
                            UIAssetManager aman = UIAssetManager.getInstance();
                            PendingBackground.this.state.last = aman.getColor(red - gradient, green - gradient, blue - gradient);
                            break;
                        }
                        case 5: 
                        case 7: {
                            UIAssetManager aman = UIAssetManager.getInstance();
                            PendingBackground.this.state.last = aman.getColor(red + (gradient >> 1), green + (gradient >> 1), blue + (gradient >> 1));
                            break;
                        }
                        case 6: {
                            UIAssetManager aman = UIAssetManager.getInstance();
                            PendingBackground.this.state.last = aman.getColor(red + gradient, green + gradient, blue + gradient);
                        }
                    }
                    PendingBackground.this.state.pendingColors.add(PendingBackground.this.state.last);
                    PendingBackground.this.widget.setBackground(PendingBackground.this.state.last);
                    PendingBackground.this.state.colorIndex = (PendingBackground.this.state.colorIndex + 1) % 8;
                }
            }
        }

        private int convertForGradient(int color, int gradient) {
            if (color < gradient) {
                return gradient;
            }
            if (color > 255 - gradient) {
                return 255 - gradient;
            }
            return color;
        }
    }
}

