/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.core.actions.ActionContext;
import com.pnfsoftware.jeb.core.actions.ActionOverridesData;
import com.pnfsoftware.jeb.core.output.text.ITextDocument;
import com.pnfsoftware.jeb.core.output.tree.ICodeNode;
import com.pnfsoftware.jeb.core.units.IInteractiveUnit;
import com.pnfsoftware.jeb.core.units.code.ICodeItem;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.actions.GraphicalActionExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.DataFrameView;
import com.pnfsoftware.jeb.rcpclient.parts.units.code.CodeFragmentUtil;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class OverridesView
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(OverridesView.class);
    RcpClientContext context;
    Display display;
    IInteractiveUnit sourceUnit;
    ITextDocument sourceDoc;
    long sourceItemId;
    String sourceAddress;
    Button wLockedSource;
    boolean lockedSource;
    Text wSource;
    DataFrame df1;
    DataFrameView dfv1;
    DataFrame df2;
    DataFrameView dfv2;
    Label wInfoLabel;

    public OverridesView(Composite parent, RcpClientContext context) {
        super(parent, 0);
        this.context = context;
        this.display = parent.getDisplay();
        UIUtil.setStandardLayout(this, 1, 0, 0);
        Composite c1 = UIUtil.createCompositeGrid(this, 0, 1, 6, 0);
        UIUtil.createLabel(c1, "Source: ");
        this.wSource = UIUtil.createTextboxInGrid(c1, 2056, 100, 1, true, false);
        this.createControlWidgets(c1);
        SashForm sash = new SashForm((Composite)this, 256);
        sash.setLayoutData((Object)UIUtil.createGridDataFill(true, true));
        this.df1 = new DataFrame("Children (overriding items)");
        this.dfv1 = new DataFrameView((Composite)sash, this.df1, false);
        this.dfv1.disableFilters();
        this.dfv1.setLayoutData(UIUtil.createGridDataFillHorizontally());
        this.dfv1.addDoubleClickListener(e -> {
            IStructuredSelection sel = (IStructuredSelection)this.dfv1.getSelection();
            this.navTo(sel);
        });
        this.df2 = new DataFrame("Parents (overridden items)");
        this.dfv2 = new DataFrameView((Composite)sash, this.df2, false);
        this.dfv2.disableFilters();
        this.dfv2.setLayoutData(UIUtil.createGridDataFillHorizontally());
        this.dfv2.addDoubleClickListener(e -> {
            IStructuredSelection sel = (IStructuredSelection)this.dfv2.getSelection();
            this.navTo(sel);
        });
        this.wSource.setFocus();
        this.wSource.forceFocus();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                OverridesView.this.resetSource();
            }
        });
    }

    void navTo(IStructuredSelection sel) {
        ICodeItem item = null;
        if (sel != null && sel.getFirstElement() != null) {
            Object o = sel.getFirstElement();
            if (o instanceof DataFrame.Row) {
                item = (ICodeItem)((DataFrame.Row)o).data;
            } else if (o instanceof ICodeNode) {
                item = ((ICodeNode)o).getObject();
            }
            if (item != null && this.context != null) {
                String address = item.getAddress();
                GraphicalActionExecutor.gotoAddress(this.context, this.sourceUnit, address);
            }
        }
    }

    void createControlWidgets(Composite parent) {
        this.wLockedSource = UIUtil.createCheckbox(parent, "Lock", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OverridesView.this.lockedSource = OverridesView.this.wLockedSource.getSelection();
            }
        });
        this.wLockedSource.setToolTipText("Tick to prevent auto-refresh (disable the widget)");
    }

    public boolean forceFocus() {
        return this.dfv1.forceFocus();
    }

    public boolean setFocus() {
        return this.dfv2.setFocus();
    }

    public void setLockedSource(boolean locked) {
        if (this.lockedSource == locked) {
            return;
        }
        this.lockedSource = locked;
        this.wLockedSource.setSelection(locked);
    }

    public boolean isLockedSource() {
        return this.lockedSource;
    }

    public void resetSource() {
        this.setSource(null, null, 0L, null);
    }

    public boolean setSource(IInteractiveUnit sourceUnit, ITextDocument sourceDoc, long sourceItemId, String sourceAddress) {
        if (this.lockedSource) {
            return false;
        }
        this.sourceUnit = sourceUnit;
        this.sourceDoc = sourceDoc;
        this.sourceItemId = sourceItemId;
        this.sourceAddress = sourceAddress;
        String s = "";
        if (sourceUnit != null && sourceItemId != 0L) {
            String addr = sourceUnit.getAddressOfItem(sourceItemId);
            s = addr != null ? addr : Strings.ff("Item: 0x%X", sourceItemId);
        } else if (sourceAddress != null) {
            s = sourceAddress;
        }
        this.wSource.setText(s);
        this.determineOverrides(s);
        return true;
    }

    private void determineOverrides(String addr) {
        this.df1.clear();
        this.df2.clear();
        if (this.sourceUnit != null && addr != null) {
            ActionContext info = new ActionContext(this.sourceUnit, 13, 0L, addr);
            ActionOverridesData data = new ActionOverridesData();
            if (info.getUnit().prepareExecution(info, data)) {
                List<ICodeItem> parents;
                List<ICodeItem> children = data.getChildren();
                if (children != null) {
                    for (ICodeItem m : children) {
                        Image img = CodeFragmentUtil.getCodeNodeIcon2(m, null);
                        this.df1.addRow(new DataFrame.Row(Arrays.asList(m.getSignature(true, false)), img, m));
                    }
                }
                if ((parents = data.getParents()) != null) {
                    for (ICodeItem m : parents) {
                        Image img = CodeFragmentUtil.getCodeNodeIcon2(m, null);
                        this.df2.addRow(new DataFrame.Row(Arrays.asList(m.getSignature(true, false)), img, m));
                    }
                }
            }
        }
        this.dfv1.refresh();
        this.dfv2.refresh();
    }
}

