/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.rcpclient.extensions.controls.AbstractFilteredView;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class FilteredTreeView
extends AbstractFilteredView<Tree, TreeColumn, TreeItem> {
    public FilteredTreeView(Composite parent, int style, String[] columnNames) {
        this(parent, style, columnNames, null);
    }

    public FilteredTreeView(Composite parent, int style, String[] columnNames, int[] columnWidths) {
        super(parent, style, columnNames, columnWidths, false, false);
    }

    public Tree getTree() {
        return (Tree)this.getCurrentElement();
    }

    @Override
    protected Tree buildElement(Composite parent, int style, boolean shadow) {
        return new Tree(parent, style);
    }

    @Override
    protected void buildColumn(Tree parent, String name, int initialWidth) {
        TreeColumn col = new TreeColumn(parent, 16384);
        col.setText(name);
        col.setResizable(true);
        if (initialWidth > 0) {
            col.setWidth(initialWidth);
        }
    }

    @Override
    void sortNativeColumn(Tree element, int dir, int columnIndex) {
        element.setSortDirection(dir);
        element.setSortColumn(columnIndex == -1 ? null : element.getColumn(columnIndex));
    }

    @Override
    public int getSortIndex() {
        TreeColumn tc = ((Tree)this.getMainElement()).getSortColumn();
        for (int i = 0; i < ((Tree)this.getMainElement()).getColumnCount(); ++i) {
            if (((Tree)this.getMainElement()).getColumn(i) != tc) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getSortDirection() {
        return ((Tree)this.getMainElement()).getSortDirection();
    }

    @Override
    public void addNativeSelectionListener(Tree element, SelectionListener listener) {
        element.addSelectionListener(listener);
    }

    @Override
    void removeNativeSelectionListener(Tree element, SelectionListener listener) {
        element.removeSelectionListener(listener);
    }

    @Override
    public void addNativeColumnSelectionListener(Tree element, int colIndex, SelectionListener columnSelectionListener) {
        element.getColumn(colIndex).addSelectionListener(columnSelectionListener);
    }

    @Override
    public int getSelectionIndex() {
        if (this.getTree().getSelectionCount() == 0) {
            return -1;
        }
        AtomicInteger counter = new AtomicInteger(0);
        boolean found = this.getIndexOfItem(this.getTree().getItems(), this.getTree().getSelection()[0], counter);
        if (found) {
            return counter.get();
        }
        return -1;
    }

    private boolean getIndexOfItem(TreeItem[] fullTree, TreeItem toFind, AtomicInteger currentIndex) {
        for (TreeItem item : fullTree) {
            if (FilteredTreeView.isBlankItem(item)) continue;
            if (item.equals(toFind)) {
                return true;
            }
            currentIndex.incrementAndGet();
            boolean found = this.getIndexOfItem(item.getItems(), toFind, currentIndex);
            if (!found) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSelection(int index) {
    }

    public TreeItem[] getTreeItems() {
        return this.getTree().getItems();
    }

    @Override
    public int getItemCount() {
        return this.getItemCount(this.getTree().getItems());
    }

    @Override
    public int getColumnCount() {
        return ((Tree)this.getCurrentElement()).getColumnCount();
    }

    @Override
    public int getColumnWidth(int index) {
        return ((Tree)this.getCurrentElement()).getColumn(index).getWidth();
    }

    @Override
    public void setColumnWidth(int index, int width) {
        ((Tree)this.getCurrentElement()).getColumn(index).setWidth(width);
    }

    @Override
    TreeColumn getColumn(Tree element, int index) {
        return element.getColumn(index);
    }

    TreeItem[] getMainItems() {
        return ((Tree)this.getMainElement()).getItems();
    }

    @Override
    void removeAll(Tree element) {
        element.removeAll();
    }

    @Override
    String getText(TreeItem item, int index) {
        return item.getText(index);
    }

    @Override
    TreeItem createItem(Tree parent, TreeItem source, String[] rowElements) {
        TreeItem item = new TreeItem(parent, 0);
        item.setData(source.getData());
        item.setText(rowElements);
        return item;
    }

    @Override
    void duplicateWidth(TreeColumn source, TreeColumn destination) {
        destination.setWidth(source.getWidth());
    }

    private int getItemCount(TreeItem[] items) {
        int childrenCount = 0;
        if (items == null || items.length == 0) {
            return childrenCount;
        }
        for (TreeItem item : items) {
            if (FilteredTreeView.isBlankItem(item)) continue;
            childrenCount += 1 + this.getItemCount(item.getItems());
        }
        return childrenCount;
    }

    private static boolean isBlankItem(TreeItem item) {
        return (item.getItems() == null || item.getItems().length == 0) && item.getData() == null && item.getText().isEmpty();
    }
}

