/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.rcpclient.extensions.controls.AbstractFilteredView;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.ITableEventListener;
import com.pnfsoftware.jeb.rcpclient.iviewers.table.TableUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FilteredTableView
extends AbstractFilteredView<Table, TableColumn, TableItem> {
    private static final int MAX_ROW_TO_AUTOPACK = 1000;
    private static final int VIRTUAL_MAX_ROW_LINES_TO_CHECK = 100;
    private List<ITableEventListener> listeners = new ArrayList<ITableEventListener>();
    private int[] defaultColumnWidth;
    private PaintListener repaintColumnListener;

    public FilteredTableView(Composite parent, int style, String[] columnNames) {
        this(parent, 2 | style, columnNames, null, false);
    }

    public FilteredTableView(Composite parent, int style, String[] columnNames, int[] columnWidths, boolean displayIndex) {
        super(parent, style, columnNames, columnWidths, displayIndex, (style & 0x20) == 0);
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!(e.item instanceof TableItem)) {
                    return;
                }
                Object object = e.item.getData();
                boolean selected = ((Table)FilteredTableView.this.getCurrentElement()).getSelectionCount() > 0;
                boolean checked = ((TableItem)e.item).getChecked();
                for (ITableEventListener listener : FilteredTableView.this.listeners) {
                    listener.onTableEvent(object, selected, checked);
                }
            }
        });
    }

    @Override
    protected Table buildElement(Composite parent, int style, boolean shadow) {
        Table table = new Table(parent, 0x10000 | style);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        return table;
    }

    @Override
    protected void buildColumn(Table parent, String name, int initialWidth) {
        TableColumn tc = new TableColumn(parent, 16384);
        tc.setText(name);
        tc.setResizable(true);
        tc.setMoveable(true);
        if (initialWidth > 0) {
            tc.setWidth(initialWidth);
        }
    }

    public Table getTable() {
        return (Table)this.getCurrentElement();
    }

    public TableItem[] getActiveSelections() {
        return ((Table)this.getCurrentElement()).getSelection();
    }

    public TableItem getActiveSelection() {
        TableItem[] s = ((Table)this.getCurrentElement()).getSelection();
        return s != null && s.length == 1 ? s[0] : null;
    }

    public TableItem[] getTableItems() {
        return ((Table)this.getCurrentElement()).getItems();
    }

    @Override
    public int getSelectionIndex() {
        return ((Table)this.getCurrentElement()).getSelectionIndex();
    }

    @Override
    public void setSelection(int index) {
        ((Table)this.getCurrentElement()).setSelection(index);
        ((Table)this.getCurrentElement()).showSelection();
    }

    @Override
    public int getItemCount() {
        return ((Table)this.getCurrentElement()).getItemCount();
    }

    @Override
    public int getColumnCount() {
        return ((Table)this.getCurrentElement()).getColumnCount();
    }

    @Override
    public int getColumnWidth(int index) {
        return ((Table)this.getCurrentElement()).getColumn(index).getWidth();
    }

    @Override
    public void setColumnWidth(int index, int width) {
        ((Table)this.getCurrentElement()).getColumn(index).setWidth(width);
    }

    @Override
    TableColumn getColumn(Table element, int index) {
        return element.getColumn(index);
    }

    TableItem[] getMainItems() {
        return ((Table)this.getMainElement()).getItems();
    }

    @Override
    void removeAll(Table element) {
        element.removeAll();
    }

    @Override
    String getText(TableItem item, int index) {
        return item.getText(index);
    }

    @Override
    TableItem createItem(Table parent, TableItem source, String[] rowElements) {
        TableItem item = new TableItem(parent, 0);
        item.setData(source.getData());
        item.setText(rowElements);
        return item;
    }

    @Override
    void duplicateWidth(TableColumn source, TableColumn destination) {
        destination.setWidth(source.getWidth());
    }

    public void addTableEventListener(ITableEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeTableEventListener(ITableEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addNativeSelectionListener(Table element, SelectionListener listener) {
        element.addSelectionListener(listener);
    }

    @Override
    void removeNativeSelectionListener(Table element, SelectionListener listener) {
        element.removeSelectionListener(listener);
    }

    @Override
    public void addNativeColumnSelectionListener(Table element, int colIndex, SelectionListener columnSelectionListener) {
        element.getColumn(colIndex).addSelectionListener(columnSelectionListener);
    }

    @Override
    void sortNativeColumn(Table element, int dir, int columnIndex) {
        element.setSortDirection(dir);
        element.setSortColumn(columnIndex == -1 ? null : element.getColumn(columnIndex));
    }

    @Override
    public int getSortIndex() {
        TableColumn tc = ((Table)this.getMainElement()).getSortColumn();
        for (int i = 0; i < ((Table)this.getMainElement()).getColumnCount(); ++i) {
            if (((Table)this.getMainElement()).getColumn(i) != tc) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getSortDirection() {
        return ((Table)this.getMainElement()).getSortDirection();
    }

    public void pack(boolean changed) {
        super.pack(changed);
        if (this.getItemCount() < 1000 && (((Table)this.getMainElement()).getStyle() & 0x10000000) == 0) {
            this.packDefault();
        } else {
            Table t = (Table)this.getMainElement();
            int cnt = t.getColumns().length;
            if (cnt > 1) {
                this.defaultColumnWidth = new int[cnt];
                for (int w = 0; w < cnt; ++w) {
                    this.defaultColumnWidth[w] = t.getColumns()[w].getWidth();
                }
                this.repaintColumnListener = new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        if (FilteredTableView.this.defaultColumnWidth != null) {
                            FilteredTableView.this.packVirtual();
                            FilteredTableView.this.defaultColumnWidth = null;
                            ((Table)FilteredTableView.this.getMainElement()).removePaintListener(FilteredTableView.this.repaintColumnListener);
                        }
                    }
                };
                ((Table)this.getMainElement()).addPaintListener(this.repaintColumnListener);
            }
        }
    }

    private void packDefault() {
        int cnt = ((Table)this.getMainElement()).getColumns().length;
        int cx = ((Table)this.getMainElement()).getSize().x;
        if (cnt <= 1) {
            if (cnt == 1) {
                ((Table)this.getMainElement()).getColumns()[0].setWidth(cx);
            }
            return;
        }
        for (TableColumn tc : ((Table)this.getMainElement()).getColumns()) {
            tc.pack();
        }
    }

    private void packVirtual() {
        int w;
        if (this.defaultColumnWidth == null) {
            return;
        }
        Table t = (Table)this.getMainElement();
        int cnt = t.getColumns().length;
        int[] expectedColumnWidth = new int[cnt - 1];
        for (int line = 0; line < 100 && line < t.getItemCount(); ++line) {
            for (w = 0; w < cnt - 1; ++w) {
                if (Strings.isBlank(t.getItem(line).getText(w))) continue;
                Text textName = new Text((Composite)this, 2048);
                textName.setText(t.getItem(line).getText(w));
                Point size = textName.computeSize(-1, -1);
                expectedColumnWidth[w] = Math.max(size.x, expectedColumnWidth[w]);
                textName.dispose();
            }
        }
        int[] width = new int[cnt];
        for (w = 0; w < cnt - 1; ++w) {
            width[w] = Math.max(this.defaultColumnWidth[w], expectedColumnWidth[w]);
        }
        for (w = 0; w < cnt - 1; ++w) {
            t.getColumn(w).setWidth(width[w]);
        }
    }

    private void packVirtualFast() {
        int w;
        if (this.defaultColumnWidth == null) {
            return;
        }
        Table t = (Table)this.getMainElement();
        int cnt = t.getColumns().length;
        int[] expectedColumnWidth = new int[cnt];
        for (int line = 0; line < 100 && line < t.getItemCount(); ++line) {
            for (w = 0; w < cnt; ++w) {
                String[] inner;
                if (Strings.isBlank(t.getItem(line).getText(w))) continue;
                String str = Strings.safe(t.getItem(line).getText(w));
                for (String in : inner = str.split("\n")) {
                    expectedColumnWidth[w] = Math.max(in.length(), expectedColumnWidth[w]);
                }
            }
        }
        int excedent = 0;
        for (w = 0; w < cnt; ++w) {
            excedent = excedent + t.getColumns()[w].getWidth() - this.defaultColumnWidth[w];
        }
        if (t.getVerticalBar() != null) {
            excedent = excedent - t.getVerticalBar().getSize().x - 10;
        }
        if (excedent > 0) {
            int w2;
            int maxItemWidthPerLine = 0;
            for (int w3 = 0; w3 < cnt; ++w3) {
                maxItemWidthPerLine += expectedColumnWidth[w3];
            }
            int[] width = new int[cnt];
            for (w2 = 0; w2 < cnt - 1; ++w2) {
                int maxAllowedExcedentPerCell = Math.floorDiv(expectedColumnWidth[w2] * excedent, maxItemWidthPerLine);
                width[w2] = this.defaultColumnWidth[w2] + maxAllowedExcedentPerCell;
            }
            for (w2 = 0; w2 < cnt - 1; ++w2) {
                t.getColumn(w2).setWidth(width[w2]);
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        int minHeight = this.getTable().getItemHeight() + this.getTable().getHeaderHeight();
        Rectangle trim = this.getTable().computeTrim(0, 0, 0, minHeight);
        minHeight = trim.height;
        if ((minHeight += this.computeInnerHeight(wHint, hHint, changed)) > size.y) {
            size.y = minHeight;
        }
        return size;
    }

    public String exportToString() {
        return TableUtil.buildCsv((Table)this.getCurrentElement());
    }
}

