/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.core.output.ItemClassIdentifiers;
import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.IFilterText;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.PendingBackground;
import com.pnfsoftware.jeb.rcpclient.extensions.themes.ThemeManager;
import com.pnfsoftware.jeb.rcpclient.iviewers.Style;
import com.pnfsoftware.jeb.rcpclient.iviewers.StyleManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FilterText
extends Composite
implements IFilterText {
    private Boolean status;
    private Text filterText;
    private PendingBackground pending;
    private List<Listener> applyFilterListeners = new ArrayList<Listener>();

    public FilterText(Composite parent) {
        super(parent, 0);
        UIUtil.setStandardLayout(this, 1, 0);
        this.filterText = new Text((Composite)this, 2948);
        this.filterText.setMessage(S.s(344));
        this.filterText.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                FilterText.this.setStatus(FilterText.this.status);
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.keyCode == 8) {
                    FilterText.this.filterText.setText("");
                    e.doit = false;
                }
                if (e.character != '\r') {
                    FilterText.this.setStatus(null);
                    return;
                }
                FilterText.this.submitText();
            }
        });
        this.pending = new PendingBackground((Control)this.filterText);
    }

    @Override
    public void setText(String s) {
        this.filterText.setText(s);
    }

    @Override
    public void submitText(String s) {
        this.setText(s);
        this.submitText();
    }

    private void submitText() {
        String s = this.getText();
        if (s == null || s.length() == 0) {
            this.setStatus(null);
        } else {
            this.setStatus(Boolean.TRUE);
        }
        for (Listener applyFilter : this.applyFilterListeners) {
            Event event = new Event();
            event.widget = this;
            event.data = this.getText();
            applyFilter.handleEvent(event);
        }
    }

    @Override
    public String getText() {
        return this.filterText.getText();
    }

    public void selectAll() {
        this.filterText.selectAll();
    }

    public void addFocusListener(FocusListener listener) {
        this.filterText.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.filterText.removeFocusListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.filterText.addKeyListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.filterText.removeKeyListener(listener);
    }

    @Override
    public void addApplyFilterListener(Listener listener) {
        this.applyFilterListeners.add(listener);
    }

    public void removeApplyFilterListener(Listener listener) {
        this.applyFilterListeners.remove(listener);
    }

    @Override
    public void setStatus(Boolean status) {
        this.status = status;
        ThemeManager.getInstance().processControlForcibly((Widget)this.filterText);
        this.refreshStatus();
    }

    public void refreshStatus() {
        if (this.status != null && RcpClientContext.getInstance() != null) {
            ItemClassIdentifiers styleid;
            StyleManager styleman = RcpClientContext.getInstance().getStyleManager();
            Style style = styleman.getNormalStyle(styleid = this.status != false ? ItemClassIdentifiers.RESULT_SUCCESS : ItemClassIdentifiers.RESULT_ERROR);
            if (style != null && style.getBackgroungColor() != null) {
                PendingBackground pendingBackground = this.pending;
                synchronized (pendingBackground) {
                    this.filterText.setBackground(style.getBackgroungColor());
                }
            }
            if (style != null && style.getColor() != null) {
                this.filterText.setForeground(style.getColor());
            }
        }
    }

    @Override
    public Boolean getStatus() {
        return this.status;
    }

    public boolean setFocus() {
        return this.filterText.setFocus();
    }

    @Override
    public void setPending(boolean pend) {
        if (pend) {
            this.pending.activate();
        } else {
            this.pending.deactivate();
        }
    }

    public static boolean isSelected() {
        Control c = Display.getCurrent().getFocusControl();
        return c != null && c.getParent() instanceof FilterText;
    }
}

