/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class EditableList
extends Composite {
    private Label l;
    private Table table;
    private Composite buttons;
    Map<Control, Boolean> compositeEnabledOnSelection = new WeakHashMap<Control, Boolean>();

    public EditableList(Composite parent, int style, String label, String[] values) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        Composite ph = new Composite((Composite)this, 0);
        ph.setLayout((Layout)new GridLayout(2, false));
        this.l = UIUtil.createLabel(ph, label);
        this.l.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2, true, false));
        this.table = new Table(ph, 0x800 | style);
        GridData d = new GridData(-1, 100);
        d.horizontalAlignment = 4;
        d.grabExcessHorizontalSpace = true;
        this.table.setLayoutData((Object)d);
        this.resetItems(values);
        this.buttons = new Composite(ph, 0);
        this.buttons.setLayout((Layout)new GridLayout(1, true));
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = EditableList.this.getSelectionIndices() != null && EditableList.this.getSelectionIndices().length != 0;
                for (Control c : EditableList.this.compositeEnabledOnSelection.keySet()) {
                    c.setEnabled(enabled);
                }
            }
        });
    }

    public void addButton(String label, SelectionListener listener, boolean enableOnSelection) {
        Button b = UIUtil.createPushbox(this.buttons, label, listener);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        b.setLayoutData((Object)data);
        if (enableOnSelection) {
            this.compositeEnabledOnSelection.put((Control)b, Boolean.TRUE);
            b.setEnabled(false);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.l.setEnabled(enabled);
        this.table.setEnabled(enabled);
        for (Control button : this.buttons.getChildren()) {
            button.setEnabled(enabled);
        }
    }

    public Table getTable() {
        return this.table;
    }

    public int[] getSelectionIndices() {
        return this.table.getSelectionIndices();
    }

    public TableItem[] getSelection() {
        return this.table.getSelection();
    }

    public void resetItems(String[] values) {
        int selected = this.table.getSelectionIndex();
        this.table.removeAll();
        for (String e : values) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(e);
        }
        this.table.setSelection(selected);
    }

    public void resetItems(List<ICheckable> values) {
        int selected = this.table.getSelectionIndex();
        this.table.removeAll();
        for (ICheckable e : values) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(e.getText());
            item.setChecked(e.isChecked());
        }
        this.table.setSelection(selected);
    }

    public static interface ICheckable {
        public String getText();

        public boolean isChecked();
    }

    public static class SimpleCheckable
    implements ICheckable {
        private String text;
        private boolean checked;

        public SimpleCheckable(String text, boolean checked) {
            this.text = text;
            this.checked = checked;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public boolean isChecked() {
            return this.checked;
        }
    }
}

