/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.client.api.IOperable;
import com.pnfsoftware.jeb.client.api.OperationRequest;
import com.pnfsoftware.jeb.rcpclient.extensions.ContextMenuFilter;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilteredTableView;
import com.pnfsoftware.jeb.rcpclient.extensions.export.ExportUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.export.IExportableData;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.DefaultCellLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.FilteredTableViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredLabelProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredStructuredViewer;
import com.pnfsoftware.jeb.rcpclient.extensions.viewers.IFilteredTableContentProvider;
import com.pnfsoftware.jeb.rcpclient.iviewers.table.TableUtil;
import com.pnfsoftware.jeb.rcpclient.operations.AbstractOperation;
import com.pnfsoftware.jeb.rcpclient.operations.ContextMenu;
import com.pnfsoftware.jeb.rcpclient.util.DataFrame;
import com.pnfsoftware.jeb.rcpclient.util.regex.PatternFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class DataFrameView
extends FilteredTableView {
    private boolean displayIndex;
    private DataFrame df;
    private FilteredTableViewer filteredViewer;
    private List<ContextMenu> ctxMenus;
    private IFilteredTableContentProvider provider;
    private DataFrameLabelProvider labelProvider;

    public DataFrameView(Composite parent, DataFrame df, boolean displayIndex) {
        this(parent, df, displayIndex, true);
    }

    public DataFrameView(Composite parent, DataFrame df, boolean displayIndex, boolean multiselect) {
        super(parent, (multiselect ? 2 : 0) | 0x200 | 0x100 | 0x80, df.getColumnLabels().toArray(new String[df.getColumnLabels().size()]), null, displayIndex);
        this.df = df;
        this.displayIndex = displayIndex;
        String[] titleColumns = df.getColumnLabels().toArray(new String[df.getColumnLabels().size()]);
        this.provider = new DataFrameContentProvider();
        this.labelProvider = new DataFrameLabelProvider();
        this.filteredViewer = new FilteredTableViewer(this);
        this.filteredViewer.setContentProvider(this.provider);
        this.filteredViewer.setLabelProvider(this.labelProvider);
        if (displayIndex) {
            String[] titleColumnsWithIndex = new String[titleColumns.length + 1];
            System.arraycopy(titleColumns, 0, titleColumnsWithIndex, 1, titleColumns.length);
            titleColumns = titleColumnsWithIndex;
        }
        this.filteredViewer.setFilterPatternFactory(new PatternFilter("", titleColumns));
        this.ctxMenus = this.filteredViewer.addContextMenu(this.labelProvider, titleColumns, null, null);
        this.filteredViewer.setInput(df, true);
    }

    public void disableFilters() {
        this.setFilterVisibility(false);
        this.setDisabledFilterToggle(true);
        for (ContextMenu ctxMenu : this.ctxMenus) {
            ctxMenu.clearContextMenu();
        }
    }

    public void refresh() {
        this.filteredViewer.refresh();
    }

    public IFilteredStructuredViewer getViewer() {
        return this.filteredViewer;
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.filteredViewer.addDoubleClickListener(listener);
    }

    public ISelection getSelection() {
        return this.filteredViewer.getSelection();
    }

    public int getSelectedRow() {
        IStructuredSelection sel;
        Object element;
        ISelection selection = this.filteredViewer.getSelection();
        if (selection instanceof IStructuredSelection && (element = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof DataFrame.Row) {
            DataFrame.Row row = (DataFrame.Row)element;
            return row.index;
        }
        return -1;
    }

    public List<Integer> getSelectedRows() {
        ArrayList<Integer> selectedIndexes = new ArrayList<Integer>();
        ISelection selection = this.filteredViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object element : sel) {
                if (!(element instanceof DataFrame.Row)) continue;
                DataFrame.Row row = (DataFrame.Row)element;
                selectedIndexes.add(row.index);
            }
        }
        return selectedIndexes;
    }

    public List<ContextMenu> getContextMenus() {
        return this.ctxMenus;
    }

    public void forceFilter(String filter) {
        this.getFilterText().setText(filter);
        this.filteredViewer.applyFilterText(filter);
    }

    public IFilteredTableContentProvider getProvider() {
        return this.provider;
    }

    public IFilteredLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public String exportToString() {
        return TableUtil.buildCsv((Table)this.getCurrentElement());
    }

    public void addExtraEntriesToContextMenu() {
        for (ContextMenu ctxMenu : this.ctxMenus) {
            ContextMenuFilter.addCopyEntry(ctxMenu, this.getMainElement(), new CopyAction());
        }
    }

    public void addExtraEntryToContextMenu(AbstractOperation operation) {
        for (ContextMenu ctxMenu : this.ctxMenus) {
            ContextMenuFilter.addEntry(ctxMenu, this.getMainElement(), operation);
        }
    }

    class DataFrameContentProvider
    implements IFilteredTableContentProvider {
        DataFrameContentProvider() {
        }

        @Override
        public Object[] getElements(Object inputElement) {
            return DataFrameView.this.df.getRows().toArray();
        }

        @Override
        public boolean isChecked(Object row) {
            return false;
        }
    }

    class DataFrameLabelProvider
    extends DefaultCellLabelProvider
    implements IExportableData {
        DataFrameLabelProvider() {
        }

        @Override
        public void update(ViewerCell cell) {
            Image img;
            if (cell.getColumnIndex() == 0 && (img = ((DataFrame.Row)cell.getElement()).getImage()) != null) {
                cell.setImage(img);
            }
            super.update(cell);
        }

        @Override
        public int getColumns(Object row) {
            return DataFrameView.this.df.getColumnLabels().size() + (DataFrameView.this.displayIndex ? 1 : 0);
        }

        @Override
        public String getStringAt(Object element, int key) {
            String label;
            int index = key;
            if (DataFrameView.this.displayIndex) {
                if (key == 0) {
                    return Integer.toString(((DataFrame.Row)element).index);
                }
                --index;
            }
            if ((label = DataFrameView.this.df.getLabelFor((DataFrame.Row)element, index)) == null) {
                Object o = ((DataFrame.Row)element).get(index);
                label = o == null ? null : o.toString();
            }
            return label;
        }

        @Override
        public String exportElementToString(Object obj) {
            if (obj instanceof DataFrame.Row) {
                Object[] row = ((DataFrame.Row)obj).elements.toArray();
                return ExportUtil.buildCsvLine(this, obj, DataFrameView.this.displayIndex ? row.length + 1 : row.length);
            }
            return null;
        }
    }

    private class CopyAction
    implements IOperable {
        @Override
        public boolean verifyOperation(OperationRequest req) {
            switch (req.getOperation()) {
                case COPY: {
                    return DataFrameView.this.getSelectedRow() >= 0;
                }
            }
            return false;
        }

        @Override
        public boolean doOperation(OperationRequest req) {
            switch (req.getOperation()) {
                case COPY: {
                    IStructuredSelection selection = (IStructuredSelection)DataFrameView.this.filteredViewer.getSelection();
                    if (DataFrameView.this.filteredViewer.getLabelProvider() instanceof IExportableData) {
                        ExportUtil.copyLinesToClipboard((IExportableData)((Object)DataFrameView.this.filteredViewer.getLabelProvider()), selection.toList());
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }
    }
}

