/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.rcpclient.RcpClientContext;
import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.binding.KeyShortcutsManager;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.IContentDescriptionProvider;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.autocomplete2.AbstractCAProcessor;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.autocomplete2.AbstractCL;
import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.base.StarMatcher;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ContentAssistedText2
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(ContentAssistedText2.class);
    public static String shortcut = "CTRL+SPACE";
    private ContentAssistant ca;
    private KeyStroke actKeyStroke;
    private StyledText wtext;
    private IContentDescriptionProvider contentDescriptionProvider;
    boolean showingProposals;
    private TextHistory history;
    private List<String> histContents;
    private Collection<String> extras;
    boolean pureSearch;
    private List<ICompletionProposal> currentProposals;
    boolean caseSensitive;

    public ContentAssistedText2(Composite parent, int styles, String labelText, TextHistory _history, boolean displayHelp) {
        this(parent, styles, labelText, _history, displayHelp, displayHelp);
    }

    public ContentAssistedText2(Composite parent, int styles, String labelText, TextHistory _history, boolean displayHelpDecorator, boolean displayHelpString) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.history = _history;
        Composite ph = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        ph.setLayout((Layout)layout);
        if (labelText != null) {
            Label label = new Label(ph, 0);
            label.setText(Strings.safe(labelText));
        }
        Document doc = new Document();
        styles &= 0x800;
        SourceViewer v = new SourceViewer(ph, null, styles |= 4);
        v.setDocument(doc);
        this.wtext = v.getTextWidget();
        UIUtil.addSelectAllSupport(this.wtext);
        this.wtext.setLayoutData((Object)UIUtil.createGridDataForText((Control)this.wtext, 30, 1, true));
        GridData ldata = (GridData)this.wtext.getLayoutData();
        ldata.horizontalIndent = 8;
        ldata.grabExcessHorizontalSpace = true;
        ldata.horizontalAlignment = 4;
        this.actKeyStroke = KeyShortcutsManager.parseShortcutToKeystroke(shortcut);
        if (this.actKeyStroke == null) {
            this.actKeyStroke = KeyStroke.getInstance(262144, 32);
        }
        String msg = Strings.ff("Hit %s or start typing to trigger auto-complete and browse your history", this.actKeyStroke);
        if (displayHelpString) {
            Label hint2 = new Label(ph, 64);
            hint2.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2, true, false));
            hint2.setText("(" + msg + ")");
        }
        if (displayHelpDecorator) {
            ControlDecoration deco = new ControlDecoration((Control)this.wtext, 16512);
            Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
            String msg2 = msg + ".\n";
            msg2 = msg2 + "The wildcard '*' character is supported.";
            deco.setDescriptionText(msg2);
            deco.setImage(image);
            deco.setShowOnlyOnFocus(true);
        }
        this.ca = this.createCA(v);
        this.ca.install(v);
        this.wtext.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & SWT.MODIFIER_MASK) == 0) {
                    return;
                }
                KeyStroke ks = KeyStroke.getInstance(e.stateMask & SWT.MODIFIER_MASK, e.keyCode);
                if (ks.equals(ContentAssistedText2.this.actKeyStroke)) {
                    ContentAssistedText2.this.ca.showPossibleCompletions();
                }
            }
        });
        this.wtext.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 4) {
                    e.doit = !ContentAssistedText2.this.showingProposals;
                }
            }
        });
        this.wtext.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                char cfr_ignored_0 = e.character;
            }
        });
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setPureSearch(boolean pureSearch) {
        this.pureSearch = pureSearch;
    }

    public boolean isPureSearch() {
        return this.pureSearch;
    }

    public void confirm() {
        this.record();
    }

    private void record() {
        String str;
        if (this.history != null && !Strings.isBlank(str = this.wtext.getText())) {
            this.history.record(str);
        }
    }

    public void setContentDescriptionProvider(IContentDescriptionProvider contentDescriptionProvider) {
        this.contentDescriptionProvider = contentDescriptionProvider;
    }

    public void setExtras(Collection<String> extras) {
        this.extras = extras;
    }

    public void setHistory(TextHistory history) {
        this.history = history;
        this.histContents = null;
    }

    private List<String> getHistoryContents() {
        if (this.histContents == null) {
            this.histContents = this.history.getAll();
        }
        return this.histContents;
    }

    public StyledText getWidget() {
        return this.wtext;
    }

    public boolean isFocusControl() {
        return this.wtext.isFocusControl();
    }

    public String getText() {
        return this.wtext.getText();
    }

    public void setText(String content) {
        this.wtext.setText(content);
    }

    public void selectAll() {
        this.wtext.selectAll();
    }

    ContentAssistant createCA(ITextViewer v) {
        ContentAssistant ca = new ContentAssistant();
        ca.addContentAssistProcessor(new CAP(), "__dftl_partition_content_type");
        ca.enableAutoInsert(false);
        ca.enableAutoActivation(true);
        ca.enableCompletionProposalTriggerChars(true);
        ca.setAutoActivationDelay(100);
        ca.enableColoredLabels(true);
        ca.setStatusLineVisible(true);
        ca.addCompletionListener(new AbstractCL(){

            @Override
            public void assistSessionStarted(ContentAssistEvent event) {
                ContentAssistedText2.this.showingProposals = true;
            }

            @Override
            public void assistSessionEnded(ContentAssistEvent event) {
                ContentAssistedText2.this.showingProposals = false;
            }
        });
        ca.setInformationControlCreator(new IInformationControlCreator(){

            @Override
            public IInformationControl createInformationControl(Shell parent) {
                if (UIUtil.canUseBrowser((Composite)ContentAssistedText2.this.getShell()) && BrowserInformationControl.isAvailable((Composite)ContentAssistedText2.this.getShell()) && Platform.isRunning()) {
                    return new BrowserInfoControl(ContentAssistedText2.this.getShell());
                }
                return new BasicHtmlInfoControl(ContentAssistedText2.this.getShell());
            }
        });
        return ca;
    }

    public ContentAssistant getContentAssistant() {
        return this.ca;
    }

    public boolean isShowingProposals() {
        return this.showingProposals;
    }

    private class CAP
    extends AbstractCAProcessor {
        private CAP() {
        }

        @Override
        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            ArrayList<ICompletionProposal> r = new ArrayList<ICompletionProposal>();
            try {
                String input = viewer.getDocument().get();
                StarMatcher m = new StarMatcher(input, !ContentAssistedText2.this.caseSensitive, true);
                if (ContentAssistedText2.this.history != null) {
                    for (String s : ContentAssistedText2.this.getHistoryContents()) {
                        if (!m.matches(s)) continue;
                        IContextInformation ci = null;
                        r.add(0, new CP(s, 0, input.length(), s.length(), null, null, ci, null));
                    }
                }
                if (ContentAssistedText2.this.extras != null) {
                    for (String s : ContentAssistedText2.this.extras) {
                        if (!m.matches(s)) continue;
                        r.add(new CP(s, 0, input.length(), s.length()));
                    }
                }
                if (!ContentAssistedText2.this.pureSearch) {
                    r.add(0, new CP("", 0, 0, input.length()));
                }
                ContentAssistedText2.this.currentProposals = r;
            }
            catch (Exception e) {
                RcpClientContext.getInstance().getErrorHandler().processThrowableSilent(e);
                logger.error("An error occurred when retrieving the completion proposals", new Object[0]);
            }
            return r.toArray(new ICompletionProposal[r.size()]);
        }
    }

    private class CP
    implements ICompletionProposal {
        private String fDisplayString;
        private String fReplacementString;
        private int fReplacementOffset;
        private int fReplacementLength;
        private int fCursorPosition;
        private Image fImage;
        private IContextInformation fContextInformation;
        private String fAdditionalProposalInfo;

        public CP(String replacementString, int replacementOffset, int replacementLength, int cursorPosition) {
            this(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null);
        }

        public CP(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
            Assert.isNotNull(replacementString);
            Assert.isTrue(replacementOffset >= 0);
            Assert.isTrue(replacementLength >= 0);
            Assert.isTrue(cursorPosition >= 0);
            this.fReplacementString = replacementString;
            this.fReplacementOffset = replacementOffset;
            this.fReplacementLength = replacementLength;
            this.fCursorPosition = cursorPosition;
            this.fImage = image;
            this.fDisplayString = displayString;
            this.fContextInformation = contextInformation;
            this.fAdditionalProposalInfo = additionalProposalInfo;
        }

        @Override
        public void apply(IDocument document) {
            try {
                document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            }
            catch (BadLocationException badLocationException) {}
        }

        @Override
        public Point getSelection(IDocument document) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }

        @Override
        public IContextInformation getContextInformation() {
            return this.fContextInformation;
        }

        @Override
        public Image getImage() {
            return this.fImage;
        }

        @Override
        public String getDisplayString() {
            if (this.fDisplayString != null) {
                return this.fDisplayString;
            }
            return this.fReplacementString;
        }

        @Override
        public String getAdditionalProposalInfo() {
            if (this.fAdditionalProposalInfo != null) {
                return this.fAdditionalProposalInfo;
            }
            if (ContentAssistedText2.this.contentDescriptionProvider == null) {
                return null;
            }
            Object s = ContentAssistedText2.this.contentDescriptionProvider.generate(this.fReplacementString);
            if (s == null) {
                return null;
            }
            s = "<pre>" + (String)s + "</pre>";
            return s;
        }
    }

    private static class BrowserInfoControl
    extends BrowserInformationControl {
        public BrowserInfoControl(Shell parent) {
            super(parent, UIUtil.getCodeFont().getFontData()[0].getName(), true);
        }

        @Override
        public IInformationControlCreator getInformationPresenterControlCreator() {
            return parent -> new BrowserInfoControl(parent);
        }
    }

    private static class BasicHtmlInfoControl
    extends DefaultInformationControl {
        public BasicHtmlInfoControl(Shell parent) {
            super(parent, true);
            this.setBackgroundColor(null);
        }

        @Override
        protected void createContent(Composite parent) {
            super.createContent(parent);
            parent.getChildren()[0].setFont(UIUtil.getCodeFont());
        }

        @Override
        public IInformationControlCreator getInformationPresenterControlCreator() {
            return parent -> new BasicHtmlInfoControl(parent);
        }
    }
}

