/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.binding.KeyShortcutsManager;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.IContentDescriptionProvider;
import com.pnfsoftware.jeb.rcpclient.util.TextHistory;
import com.pnfsoftware.jeb.util.base.StarMatcher;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import com.pnfsoftware.jeb.util.reflect.ReflectionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ContentAssistedText
extends Composite {
    private static final ILogger logger = GlobalLog.getLogger(ContentAssistedText.class);
    public static String shortcut = "CTRL+SPACE";
    private Text wtext;
    private ContentProposalAdapter cpa;
    private IContentDescriptionProvider contentDescriptionProvider;
    private TextHistory history;
    private List<String> histContents;
    private Collection<String> extras;
    boolean pureSearch;
    private boolean internalProposalTableAccessFailed;
    private List<IContentProposal> currentProposals;
    private boolean customizedInfoPop;

    public ContentAssistedText(Composite parent, int styles, String labelText, TextHistory _history, boolean displayHelp) {
        this(parent, styles, labelText, _history, displayHelp, displayHelp);
    }

    public ContentAssistedText(Composite parent, int styles, String labelText, TextHistory _history, boolean displayHelpDecorator, boolean displayHelpString) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.history = _history;
        Composite ph = new Composite((Composite)this, 0);
        ph.setLayout((Layout)new GridLayout(2, false));
        if (labelText != null) {
            Label label = new Label(ph, 0);
            label.setText(Strings.safe(labelText));
        }
        styles &= 0x800;
        this.wtext = UIUtil.createTextboxInGrid(ph, styles |= 4, 30, 1);
        GridData ldata = (GridData)this.wtext.getLayoutData();
        ldata.horizontalIndent = 8;
        ldata.grabExcessHorizontalSpace = true;
        ldata.horizontalAlignment = 4;
        KeyStroke keyStroke = KeyShortcutsManager.parseShortcutToKeystroke(shortcut);
        if (keyStroke == null) {
            keyStroke = KeyStroke.getInstance(262144, 32);
        }
        String msg = Strings.ff("Hit %s or start typing to trigger auto-complete and browse your history", keyStroke);
        if (displayHelpString) {
            Label hint2 = new Label(ph, 64);
            hint2.setLayoutData((Object)UIUtil.createGridDataSpanHorizontally(2, true, false));
            hint2.setText("(" + msg + ")");
        }
        if (displayHelpDecorator) {
            ControlDecoration deco = new ControlDecoration((Control)this.wtext, 16512);
            Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage();
            deco.setDescriptionText(msg + ".\nSearch is case-insensitive. The wildcard '*' character is supported.");
            deco.setImage(image);
            deco.setShowOnlyOnFocus(true);
        }
        char[] autoActivationCharacters = "\b_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
        this.cpa = new ContentProposalAdapter((Control)this.wtext, new TextContentAdapter(), new ProposalProvider(), keyStroke, autoActivationCharacters);
        this.cpa.setProposalAcceptanceStyle(2);
        this.wtext.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (ContentAssistedText.this.isProposalPopupOpen() && (e.character == '\r' || e.character == '\u001b')) {
                    e.doit = false;
                    return;
                }
                e.doit = true;
            }
        });
        ProposalListener cpListener = new ProposalListener();
        this.cpa.addContentProposalListener(cpListener);
        this.cpa.addContentProposalListener(cpListener);
        this.wtext.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 && ContentAssistedText.this.cpa.isProposalPopupOpen() && !ContentAssistedText.this.internalProposalTableAccessFailed) {
                    try {
                        PopupDialog popup = (PopupDialog)ReflectionHelper.get2(ContentAssistedText.this.cpa.getClass().getDeclaredField("popup"), ContentAssistedText.this.cpa);
                        Table popupTable = (Table)ReflectionHelper.get2(popup.getClass().getDeclaredField("proposalTable"), popup);
                        int index = popupTable.getSelectionIndex();
                        if (index >= 0 && index < ContentAssistedText.this.currentProposals.size() && ContentAssistedText.this.history != null && index < ContentAssistedText.this.history.size()) {
                            (new Object[1])[0] = index;
                            String value = ContentAssistedText.this.currentProposals.get(index).getContent();
                            ContentAssistedText.this.history.remove(value);
                            ContentAssistedText.this.histContents = null;
                        }
                    }
                    catch (Exception exception) {
                        ContentAssistedText.this.internalProposalTableAccessFailed = true;
                    }
                }
            }
        });
    }

    public void setPureSearch(boolean pureSearch) {
        this.pureSearch = pureSearch;
    }

    public boolean isPureSearch() {
        return this.pureSearch;
    }

    public void confirm() {
        this.record();
    }

    private void record() {
        String str;
        if (this.history != null && !Strings.isBlank(str = this.wtext.getText())) {
            this.history.record(str);
        }
    }

    public boolean isProposalPopupOpen() {
        return this.cpa.isProposalPopupOpen();
    }

    public void setContentDescriptionProvider(IContentDescriptionProvider contentDescriptionProvider) {
        this.contentDescriptionProvider = contentDescriptionProvider;
    }

    public void setExtras(Collection<String> extras) {
        this.extras = extras;
    }

    public void setHistory(TextHistory history) {
        this.history = history;
        this.histContents = null;
    }

    private List<String> getHistoryContents() {
        if (this.histContents == null) {
            this.histContents = this.history.getAll();
        }
        return this.histContents;
    }

    public Text getWidget() {
        return this.wtext;
    }

    public String getText() {
        return this.wtext.getText();
    }

    public void setText(String content) {
        this.wtext.setText(content);
    }

    public void selectAll() {
        this.wtext.selectAll();
    }

    private void customizeInfoPop() {
        if (this.customizedInfoPop) {
            return;
        }
        try {
            Object popup = ReflectionHelper.get2(this.cpa.getClass().getDeclaredField("popup"), this.cpa);
            if (popup == null) {
                return;
            }
            Object infoPopup = ReflectionHelper.get2(popup.getClass().getDeclaredField("infoPopup"), popup);
            if (infoPopup == null) {
                return;
            }
            Text text = (Text)ReflectionHelper.get2(infoPopup.getClass().getDeclaredField("text"), infoPopup);
            if (text == null) {
                return;
            }
            text.setFont(UIUtil.getCodeFont());
        }
        catch (Exception exception) {}
        this.customizedInfoPop = true;
    }

    private class ProposalProvider
    implements IContentProposalProvider {
        @Override
        public IContentProposal[] getProposals(String contents, int position) {
            String input = "";
            if (ContentAssistedText.this.wtext.getSelectionCount() != contents.length()) {
                input = contents;
            }
            StarMatcher m = new StarMatcher(input);
            ArrayList<IContentProposal> r = new ArrayList<IContentProposal>();
            if (ContentAssistedText.this.history != null) {
                for (String s : ContentAssistedText.this.getHistoryContents()) {
                    if (!m.matches(s)) continue;
                    r.add(0, new ContentProposalODD(s));
                }
            }
            if (ContentAssistedText.this.extras != null) {
                for (String s : ContentAssistedText.this.extras) {
                    if (!m.matches(s)) continue;
                    r.add(new ContentProposalODD(s));
                }
            }
            if (r.isEmpty()) {
                ContentAssistedText.this.currentProposals = r;
                return null;
            }
            if (!ContentAssistedText.this.pureSearch) {
                r.add(0, new ContentProposalODD(input, "", input.length()));
            }
            ContentAssistedText.this.currentProposals = r;
            return r.toArray(new IContentProposal[r.size()]);
        }
    }

    private static class ProposalListener
    implements IContentProposalListener,
    IContentProposalListener2 {
        private ProposalListener() {
        }

        @Override
        public void proposalPopupOpened(ContentProposalAdapter adapter) {
        }

        @Override
        public void proposalPopupClosed(ContentProposalAdapter adapter) {
        }

        @Override
        public void proposalAccepted(IContentProposal proposal) {
        }
    }

    class ContentProposalODD
    implements IContentProposal {
        String content;
        String label;
        int cursorPosition;

        public ContentProposalODD(String content) {
            this(content, content);
        }

        public ContentProposalODD(String content, String label) {
            this(content, label, content.length());
        }

        public ContentProposalODD(String content, String label, int cursorPosition) {
            this.content = content;
            this.label = label;
            this.cursorPosition = cursorPosition;
        }

        @Override
        public String getContent() {
            return this.content;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public int getCursorPosition() {
            return this.cursorPosition;
        }

        @Override
        public String getDescription() {
            String descr = ContentAssistedText.this.contentDescriptionProvider == null ? null : ContentAssistedText.this.contentDescriptionProvider.generate(this.content);
            return descr;
        }
    }
}

