/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilterText;
import java.util.function.Consumer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CodeHierarchyCustomFilter
extends FilterText {
    private Button pkg;
    private Button cls;
    private Button mth;
    private Button fld;
    private Composite iconContainer;
    private boolean[] displayedStates = new boolean[]{true, true, true, true};
    private boolean[] states = new boolean[]{false, true, true, true};

    public CodeHierarchyCustomFilter(Composite parent, boolean[] displayedStates, boolean[] initialStates) {
        super(parent);
        this.displayedStates = displayedStates;
        this.states = initialStates;
        this.iconContainer = new Composite((Composite)this, 0);
        this.iconContainer.setLayoutData((Object)UIUtil.createGridDataFillHorizontally());
        RowLayout layout = UIUtil.createRowLayout(false, true);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        this.iconContainer.setLayout((Layout)layout);
        if (displayedStates[0]) {
            this.pkg = UIUtil.createCheckboxImage(this.iconContainer, "eclipse/package_obj.png", new StateSelectionListener(0));
            this.pkg.setToolTipText("Packages");
            this.pkg.setSelection(this.states[0]);
        }
        if (displayedStates[1]) {
            this.cls = UIUtil.createCheckboxImage(this.iconContainer, "eclipse/class_obj.png", new StateSelectionListener(1));
            this.cls.setToolTipText("Classes/Types");
            this.cls.setSelection(this.states[1]);
        }
        if (displayedStates[2]) {
            this.mth = UIUtil.createCheckboxImage(this.iconContainer, "eclipse/method_public_obj.png", new StateSelectionListener(2));
            this.mth.setToolTipText("Methods/Routines");
            this.mth.setSelection(this.states[2]);
        }
        if (displayedStates[3]) {
            this.fld = UIUtil.createCheckboxImage(this.iconContainer, "eclipse/field_public_obj.png", new StateSelectionListener(3));
            this.fld.setToolTipText("Fields");
            this.fld.setSelection(this.states[3]);
        }
    }

    public Composite getIconContainer() {
        return this.iconContainer;
    }

    public boolean isAllButtonSelected() {
        for (int i = 0; i < this.displayedStates.length; ++i) {
            if (!this.displayedStates[i] || this.states[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isNoButtonSelected() {
        for (int i = 0; i < this.displayedStates.length; ++i) {
            if (!this.displayedStates[i] || !this.states[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isCheckPackage() {
        return this.states[0];
    }

    public boolean isCheckClass() {
        return this.states[1];
    }

    public boolean isCheckMethod() {
        return this.states[2];
    }

    public boolean isCheckField() {
        return this.states[3];
    }

    private class StateSelectionListener
    implements Consumer<SelectionEvent> {
        private int stateIndex;

        public StateSelectionListener(int stateIndex) {
            this.stateIndex = stateIndex;
        }

        @Override
        public void accept(SelectionEvent t) {
            CodeHierarchyCustomFilter.this.states[this.stateIndex] = ((Button)t.widget).getSelection();
            CodeHierarchyCustomFilter.this.setStatus(null);
        }
    }
}

