/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.controls;

import com.pnfsoftware.jeb.rcpclient.extensions.UIUtil;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.FilterText;
import com.pnfsoftware.jeb.rcpclient.extensions.controls.IFilterText;
import com.pnfsoftware.jeb.rcpclient.extensions.filter.AbstractFilteredFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;

public abstract class AbstractFilteredView<T extends Composite, C extends Item, I extends Item>
extends Composite {
    private static final int SHADOW_TABLE_THRESHOLD = 10;
    private FilterText filterText;
    private String previousFilterText;
    private boolean disabledFilterToggle;
    private T mainElement;
    private GridData g;
    private AbstractFilteredFilter shadowFilter;
    private T shadowElement;
    private GridData gShadow;
    private int[] lastColumnWidth;

    public AbstractFilteredView(Composite parent, int style, String[] columnNames) {
        this(parent, style, columnNames, null, false, false);
    }

    public AbstractFilteredView(Composite parent, int style, String[] columnNames, int[] columnWidths, boolean displayIndex, boolean useShadow) {
        super(parent, 0);
        boolean singleColumn;
        boolean filterOnTop;
        useShadow = false;
        GridLayout containerLayout = UIUtil.setStandardLayout(this, 1, 0, 0);
        containerLayout.verticalSpacing = 0;
        boolean bl = filterOnTop = (style & 0x80) != 0;
        if (filterOnTop) {
            style &= 0xFFFFFF7F;
            this.filterText = this.buildFilterText(this);
        }
        this.g = this.createLayout(false);
        this.mainElement = this.buildElement(this, style, false);
        this.mainElement.setLayoutData((Object)this.g);
        if (useShadow) {
            this.gShadow = this.createLayout(true);
            this.shadowElement = this.buildElement(this, style, true);
            this.shadowElement.setLayoutData((Object)this.gShadow);
            this.displayElement();
        }
        if (!filterOnTop) {
            this.filterText = this.buildFilterText(this);
        }
        this.filterText.setLayoutData(UIUtil.createGridDataFillHorizontally());
        boolean bl2 = singleColumn = !displayIndex && columnNames != null && columnNames.length == 1;
        if (displayIndex) {
            this.buildColumn(this.mainElement, "Index", singleColumn ? 0 : 50);
            if (this.shadowElement != null) {
                this.buildColumn(this.shadowElement, "Index", singleColumn ? 0 : 50);
            }
        }
        if (columnNames != null) {
            int i = 0;
            for (String name : columnNames) {
                this.buildColumn(this.mainElement, name, singleColumn ? 0 : (columnWidths != null ? columnWidths[i] : 100));
                if (this.shadowElement != null) {
                    this.buildColumn(this.shadowElement, name, singleColumn ? 0 : (columnWidths != null ? columnWidths[i] : 100));
                }
                ++i;
            }
        }
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && filterOnTop && AbstractFilteredView.this.getItemCount() > 0) {
                    AbstractFilteredView.this.setSelection(0);
                    AbstractFilteredView.this.setFocus();
                    e.doit = false;
                } else if (e.keyCode == 0x1000001 && !filterOnTop && AbstractFilteredView.this.getItemCount() > 0) {
                    AbstractFilteredView.this.setSelection(AbstractFilteredView.this.getItemCount() - 1);
                    AbstractFilteredView.this.setFocus();
                    e.doit = false;
                } else if (e.keyCode == 27) {
                    AbstractFilteredView.this.setFilterVisibility(false, false);
                    AbstractFilteredView.this.setFocus();
                    e.doit = false;
                }
            }
        });
        this.bindElementToFilterText(this.mainElement, filterOnTop);
        if (this.shadowElement != null) {
            this.bindElementToFilterText(this.shadowElement, filterOnTop);
        }
    }

    protected void bindElementToFilterText(T element, final boolean filterOnTop) {
        element.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 && filterOnTop && AbstractFilteredView.this.getSelectionIndex() == 0 || e.keyCode == 0x1000002 && !filterOnTop && AbstractFilteredView.this.getSelectionIndex() == AbstractFilteredView.this.getItemCount() - 1) {
                    if (AbstractFilteredView.this.filterText.isVisible()) {
                        AbstractFilteredView.this.filterText.setFocus();
                        e.doit = false;
                    }
                } else if ((e.stateMask & SWT.MOD1) == SWT.MOD1 && e.keyCode == 102) {
                    AbstractFilteredView.this.setFilterVisibility(true, true);
                }
            }
        });
    }

    public IFilterText getFilterText() {
        return this.filterText;
    }

    public T getCurrentElement() {
        return this.isShadowTableDisplayed() ? this.shadowElement : this.mainElement;
    }

    public T getMainElement() {
        return this.mainElement;
    }

    public T getShadowElement() {
        return this.shadowElement;
    }

    public boolean isShadowTableDisplayed() {
        return this.shadowFilter != null && this.shadowElement != null;
    }

    public boolean hasShadowTable() {
        return this.shadowElement != null && (this.shadowFilter != null || this.getItemCount() > 10);
    }

    public void displayMainElement() {
        this.shadowFilter = null;
        if (this.shadowElement != null) {
            this.removeAll(this.shadowElement);
        }
        this.displayElement();
    }

    private void displayElement() {
        if (this.shadowElement == null) {
            return;
        }
        boolean filtered = this.shadowFilter != null;
        this.gShadow.exclude = !filtered;
        this.g.exclude = filtered;
        this.shadowElement.setVisible(filtered);
        this.mainElement.setVisible(!filtered);
    }

    public void displayShadowElement(AbstractFilteredFilter filter) {
        this.shadowFilter = filter;
        int ccount = this.getColumnCount();
        this.removeAll(this.shadowElement);
        for (Item it : this.getMainItems()) {
            Object[] rowElements = new String[ccount];
            for (int i = 0; i < ccount; ++i) {
                rowElements[i] = this.getText(it, i);
            }
            if (!filter.isRowMatch(rowElements)) continue;
            this.createItem(this.shadowElement, it, (String[])rowElements);
        }
        this.displayElement();
        this.shadowElement.setBounds(this.mainElement.getBounds());
        this.shadowElement.setSize(this.mainElement.getSize());
        for (int i = 0; i < ccount; ++i) {
            this.duplicateWidth(this.getColumn(this.mainElement, i), this.getColumn(this.shadowElement, i));
        }
        this.layout();
    }

    public void refreshShadowElement() {
        this.displayShadowElement(this.shadowFilter);
    }

    public void setColumnVisible(boolean visible, int index) {
        int newColumnWidth;
        if (this.lastColumnWidth == null) {
            this.lastColumnWidth = new int[this.getColumnCount()];
            this.addDisposeListener(d -> {
                for (int i = 0; i < this.getColumnCount(); ++i) {
                    int columnWidth = this.getColumnWidth(i);
                    if (columnWidth != 0) continue;
                    this.setColumnWidth(i, this.lastColumnWidth[i]);
                    if (this.shadowElement == null) continue;
                    if (this.getCurrentElement() == this.getMainElement()) {
                        this.duplicateWidth(this.getColumn(this.mainElement, i), this.getColumn(this.shadowElement, i));
                        continue;
                    }
                    this.duplicateWidth(this.getColumn(this.shadowElement, i), this.getColumn(this.mainElement, i));
                }
            });
        }
        int currentColumnWidth = this.getColumnWidth(index);
        if (visible) {
            if (currentColumnWidth != 0) {
                return;
            }
            newColumnWidth = this.lastColumnWidth[index];
        } else {
            if (currentColumnWidth == 0) {
                return;
            }
            this.lastColumnWidth[index] = currentColumnWidth;
            newColumnWidth = 0;
        }
        this.setColumnWidth(index, newColumnWidth);
        if (this.shadowElement != null) {
            if (this.getCurrentElement() == this.getMainElement()) {
                this.duplicateWidth(this.getColumn(this.mainElement, index), this.getColumn(this.shadowElement, index));
            } else {
                this.duplicateWidth(this.getColumn(this.shadowElement, index), this.getColumn(this.mainElement, index));
            }
        }
    }

    abstract C getColumn(T var1, int var2);

    abstract I[] getMainItems();

    abstract void removeAll(T var1);

    abstract String getText(I var1, int var2);

    abstract I createItem(T var1, I var2, String[] var3);

    abstract void duplicateWidth(C var1, C var2);

    public boolean setFocus() {
        return this.getCurrentElement().setFocus();
    }

    public void setDisabledFilterToggle(boolean disabledFilterToggle) {
        this.disabledFilterToggle = disabledFilterToggle;
    }

    public boolean isDisableFilterToggle() {
        return this.disabledFilterToggle;
    }

    public void setFilterVisibility(boolean visible, boolean focus) {
        if (this.disabledFilterToggle) {
            return;
        }
        Object layoutData = this.filterText.getLayoutData();
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).exclude = !visible;
        }
        this.filterText.setVisible(visible);
        this.filterText.getParent().layout();
        if (!visible) {
            this.previousFilterText = this.filterText.getText();
            this.filterText.setText("");
        } else if (this.previousFilterText != null) {
            this.filterText.setText(this.previousFilterText);
            this.previousFilterText = null;
        }
        if (focus) {
            this.filterText.setFocus();
            this.filterText.selectAll();
        }
    }

    public void setFilterVisibility(boolean visible) {
        this.setFilterVisibility(visible, visible);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addNativeSelectionListener(this.mainElement, listener);
        if (this.shadowElement != null) {
            this.addNativeSelectionListener(this.shadowElement, listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.removeNativeSelectionListener(this.mainElement, listener);
        if (this.shadowElement != null) {
            this.removeNativeSelectionListener(this.shadowElement, listener);
        }
    }

    public void addTableKeyListener(KeyListener listener) {
        this.mainElement.addKeyListener(listener);
        if (this.shadowElement != null) {
            this.shadowElement.addKeyListener(listener);
        }
    }

    abstract void addNativeSelectionListener(T var1, SelectionListener var2);

    abstract void removeNativeSelectionListener(T var1, SelectionListener var2);

    public void addColumnSelectionListener(int colIndex, SelectionListener columnSelectionListener) {
        this.addNativeColumnSelectionListener(this.mainElement, colIndex, columnSelectionListener);
        if (this.shadowElement != null) {
            this.addNativeColumnSelectionListener(this.shadowElement, colIndex, columnSelectionListener);
        }
    }

    abstract void addNativeColumnSelectionListener(T var1, int var2, SelectionListener var3);

    public void setSortData(int dir, int columnIndex) {
        this.sortNativeColumn(this.mainElement, dir, columnIndex);
        if (this.shadowElement != null) {
            this.sortNativeColumn(this.shadowElement, dir, columnIndex);
        }
    }

    public abstract int getSortIndex();

    public abstract int getSortDirection();

    abstract void sortNativeColumn(T var1, int var2, int var3);

    int computeInnerHeight(int wHint, int hHint, boolean changed) {
        int innerHeight = 0;
        Point fTextSize = this.filterText.computeSize(wHint, hHint, changed);
        innerHeight += fTextSize.y;
        GridLayout contLayout = (GridLayout)this.getLayout();
        return innerHeight += contLayout.verticalSpacing * 1 + contLayout.marginTop + contLayout.marginHeight * 2 + contLayout.marginBottom;
    }

    GridData createLayout(boolean shadow) {
        return UIUtil.createGridDataSpanHorizontally(1, true, true);
    }

    protected FilterText buildFilterText(Composite parent) {
        return new FilterText(parent);
    }

    protected abstract T buildElement(Composite var1, int var2, boolean var3);

    protected abstract void buildColumn(T var1, String var2, int var3);

    protected void buildComplete(T elt) {
    }

    public abstract int getSelectionIndex();

    public abstract void setSelection(int var1);

    public abstract int getItemCount();

    public abstract int getColumnCount();

    public abstract int getColumnWidth(int var1);

    public abstract void setColumnWidth(int var1, int var2);
}

