/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.binding;

import com.pnfsoftware.jeb.rcpclient.AllHandlers;
import com.pnfsoftware.jeb.rcpclient.extensions.UIExecutor;
import com.pnfsoftware.jeb.rcpclient.extensions.binding.ActionEx;
import com.pnfsoftware.jeb.rcpclient.handlers.JebBaseHandler;
import com.pnfsoftware.jeb.util.collect.WeakIdentityHashMap;
import com.pnfsoftware.jeb.util.format.Formatter;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class KeyAcceleratorManager {
    private static final ILogger logger = GlobalLog.getLogger(KeyAcceleratorManager.class);
    private Display display;
    private String shellTrackTag;
    private WeakIdentityHashMap<Shell, Integer> shellmap = new WeakIdentityHashMap();
    private Listener filter;
    private boolean disregardIncomingTraversalKeyDown;
    private Map<Integer, ActionEx> keyToHandlers = new HashMap<Integer, ActionEx>();

    public KeyAcceleratorManager(Display display, final String shellTrackTag) {
        this.display = display;
        this.shellTrackTag = shellTrackTag;
        for (Shell shell : display.getShells()) {
            this.processShell(shell);
        }
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 1) {
                    if (KeyAcceleratorManager.this.disregardIncomingTraversalKeyDown) {
                        KeyAcceleratorManager.this.disregardIncomingTraversalKeyDown = false;
                        if (event.keyCode == 27 || event.keyCode == 9) {
                            return;
                        }
                    }
                    if (KeyAcceleratorManager.this.processKey(event)) {
                        event.type = 0;
                        event.doit = false;
                    }
                } else if (event.type == 31) {
                    if (KeyAcceleratorManager.this.processKey(event)) {
                        KeyAcceleratorManager.this.disregardIncomingTraversalKeyDown = true;
                        event.type = 0;
                        event.doit = false;
                    }
                } else if (event.type == 26 && event.widget instanceof Shell) {
                    Shell shell = (Shell)event.widget;
                    if (shellTrackTag == null || shell.getData(KeyAcceleratorManager.this.shellTrackTag) != null) {
                        KeyAcceleratorManager.this.processShell(shell);
                    }
                }
            }
        };
        display.addFilter(1, this.filter);
        display.addFilter(31, this.filter);
        display.addFilter(26, this.filter);
    }

    public void dispose() {
        this.display.removeFilter(1, this.filter);
        this.display.removeFilter(31, this.filter);
        this.display.removeFilter(26, this.filter);
    }

    private void processShell(Shell shell) {
        if (this.shellmap.get(shell) == null) {
            this.shellmap.put(shell, 0);
        }
    }

    public Collection<Shell> getAcceleratedShells() {
        return this.shellmap.keySet();
    }

    private boolean processKey(Event event) {
        Control ctl;
        if (event.data != null) {
            return false;
        }
        event.data = -1;
        if (event.widget instanceof Control && this.shellmap.get((ctl = (Control)event.widget).getShell()) != null && (event.keyCode & SWT.MODIFIER_MASK) == 0) {
            boolean writingText = false;
            Control ctl0 = ctl.getDisplay().getFocusControl();
            if (ctl0 instanceof Text && ((Text)ctl0).getEditable() || ctl0 instanceof StyledText && ((StyledText)ctl0).getEditable()) {
                writingText = Formatter.isPrintableChar(event.character);
            }
            if (!writingText) {
                char ch;
                ActionEx h = this.keyToHandlers.get(event.stateMask | event.keyCode);
                if (h == null && event.keyCode != (ch = event.character)) {
                    h = this.keyToHandlers.get(ch);
                }
                if (h != null) {
                    Object h2;
                    if (h instanceof JebBaseHandler && (h2 = AllHandlers.getInstance().create(((JebBaseHandler)h).getClass())) != null) {
                        h = h2;
                    }
                    if (h.checkExecutionContext(ctl) && h.canExecute()) {
                        UIExecutor.sync(this.display, (Runnable)h);
                        event.data = 1;
                        return true;
                    }
                }
            }
        }
        event.data = 0;
        return false;
    }

    public void registerHandlers(Collection<? extends ActionEx> handlers) {
        for (ActionEx actionEx : handlers) {
            this.registerHandler(actionEx);
        }
    }

    public void registerHandler(ActionEx handler) {
        for (int keycode : handler.getExtraAccelerators()) {
            ActionEx h0 = this.keyToHandlers.get(keycode);
            if (h0 != null) {
                if (h0 == handler) continue;
                logger.error("The accelerator %s is already used by handler %s (handler %s cannot steal it)", KeyStroke.getInstance(keycode & 0xFEFF0000, keycode & 0x100FFFF).toString(), h0.getClass().getSimpleName(), handler.getClass().getSimpleName());
                continue;
            }
            this.keyToHandlers.put(keycode, handler);
        }
    }

    public void unregisterHandler(ActionEx handler) {
        ArrayList<Integer> tbd = new ArrayList<Integer>();
        for (Map.Entry<Integer, ActionEx> e : this.keyToHandlers.entrySet()) {
            if (e.getValue() != handler) continue;
            tbd.add(e.getKey());
        }
        Iterator<Map.Entry<Integer, ActionEx>> iterator = tbd.iterator();
        while (iterator.hasNext()) {
            int keycode = (Integer)((Object)iterator.next());
            this.keyToHandlers.remove(keycode);
        }
    }
}

