/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.app;

import com.pnfsoftware.jeb.rcpclient.extensions.app.Folder;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMElement;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMFolder;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPart;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPartManager;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class Part
implements IMPart {
    private static final ILogger logger = GlobalLog.getLogger(Part.class);
    private static int internalPartCreationCount = 0;
    private static final String pinnedSfx = " \ud83d\udccc";
    int internalPartId = internalPartCreationCount++;
    String elementId;
    Folder defaultOwner;
    Folder owner;
    CTabItem tab;
    boolean pinned;
    private IMPartManager manager;
    int state;
    private Map<String, Object> data;
    private boolean closeOnHide;
    private Composite cControl;
    private String cLabel;
    private String cTooltip;
    private Image cIcon;
    private Font cFont;
    private boolean cCloseable;

    public Part(Folder owner) {
        this.owner = owner;
        this.defaultOwner = owner;
        this.createContainerWidget();
    }

    public Part(CTabItem tab) {
        this.setTab(tab);
        this.defaultOwner = this.owner;
        this.createContainerWidget();
    }

    private void setTab(CTabItem tab) {
        this.owner = Folder.tabToFolder(tab);
        this.tab = tab;
    }

    private void createContainerWidget() {
        Composite container = new Composite((Composite)this.owner.getFolderWidget(), 2048);
        container.setLayout((Layout)new FillLayout());
        this.cControl = container;
    }

    public Composite getContainerWidget() {
        return this.tab == null ? this.cControl : (Composite)this.tab.getControl();
    }

    @Override
    public boolean isHidden() {
        return this.tab == null;
    }

    void hide() {
        if (this.isHidden()) {
            throw new IllegalStateException();
        }
        this.cControl = (Composite)this.tab.getControl();
        this.cLabel = this.getLabel();
        this.cTooltip = this.tab.getToolTipText();
        this.cIcon = this.tab.getImage();
        this.cFont = this.tab.getFont();
        this.cCloseable = this.tab.getShowClose();
        this.tab.dispose();
        this.tab = null;
    }

    @Override
    public boolean isShown() {
        if (this.tab == null || this.owner == null) {
            return false;
        }
        return this.owner.getFolderWidget().getSelection() == this.tab;
    }

    void restoreInto(CTabItem tab) {
        if (!this.isHidden()) {
            throw new IllegalStateException();
        }
        if (this.cControl != null) {
            CTabFolder folder = tab.getParent();
            this.cControl.setParent((Composite)folder);
            tab.setControl((Control)this.cControl);
        }
        if (this.cLabel != null) {
            tab.setText(this.generateVisualLabel(this.cLabel));
        }
        if (this.cTooltip != null) {
            tab.setToolTipText(this.cTooltip);
        }
        if (this.cIcon != null) {
            tab.setImage(this.cIcon);
        }
        if (this.cFont != null) {
            tab.setFont(this.cFont);
        }
        tab.setShowClose(this.cCloseable);
        this.setTab(tab);
    }

    public Control getControl() {
        return this.tab == null ? this.cControl : this.tab.getControl();
    }

    @Override
    public boolean isCloseOnHide() {
        return this.closeOnHide;
    }

    @Override
    public void setCloseOnHide(boolean closeOnHide) {
        this.closeOnHide = closeOnHide;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        if (this.pinned == pinned) {
            return;
        }
        this.pinned = pinned;
        this.refreshLabel();
    }

    @Override
    public String getLabel() {
        if (this.tab == null) {
            return this.cLabel;
        }
        String label = this.tab.getText();
        if (label.endsWith(pinnedSfx)) {
            label = label.substring(0, label.length() - pinnedSfx.length());
        }
        return label;
    }

    @Override
    public void setLabel(String label) {
        if (this.tab == null) {
            this.cLabel = label;
        } else {
            this.tab.setText(this.generateVisualLabel(label));
        }
    }

    private String generateVisualLabel(String label) {
        if (this.pinned) {
            return label + pinnedSfx;
        }
        return label;
    }

    public void refreshLabel() {
        this.setLabel(this.getLabel());
    }

    @Override
    public String getTooltip() {
        return this.tab == null ? this.cTooltip : this.tab.getToolTipText();
    }

    @Override
    public void setTooltip(String tooltip) {
        if (this.tab == null) {
            this.cTooltip = tooltip;
        } else {
            this.tab.setToolTipText(tooltip);
        }
    }

    @Override
    public boolean isHideable() {
        return this.tab == null ? this.cCloseable : this.tab.getShowClose();
    }

    @Override
    public void setHideable(boolean closeable) {
        if (this.tab == null) {
            this.cCloseable = closeable;
        } else {
            this.tab.setShowClose(closeable);
        }
    }

    @Override
    public Image getIcon() {
        return this.tab == null ? this.cIcon : this.tab.getImage();
    }

    @Override
    public void setIcon(Image icon) {
        if (this.tab == null) {
            this.cIcon = icon;
        } else {
            this.tab.setImage(icon);
        }
    }

    public Font getFont() {
        return this.tab == null ? this.cFont : this.tab.getFont();
    }

    public void setFont(Font font) {
        if (this.tab == null) {
            this.cFont = font;
        } else {
            this.tab.setFont(font);
        }
    }

    @Override
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public List<? extends IMElement> getChildrenElements() {
        return Collections.emptyList();
    }

    @Override
    public IMFolder getParentElement() {
        return this.owner;
    }

    @Override
    public void setManager(IMPartManager manager) {
        this.manager = manager;
    }

    @Override
    public IMPartManager getManager() {
        return this.manager;
    }

    @Override
    public Map<String, Object> getData() {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        return this.data;
    }

    public String toString() {
        return Strings.ff("Part@%d[%s]", this.internalPartId, this.getLabel());
    }
}

