/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.app;

import com.pnfsoftware.jeb.client.S;
import com.pnfsoftware.jeb.rcpclient.extensions.app.Dock;
import com.pnfsoftware.jeb.rcpclient.extensions.app.DropZone;
import com.pnfsoftware.jeb.rcpclient.extensions.app.DropZones;
import com.pnfsoftware.jeb.rcpclient.extensions.app.GhostWidget;
import com.pnfsoftware.jeb.rcpclient.extensions.app.IFolderListener;
import com.pnfsoftware.jeb.rcpclient.extensions.app.Panel;
import com.pnfsoftware.jeb.rcpclient.extensions.app.Part;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMElement;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMFolder;
import com.pnfsoftware.jeb.rcpclient.extensions.app.model.IMPartManager;
import com.pnfsoftware.jeb.rcpclient.extensions.tab.TabContextMenuManager;
import com.pnfsoftware.jeb.rcpclient.parts.CTabFolderRendererFix;
import com.pnfsoftware.jeb.rcpclient.util.CTabFolderUtils;
import com.pnfsoftware.jeb.util.concurrent.ThreadUtil;
import com.pnfsoftware.jeb.util.format.Strings;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class Folder
extends Composite
implements IMFolder {
    private static final ILogger logger = GlobalLog.getLogger(Folder.class);
    private static int internalFolderCreationCount = 0;
    int internalFolderId;
    String elementId;
    int defaultTabStyle;
    boolean insideDock;
    boolean closeOnEmpty;
    int maxCharsPerTabLabel;
    private CTabFolder folderWidget;
    List<IFolderListener> folderListeners = new ArrayList<IFolderListener>();
    GhostWidget g;
    CTabItem draggedTab;
    CTabItem previouslySelectedTab;
    CTabItem selectedTab;
    List<Part> parts = new ArrayList<Part>();
    public static final int HIDDEN = 0;
    public static final int VISIBLE = 1;
    public static final int SHOWN = 2;
    public static final int FOCUSED = 3;

    public Folder(Composite parent, int style, int tabStyle) {
        this(parent, style, tabStyle, false, false);
    }

    Folder(Composite parent, int style, int tabStyle, boolean insideDock, boolean closeOnEmpty) {
        super(parent, 0);
        this.internalFolderId = internalFolderCreationCount++;
        this.defaultTabStyle = tabStyle;
        this.insideDock = insideDock;
        this.closeOnEmpty = closeOnEmpty;
        this.setLayout((Layout)new FillLayout());
        this.folderWidget = new CTabFolder((Composite)this, style);
        this.folderWidget.setRenderer((CTabFolderRenderer)new CTabFolderRendererFix(this.folderWidget));
        CTabFolderUtils.setCTabFolderHeight(this.folderWidget, (int)((double)this.folderWidget.getTabHeight() * 1.2));
        this.folderWidget.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                CTabItem tab = (CTabItem)event.item;
                Part part = Folder.this.getPartByTab(tab);
                Folder.this.hidePart(part);
                event.doit = false;
            }
        });
        this.folderWidget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabItem tab;
                Folder.this.previouslySelectedTab = Folder.this.selectedTab;
                (new Object[1])[0] = Folder.this.previouslySelectedTab;
                Folder.this.selectedTab = tab = Folder.this.folderWidget.getSelection();
                if (tab != null) {
                    Part part = Folder.this.getPartByTab(tab);
                    (new Object[1])[0] = part;
                    Folder.this.setFocusOnPartControl(part);
                    Folder.this.notifyPartSelected(Folder.this.getPartByTab(tab));
                }
            }
        });
        this.folderWidget.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Object[] objectArray = new Object[]{e.widget, e.widget.hashCode()};
                CTabItem tab = Folder.this.folderWidget.getSelection();
                if (tab != null) {
                    Part part = Folder.this.getPartByTab(tab);
                    Folder.this.setFocusOnPartControl(part);
                }
            }

            public void focusLost(FocusEvent e) {
                Object[] objectArray = new Object[]{e.widget, e.widget.hashCode()};
            }
        });
        Listener actListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    CTabItem tab = Folder.this.folderWidget.getSelection();
                    Object[] objectArray = new Object[]{tab, event};
                    if (tab != null) {
                        Part part = Folder.this.getPartByTab(tab);
                        (new Object[1])[0] = part;
                        Folder.this.setFocusOnPartControl(part, false);
                    }
                }
            }
        };
        this.folderWidget.addListener(26, actListener);
        this.folderWidget.addListener(29, new Listener(){

            public void handleEvent(Event event) {
                Composite topLevelContainer;
                List<DropZone> list;
                CTabItem item = Folder.this.folderWidget.getSelection();
                if (item == null) {
                    return;
                }
                Display display = Folder.this.getDisplay();
                if (!Folder.this.isInsideDock()) {
                    list = new DropZones((Control)Folder.this, item, false, false).determine();
                    topLevelContainer = Folder.this;
                } else {
                    Dock dock = Folder.this.getDock();
                    boolean includeSelfDockingAreas = !dock.onEmptyCloseFolder || item.getParent().getItemCount() != 1;
                    list = new DropZones((Control)dock, item, true, includeSelfDockingAreas).determine();
                    topLevelContainer = dock;
                    if (dock.allowForeignDocking) {
                        for (Dock dock2 : Dock.findDocks(display)) {
                            if (dock2 == dock) continue;
                            List<DropZone> list2 = new DropZones((Control)dock2, item, true, true).determine();
                            list.addAll(list2);
                        }
                        topLevelContainer = null;
                    }
                }
                if (list.isEmpty()) {
                    return;
                }
                Folder.this.folderWidget.forceFocus();
                Folder.this.draggedTab = Folder.this.folderWidget.getSelection();
                Folder.this.g = new GhostWidget((Control)topLevelContainer, display);
                Folder.this.g.registerDropZones(list);
                Rectangle r = Folder.this.folderWidget.getSelection().getBounds();
                Folder.this.g.setRectangle(event.display.map((Control)Folder.this.folderWidget, Folder.this.g.getTopLevelContainer(), r));
                Folder.this.g.setPositionDelta(new Point(event.x - r.x, event.y - r.y));
            }
        });
        this.folderWidget.addListener(5, new Listener(){

            public void handleEvent(Event event) {
                if (Folder.this.g != null) {
                    Point p = event.display.map((Control)Folder.this.folderWidget, Folder.this.g.getTopLevelContainer(), event.x, event.y);
                    Folder.this.g.updatePosition(p);
                }
            }
        });
        this.folderWidget.addListener(4, new Listener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void handleEvent(Event event) {
                if (Folder.this.g != null) {
                    try {
                        Point p;
                        DropZone dropzone = Folder.this.g.getActiveDropZone();
                        Dock dock = Folder.this.getDock();
                        Folder srcFolder = Folder.tabToFolder(Folder.this.draggedTab);
                        Folder dstFolder = null;
                        if (dropzone != null) {
                            dstFolder = (Folder)dropzone.ctl;
                            Dock dstDock = dstFolder.getDock();
                            if (dropzone.index >= 0) {
                                Folder.this.moveTab(Folder.this.draggedTab, dstFolder.folderWidget, dropzone.index, true);
                            } else {
                                Folder folder2 = dstDock.splitFolder(dstFolder, dropzone.index);
                                Folder.this.moveTab(Folder.this.draggedTab, folder2.folderWidget, 0, true);
                            }
                        } else if (dock != null && dock.allowForeignDocking && !Folder.this.g.inCandidateArea(p = event.display.map((Control)Folder.this.folderWidget, null, event.x, event.y))) {
                            Dock dstDock = dock.createAdditionalDock(false, 1264, p, null);
                            dstFolder = dstDock.getInitialFolder();
                            Folder.this.moveTab(Folder.this.draggedTab, dstFolder.folderWidget, 0, true);
                        }
                        if (dock != null && dstFolder != null) {
                            Folder.this.updateFolder(srcFolder);
                            return;
                        }
                        if (Folder.this.previouslySelectedTab == null || Folder.this.previouslySelectedTab.isDisposed()) return;
                        Folder.this.focusPart(Folder.this.getPartByTab(Folder.this.previouslySelectedTab));
                        Folder.this.selectedTab = Folder.this.previouslySelectedTab;
                        return;
                    }
                    finally {
                        Folder.this.g.dispose();
                        Folder.this.g = null;
                        Folder.this.draggedTab = null;
                    }
                } else {
                    if (event.button != 2) return;
                    CTabItem item = Folder.this.folderWidget.getItem(new Point(event.x, event.y));
                    if (item == null) {
                        return;
                    }
                    Part part = Folder.this.getPartByTab(item);
                    Folder.this.hidePart(part);
                }
            }
        });
        new TabContextMenuManager(this.folderWidget){

            @Override
            public void addActions(CTabItem tab, IMenuManager menuMgr) {
                final Part part = Folder.this.getPartByTab(tab);
                if (!part.isHideable()) {
                    return;
                }
                menuMgr.add(new Action(S.s(466)){

                    @Override
                    public void run() {
                        Folder.this.hidePart(part);
                    }
                });
                menuMgr.add(new Action("Close Others (Unpinned Only)"){

                    @Override
                    public void run() {
                        ArrayList<Part> parts = new ArrayList<Part>(Folder.this.getParts());
                        for (Part p : parts) {
                            if (p == part || p.isHidden() || p.isPinned()) continue;
                            Folder.this.hidePart(p);
                        }
                    }
                });
                menuMgr.add(new Action("Close All (Unpinned Only)"){

                    @Override
                    public void run() {
                        ArrayList<Part> parts = new ArrayList<Part>(Folder.this.getParts());
                        for (Part p : parts) {
                            if (p.isHidden() || p.isPinned()) continue;
                            Folder.this.hidePart(p);
                        }
                    }
                });
                final boolean pinned0 = part.isPinned();
                menuMgr.add(new Action(pinned0 ? "Unpin" : "Pin"){

                    @Override
                    public void run() {
                        if (!pinned0) {
                            int idxLastPinned = -1;
                            CTabItem[] tabs = Folder.this.folderWidget.getItems();
                            for (int i = tabs.length - 1; i >= 0; --i) {
                                Part p = Folder.this.getPartByTab(tabs[i]);
                                if (p == null || !p.isPinned()) continue;
                                idxLastPinned = i;
                                break;
                            }
                            Folder.this.moveTab(part.tab, Folder.this.folderWidget, ++idxLastPinned, true);
                            part.setPinned(true);
                        } else {
                            part.setPinned(false);
                        }
                    }
                });
                menuMgr.add(new Action("Unpin All"){

                    @Override
                    public void run() {
                        ArrayList<Part> parts = new ArrayList<Part>(Folder.this.getParts());
                        for (Part p : parts) {
                            p.setPinned(false);
                        }
                    }
                });
            }
        }.bind();
        this.folderWidget.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (Folder.this.g != null) {
                    Folder.this.g.dispose();
                }
            }
        });
        this.folderWidget.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                (new Object[1])[0] = e;
                if (Folder.this.g != null && e.keyCode == 27) {
                    Folder.this.g.dispose();
                    Folder.this.g = null;
                    Folder.this.draggedTab = null;
                }
            }
        });
        this.folderWidget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Folder.this.dispose();
            }
        });
    }

    public boolean isInsideDock() {
        return this.insideDock;
    }

    public Dock getDock() {
        if (!this.insideDock) {
            return null;
        }
        Folder ctl = this;
        while (!(ctl instanceof Dock)) {
            if ((ctl = ctl.getParent()) != null) continue;
            throw new RuntimeException("The folder " + this + " should be inside a dock");
        }
        return (Dock)((Object)ctl);
    }

    @Override
    public boolean isCloseOnEmpty() {
        return this.closeOnEmpty;
    }

    @Override
    public void setCloseOnEmpty(boolean closeOnEmpty) {
        this.closeOnEmpty = closeOnEmpty;
    }

    public void setMinCharsPerTabLabel(int count) {
        this.folderWidget.setMinimumCharacters(count);
    }

    public int getMinCharsPerTabLabel() {
        return this.folderWidget.getMinimumCharacters();
    }

    CTabFolder getFolderWidget() {
        return this.folderWidget;
    }

    public Panel getParentPanel() {
        if (!(this.getParent() instanceof SashForm)) {
            throw new IllegalStateException("Folder in unexpected location");
        }
        Composite ctl = this.getParent().getParent();
        if (!(ctl instanceof Panel)) {
            throw new IllegalStateException("Folder not in a panel");
        }
        return (Panel)ctl;
    }

    Part getPartByTab(CTabItem tab) {
        for (Part part : this.parts) {
            if (part.tab != tab) continue;
            return part;
        }
        throw new RuntimeException("Already closed tab " + tab);
    }

    public Part getPartByControl(Control control) {
        for (Part part : this.parts) {
            if (part.getControl() != control) continue;
            return part;
        }
        return null;
    }

    static Folder widgetToFolder(CTabFolder folderWidget) {
        return (Folder)folderWidget.getParent();
    }

    static Folder tabToFolder(CTabItem tab) {
        return (Folder)tab.getParent().getParent();
    }

    private void moveTab(CTabItem srcTab, CTabFolder dstFolderWidget, int dstIndex, boolean notify) {
        Part part = this.getPartByTab(srcTab);
        CTabFolder srcFolderWidget = srcTab.getParent();
        int srcIndex = Arrays.asList(srcFolderWidget.getItems()).indexOf(srcTab);
        Folder srcFolder = (Folder)srcFolderWidget.getParent();
        Folder dstFolder = (Folder)dstFolderWidget.getParent();
        if (srcFolderWidget == dstFolderWidget && dstIndex > srcIndex) {
            --dstIndex;
        }
        part.hide();
        this.parts.remove(part);
        CTabItem newTab = new CTabItem(dstFolderWidget, this.defaultTabStyle, dstIndex);
        dstFolder.parts.add(dstIndex, part);
        part.restoreInto(newTab);
        dstFolderWidget.showItem(newTab);
        dstFolderWidget.setSelection(newTab);
        if (notify) {
            this.notifyPartMoved(srcFolder, part);
        }
    }

    void restoreTab(Part part, CTabFolder dstFolderWidget) {
        Folder dstFolder = (Folder)dstFolderWidget.getParent();
        part.hide();
        this.parts.remove(part);
        CTabItem newTab = new CTabItem(dstFolderWidget, this.defaultTabStyle);
        dstFolder.parts.add(part);
        part.restoreInto(newTab);
        dstFolderWidget.showItem(newTab);
        dstFolderWidget.setSelection(newTab);
    }

    private void updateFolder(Folder srcFolder) {
        Dock dock = srcFolder.getDock();
        if (dock != null && srcFolder.closeOnEmpty && srcFolder.getPartsCount() == 0) {
            dock.notifyFolderRemoving(srcFolder);
            Panel panel = srcFolder.getParentPanel();
            srcFolder.dispose();
            if (panel.isEmpty()) {
                if (panel.getParent() instanceof Dock) {
                    Shell sh = (Shell)panel.getParent().getParent();
                    sh.dispose();
                    return;
                }
                Panel panelParent = (Panel)panel.getParent().getParent();
                panel.dispose();
                panel = panelParent;
            }
            panel.layout(true, true);
        }
    }

    public void addFolderListener(IFolderListener listener) {
        this.folderListeners.add(listener);
    }

    public void removeFolderListener(IFolderListener listener) {
        this.folderListeners.remove(listener);
    }

    void notifyPartSelected(Part part) {
        Iterator<IFolderListener> iterator = this.folderListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    void notifyPartAdded(Part part) {
        Iterator<IFolderListener> iterator = this.folderListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    void notifyPartRemoved(Part part) {
        Iterator<IFolderListener> iterator = this.folderListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    void notifyPartMoved(Folder src, Part part) {
        Iterator<IFolderListener> iterator = this.folderListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    void notifyPartHidden(Part part) {
        Iterator<IFolderListener> iterator = this.folderListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    void notifyPartVisible(Part part) {
        Iterator<IFolderListener> iterator = this.folderListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    @Override
    public Part addPart() {
        return this.addPart(true);
    }

    Part addPart(boolean notify) {
        return this.addPart(this.folderWidget.getItemCount(), notify);
    }

    @Override
    public Part addPart(int index) {
        return this.addPart(index, true);
    }

    Part addPart(int index, boolean notify) {
        if (index < 0 || index > this.parts.size()) {
            this.parts.size();
        }
        Part part = new Part(this);
        this.parts.add(part);
        if (notify) {
            this.notifyPartAdded(part);
        }
        return part;
    }

    public void hidePart(Part part) {
        this.setPartVisibility(part, 0);
    }

    public void unhidePart(Part part) {
        this.setPartVisibility(part, 1);
    }

    public void showPart(Part part) {
        this.setPartVisibility(part, 2);
    }

    public void focusPart(Part part) {
        this.setPartVisibility(part, 3);
    }

    void setPartVisibility(Part part, int action) {
        this.setPartVisibility(part, action, true);
    }

    void setPartVisibility(Part part, int action, boolean notify) {
        if (action < 0 || action > 3) {
            throw new IllegalArgumentException();
        }
        int index = this.parts.indexOf(part);
        if (index < 0 || index > this.folderWidget.getItemCount()) {
            index = this.folderWidget.getItemCount();
        }
        if (action == 0) {
            if (!part.isHidden() && part.isHideable()) {
                this.closePart(part, notify);
            }
            return;
        }
        if (action >= 1 && part.isHidden()) {
            CTabItem tab = new CTabItem(this.folderWidget, this.defaultTabStyle, index);
            part.restoreInto(tab);
            if (notify) {
                this.notifyPartVisible(part);
            }
        }
        if (action >= 2) {
            IMPartManager partManager = part.getManager();
            if (part.state == 0 && partManager != null) {
                Composite container = part.getContainerWidget();
                if (partManager.createView(container, part)) {
                    container.layout();
                    part.state = 1;
                } else {
                    this.closePart(part, notify);
                    return;
                }
            }
            this.folderWidget.setSelection(part.tab);
        }
        if (action >= 3) {
            this.setFocusOnPartControl(part);
        }
    }

    void setFocusOnPartControl(Part part) {
        this.setFocusOnPartControl(part, true);
    }

    void setFocusOnPartControl(Part part, boolean focusOrActivation) {
        part.tab.getControl().setFocus();
        if (part.getManager() != null) {
            part.getManager().onFocus();
        }
    }

    public int getPartVisibility(Part part) {
        int index = this.parts.indexOf(part);
        if (index < 0 || index > this.folderWidget.getItemCount()) {
            this.folderWidget.getItemCount();
        }
        if (part.isHidden()) {
            return 0;
        }
        if (this.folderWidget.getSelection() != part.tab) {
            return 1;
        }
        if (!Folder.hasFocus((Control)part.getContainerWidget(), false)) {
            return 2;
        }
        return 3;
    }

    public static boolean hasFocus(Control ctl, boolean direct) {
        if (ctl == null) {
            return false;
        }
        Control c = ctl.getDisplay().getFocusControl();
        if (c == ctl) {
            return true;
        }
        if (direct) {
            return false;
        }
        while (c != null) {
            if ((c = c.getParent()) == ctl) {
                return true;
            }
            if (c != null) continue;
            return false;
        }
        return false;
    }

    public void clearPart(Part part) {
        if (part.state == 0) {
            return;
        }
        if (part.getManager() != null) {
            part.getManager().deleteView();
        }
        for (Control child : part.getContainerWidget().getChildren()) {
            if (child.isDisposed()) continue;
            child.dispose();
        }
        part.getContainerWidget().layout(true, true);
        part.state = 0;
    }

    private void closePart(Part part, boolean notify) {
        if (part.isCloseOnHide()) {
            this.removePart(part, notify);
        } else {
            part.hide();
            if (notify) {
                this.notifyPartHidden(part);
            }
        }
    }

    public void removePart(Part part) {
        this.removePart(part, true);
    }

    void removePart(Part part, boolean notify) {
        Folder folder;
        if (!part.isCloseOnHide()) {
            throw new IllegalArgumentException("Cannot close part");
        }
        if (this.parts.indexOf(part) == -1) {
            throw new IllegalArgumentException("Invalid part");
        }
        part.hide();
        this.parts.remove(part);
        this.clearPart(part);
        if (notify) {
            this.notifyPartRemoved(part);
        }
        if ((folder = (Folder)part.getParentElement()) != null) {
            this.updateFolder(folder);
        }
    }

    public String toString() {
        return Strings.ff("Folder@%d", this.internalFolderId);
    }

    @Override
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public IMElement getParentElement() {
        return this.getParentPanel();
    }

    @Override
    public List<? extends IMElement> getChildrenElements() {
        return this.parts;
    }

    public List<Part> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    @Override
    public int getPartsCount() {
        return this.parts.size();
    }

    public int getVisiblePartsCount() {
        int cnt = 0;
        for (Part part : this.parts) {
            if (part.isHidden()) continue;
            ++cnt;
        }
        if (cnt != this.folderWidget.getItemCount()) {
            throw new IllegalStateException(Strings.ff("Unexpected count of visible parts: %d, %d", cnt, this.folderWidget.getItemCount()));
        }
        return cnt;
    }

    public int getPanelShare() {
        Panel panel = this.getParentPanel();
        int ratio = panel.getSplitRatio();
        if (ratio == 100) {
            return 100;
        }
        int i = panel.getChildrenElements().indexOf(this);
        if (i == 0) {
            return ratio;
        }
        return 100 - ratio;
    }

    public void initPreset(int start, int cnt, final int autoRefreshPeriodMs) {
        for (int i = start; i < start + cnt; ++i) {
            Part part = this.addPart(false);
            part.setLabel("Item " + i);
            final StyledText text = new StyledText(part.getContainerWidget(), 0);
            text.setText("Content for Item " + i);
            this.showPart(part);
            if (autoRefreshPeriodMs <= 0) continue;
            ThreadUtil.start(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            Folder.this.getDisplay().asyncExec(() -> text.setText("Nanotime: " + System.nanoTime()));
                            Thread.sleep(autoRefreshPeriodMs);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (SWTException sWTException) {}
                }
            });
        }
    }
}

