/*
 * Decompiled with CFR 0.152.
 */
package com.pnfsoftware.jeb.rcpclient.extensions.app;

import com.pnfsoftware.jeb.rcpclient.extensions.app.DropZone;
import com.pnfsoftware.jeb.rcpclient.extensions.app.Folder;
import com.pnfsoftware.jeb.util.logging.GlobalLog;
import com.pnfsoftware.jeb.util.logging.ILogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

class DropZones {
    private static final ILogger logger = GlobalLog.getLogger();
    Display display;
    Control topLevelContainer;
    boolean includeDockingAreas;
    boolean includeSelfDockingAreas;
    CTabItem srcTab;
    CTabFolder srcFolder;
    boolean pinnedTab;
    List<DropZone> dropzones = new ArrayList<DropZone>();

    public DropZones(Control topLevelContainer, CTabItem srcTab, boolean includeDockingAreas, boolean includeSelfDockingAreas) {
        this.display = topLevelContainer.getDisplay();
        this.topLevelContainer = topLevelContainer;
        this.includeDockingAreas = includeDockingAreas;
        this.includeSelfDockingAreas = includeSelfDockingAreas;
        this.srcTab = srcTab;
        this.srcFolder = srcTab == null ? null : srcTab.getParent();
        Folder srcFolder = Folder.tabToFolder(srcTab);
        this.pinnedTab = srcFolder.getPartByTab(srcTab).isPinned();
    }

    public Control getTopLevelContainer() {
        return this.topLevelContainer;
    }

    public List<DropZone> determine() {
        this.dropzones.clear();
        this.determineRecurse(this.topLevelContainer, 0);
        return this.dropzones;
    }

    private void determineRecurse(Control ctl, int depth) {
        if (ctl instanceof Folder && ctl.isVisible()) {
            Folder folder = (Folder)ctl;
            CTabFolder cfolder = folder.getFolderWidget();
            if (cfolder.getItemCount() == 0) {
                Rectangle client = cfolder.getClientArea();
                Rectangle r = this.display.map((Control)cfolder, this.topLevelContainer, client);
                dropzone = new DropZone(this.topLevelContainer, r);
                dropzone.ctl = ctl;
                dropzone.index = 0;
                this.dropzones.add((DropZone)dropzone);
            } else {
                int index;
                int srcIndex;
                HashSet<Integer> avoidIndexes = new HashSet<Integer>();
                if (this.pinnedTab) {
                    i = 0;
                    dropzone = cfolder.getItems();
                    var8_11 = ((CTabItem[])dropzone).length;
                    for (var9_14 = 0; var9_14 < var8_11; ++var9_14) {
                        ctab = dropzone[var9_14];
                        if (!folder.getPartByTab(ctab).isPinned()) {
                            avoidIndexes.add(i + 1);
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    dropzone = cfolder.getItems();
                    var8_11 = ((CTabItem[])dropzone).length;
                    for (var9_14 = 0; var9_14 < var8_11; ++var9_14) {
                        ctab = dropzone[var9_14];
                        if (folder.getPartByTab(ctab).isPinned()) {
                            avoidIndexes.add(i);
                        }
                        ++i;
                    }
                }
                if (cfolder == this.srcFolder && (srcIndex = Arrays.asList(this.srcFolder.getItems()).indexOf(this.srcTab)) >= 0) {
                    avoidIndexes.add(srcIndex);
                    avoidIndexes.add(srcIndex + 1);
                }
                if (!avoidIndexes.contains(index = 0)) {
                    Rectangle r = this.display.map((Control)cfolder, this.topLevelContainer, new Rectangle(0, 0, 4, cfolder.getTabHeight()));
                    DropZone dropzone = new DropZone(this.topLevelContainer, r);
                    dropzone.ctl = ctl;
                    dropzone.index = 0;
                    this.dropzones.add(dropzone);
                }
                ++index;
                for (Rectangle item : cfolder.getItems()) {
                    if (!avoidIndexes.contains(index)) {
                        Rectangle b = item.getBounds();
                        int x0 = b.x + b.width - 2;
                        int width = 4;
                        if (index == cfolder.getItemCount()) {
                            Rectangle folderCA = cfolder.getClientArea();
                            width = folderCA.x + folderCA.width - x0;
                        }
                        Rectangle r = this.display.map((Control)cfolder, this.topLevelContainer, new Rectangle(x0, b.y, width, b.height));
                        DropZone dropzone = new DropZone(this.topLevelContainer, r);
                        dropzone.ctl = ctl;
                        dropzone.index = index;
                        this.dropzones.add(dropzone);
                    }
                    ++index;
                }
                if (this.includeDockingAreas && (this.includeSelfDockingAreas || cfolder != this.srcFolder)) {
                    Rectangle client = cfolder.getClientArea();
                    if (client.width >= 70 && client.height >= 70) {
                        int sqWidth = (client.width - 40) / 3;
                        int sqHeight = (client.height - 40) / 3;
                        Rectangle r = this.display.map((Control)cfolder, this.topLevelContainer, new Rectangle(client.x + 20 + sqWidth, client.y + 10, sqWidth, sqHeight));
                        DropZone dropzone = new DropZone(this.topLevelContainer, r);
                        dropzone.ctl = ctl;
                        dropzone.index = -1;
                        this.dropzones.add(dropzone);
                        r = this.display.map((Control)cfolder, this.topLevelContainer, new Rectangle(client.x + 20 + sqWidth, client.y + 30 + 2 * sqHeight, sqWidth, sqHeight));
                        dropzone = new DropZone(this.topLevelContainer, r);
                        dropzone.ctl = ctl;
                        dropzone.index = -2;
                        this.dropzones.add(dropzone);
                        r = this.display.map((Control)cfolder, this.topLevelContainer, new Rectangle(client.x + 10, client.y + 20 + sqHeight, sqWidth, sqHeight));
                        dropzone = new DropZone(this.topLevelContainer, r);
                        dropzone.ctl = ctl;
                        dropzone.index = -3;
                        this.dropzones.add(dropzone);
                        r = this.display.map((Control)cfolder, this.topLevelContainer, new Rectangle(client.x + 30 + 2 * sqWidth, client.y + 20 + sqHeight, sqWidth, sqHeight));
                        dropzone = new DropZone(this.topLevelContainer, r);
                        dropzone.ctl = ctl;
                        dropzone.index = -4;
                        this.dropzones.add(dropzone);
                    }
                }
            }
        }
        if (ctl instanceof Composite) {
            for (Control c : ((Composite)ctl).getChildren()) {
                this.determineRecurse(c, depth + 1);
            }
        }
    }
}

